/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.decoration.wall_mounted;

import java.util.List;
import java.util.Random;
import net.dark_roleplay.library.experimental.blocks.BlockSettings;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.dark_roleplay.medieval.holders.MedievalItems;
import net.dark_roleplay.medieval.objects.blocks.decoration.wall_mounted.EmptyWallMount;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LitWallMount
extends EmptyWallMount {
    @GameRegistry.ObjectHolder(value="drpmedieval:trigger_trap")
    private static Item trap;
    @GameRegistry.ObjectHolder(value="minecraft:flint")
    private static Item lighter;
    private Item emptyItem;
    private Block unlit;
    private Item mountObject;
    private double centerOffset;
    private double centerOffsetPowered;
    private double yOffset;

    public LitWallMount(String name, BlockSettings settings, AxisAlignedBB northBB, double centerOffset, double yOffset) {
        super(name, settings, northBB);
        this.func_149715_a(0.9375f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)MedievalBlockProperties.ADDON_LIGHTER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MedievalBlockProperties.ADDON_TRAP, (Comparable)Boolean.valueOf(false)));
        this.centerOffset = centerOffset;
        this.centerOffsetPowered = centerOffset - (double)0.275f;
        this.yOffset = yOffset;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
        double offsetX = (double)pos.func_177958_n() + 0.5;
        double offsetY = (double)pos.func_177956_o() + this.yOffset;
        double offsetZ = (double)pos.func_177952_p() + 0.5;
        boolean powered = (Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.POWERED);
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, offsetX + (powered ? this.centerOffsetPowered : this.centerOffset) * (double)enumfacing1.func_82601_c(), offsetY - (double)(powered ? 0.15f : 0.0f), offsetZ + (powered ? this.centerOffsetPowered : this.centerOffset) * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.FLAME, offsetX + (powered ? this.centerOffsetPowered : this.centerOffset) * (double)enumfacing1.func_82601_c(), offsetY - (double)(powered ? 0.15f : 0.0f), offsetZ + (powered ? this.centerOffsetPowered : this.centerOffset) * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState state = super.func_176203_a(meta % 4);
        if (meta > 3 && meta < 8) {
            return state.func_177226_a((IProperty)MedievalBlockProperties.ADDON_LIGHTER, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)MedievalBlockProperties.ADDON_TRAP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MedievalBlockProperties.POWERED, (Comparable)Boolean.valueOf(false));
        }
        if (meta > 7 && meta < 12) {
            return state.func_177226_a((IProperty)MedievalBlockProperties.ADDON_LIGHTER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MedievalBlockProperties.ADDON_TRAP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)MedievalBlockProperties.POWERED, (Comparable)Boolean.valueOf(false));
        }
        if (meta > 12) {
            return state.func_177226_a((IProperty)MedievalBlockProperties.ADDON_LIGHTER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MedievalBlockProperties.ADDON_TRAP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)MedievalBlockProperties.POWERED, (Comparable)Boolean.valueOf(true));
        }
        return state.func_177226_a((IProperty)MedievalBlockProperties.ADDON_LIGHTER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MedievalBlockProperties.ADDON_TRAP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MedievalBlockProperties.POWERED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = super.func_176201_c(state);
        if (((Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.ADDON_LIGHTER)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.POWERED)).booleanValue()) {
            i += 8;
        }
        return i;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MedievalBlockProperties.FACING_HORIZONTAL, MedievalBlockProperties.ADDON_LIGHTER, MedievalBlockProperties.ADDON_TRAP, MedievalBlockProperties.POWERED});
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing).func_177226_a((IProperty)MedievalBlockProperties.ADDON_TRAP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MedievalBlockProperties.ADDON_LIGHTER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MedievalBlockProperties.POWERED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!fromPos.equals((Object)pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL)).func_176734_d()))) {
            return;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
        if (!this.canBlockStay(world, pos, enumfacing)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            this.spawnAddons(world, pos, state);
        } else if (((Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.ADDON_LIGHTER)).booleanValue() && world.func_175640_z(pos)) {
            world.func_180501_a(pos, this.unlit.func_176223_P().func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL)).func_177226_a((IProperty)MedievalBlockProperties.ADDON_TRAP, state.func_177229_b((IProperty)MedievalBlockProperties.ADDON_TRAP)).func_177226_a((IProperty)MedievalBlockProperties.ADDON_LIGHTER, state.func_177229_b((IProperty)MedievalBlockProperties.ADDON_LIGHTER)).func_177226_a((IProperty)MedievalBlockProperties.POWERED, state.func_177229_b((IProperty)MedievalBlockProperties.POWERED)), 2);
        }
        super.func_189540_a(state, world, pos, block, fromPos);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            boolean consumeItems = player.field_71075_bZ.field_75098_d;
            boolean hasTrap = (Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.ADDON_TRAP);
            boolean hasLighter = (Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.ADDON_LIGHTER);
            ItemStack heldStack = player.func_184586_b(hand);
            if (heldStack.func_190926_b()) {
                if (hasTrap) {
                    state = state.func_177231_a((IProperty)MedievalBlockProperties.POWERED);
                    world.func_180501_a(pos, state, 3);
                    world.func_175684_a(pos, (Block)this, 60);
                    world.func_175684_a(pos, this.unlit, 60);
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
                    world.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL)).func_176734_d()), state.func_177230_c(), false);
                } else if (!hasLighter && player.func_70093_af()) {
                    world.func_175656_a(pos, this.unlit.func_176223_P().func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL)).func_177226_a((IProperty)MedievalBlockProperties.ADDON_LIGHTER, state.func_177229_b((IProperty)MedievalBlockProperties.ADDON_LIGHTER)).func_177226_a((IProperty)MedievalBlockProperties.ADDON_TRAP, state.func_177229_b((IProperty)MedievalBlockProperties.ADDON_TRAP)).func_177226_a((IProperty)MedievalBlockProperties.POWERED, state.func_177229_b((IProperty)MedievalBlockProperties.POWERED)));
                }
            } else if (heldStack.func_77973_b() == trap && !hasTrap) {
                if (consumeItems) {
                    player.func_184586_b(hand).func_190918_g(1);
                    this.spawnAddons(world, pos, state);
                }
                world.func_175656_a(pos, state.func_177226_a((IProperty)MedievalBlockProperties.ADDON_LIGHTER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MedievalBlockProperties.ADDON_TRAP, (Comparable)Boolean.valueOf(true)));
            } else if (heldStack.func_77973_b() == lighter && !hasTrap) {
                if (consumeItems) {
                    player.func_184586_b(hand).func_190918_g(1);
                    this.spawnAddons(world, pos, state);
                }
                world.func_175656_a(pos, state.func_177226_a((IProperty)MedievalBlockProperties.ADDON_LIGHTER, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)MedievalBlockProperties.ADDON_TRAP, (Comparable)Boolean.valueOf(false)));
            }
        }
        return true;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)MedievalBlockProperties.POWERED, (Comparable)Boolean.valueOf(false)), 3);
            world.func_175685_c(pos, (Block)this, false);
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            EnumFacing Facing = (EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
            world.func_175685_c(pos.func_177972_a(Facing.func_176734_d()), state.func_177230_c(), false);
        }
    }

    public int func_180656_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        EnumFacing Facing = EnumFacing.SOUTH;
        Facing = (EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL);
        return (Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.POWERED) == false ? 0 : (Facing == side ? 15 : 0);
    }

    @Override
    public void init(Block lit, Item mountObject) {
        this.unlit = lit;
        this.mountObject = mountObject;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList stacks = NonNullList.func_191196_a();
        if (((Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.ADDON_LIGHTER)).booleanValue()) {
            stacks.add((Object)new ItemStack(Items.field_151145_ak, 1));
        }
        if (((Boolean)state.func_177229_b((IProperty)MedievalBlockProperties.ADDON_TRAP)).booleanValue()) {
            stacks.add((Object)new ItemStack(MedievalItems.TRIGGER_TRAP, 1));
        }
        stacks.add((Object)new ItemStack(this.emptyItem == null ? (this.emptyItem = Item.func_111206_d((String)this.getRegistryName().toString().replace("_lit", "_empty"))) : this.emptyItem));
        stacks.add((Object)new ItemStack(this.mountObject));
        return stacks;
    }

    private Vec3d rotatePos(Vec3d pos, int amount) {
        switch (amount) {
            case 0: {
                return pos;
            }
            case 1: {
                return new Vec3d(1.0 - pos.field_72449_c, pos.field_72448_b, pos.field_72450_a);
            }
            case 2: {
                return new Vec3d(1.0 - pos.field_72450_a, pos.field_72448_b, 1.0 - pos.field_72449_c);
            }
            case 3: {
                return new Vec3d(pos.field_72449_c, pos.field_72448_b, 1.0 - pos.field_72450_a);
            }
        }
        return pos;
    }
}

