/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.decoration.wall_mounted;

import net.dark_roleplay.library.experimental.blocks.BlockSettings;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.dark_roleplay.medieval.objects.blocks.general.FacedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WallMounted
extends FacedBlock {
    private AxisAlignedBB northBB;
    private AxisAlignedBB eastBB;
    private AxisAlignedBB southBB;
    private AxisAlignedBB westBB;

    public WallMounted(String name, BlockSettings settings, AxisAlignedBB northBB) {
        super(name, settings);
        this.northBB = northBB;
        this.westBB = this.rotateAABB(this.northBB, 1);
        this.southBB = this.rotateAABB(this.northBB, 2);
        this.eastBB = this.rotateAABB(this.northBB, 3);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL)) {
            case EAST: {
                return this.eastBB;
            }
            case NORTH: {
                return this.northBB;
            }
            case SOUTH: {
                return this.southBB;
            }
            case WEST: {
                return this.westBB;
            }
        }
        return this.northBB;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
    }

    protected boolean canBlockStay(World world, BlockPos pos, EnumFacing facing) {
        return world.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing, true);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
            return false;
        }
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side, true);
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)MedievalBlockProperties.FACING_HORIZONTAL, (Comparable)facing);
    }

    private AxisAlignedBB rotateAABB(AxisAlignedBB bb, int amount) {
        switch (amount) {
            case 0: {
                return bb;
            }
            case 1: {
                return new AxisAlignedBB(bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
            }
            case 2: {
                return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
            }
            case 3: {
                return new AxisAlignedBB(1.0 - bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, 1.0 - bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
            }
        }
        return bb;
    }
}

