/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.general.behaviors;

import net.dark_roleplay.library.experimental.blocks.behaviors.IBoundingBoxBehavior;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class FacedBoundingBox
implements IBoundingBoxBehavior {
    private AxisAlignedBB northBB;
    private AxisAlignedBB eastBB;
    private AxisAlignedBB southBB;
    private AxisAlignedBB westBB;

    public FacedBoundingBox(AxisAlignedBB northBB) {
        this.northBB = northBB;
        this.westBB = this.rotateAABB(this.northBB, 1);
        this.southBB = this.rotateAABB(this.northBB, 2);
        this.eastBB = this.rotateAABB(this.northBB, 3);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)MedievalBlockProperties.FACING_HORIZONTAL)) {
            case EAST: {
                return this.eastBB;
            }
            case NORTH: {
                return this.northBB;
            }
            case SOUTH: {
                return this.southBB;
            }
            case WEST: {
                return this.westBB;
            }
        }
        return this.northBB;
    }

    private AxisAlignedBB rotateAABB(AxisAlignedBB bb, int amount) {
        switch (amount) {
            case 0: {
                return bb;
            }
            case 1: {
                return new AxisAlignedBB(bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
            }
            case 2: {
                return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
            }
            case 3: {
                return new AxisAlignedBB(1.0 - bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, 1.0 - bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
            }
        }
        return bb;
    }
}

