/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.utility.other.regenerating_ore;

import java.util.Map;
import java.util.Random;
import net.dark_roleplay.library.experimental.blocks.BlockSettings;
import net.dark_roleplay.library.experimental.blocks.DRPBlock;
import net.dark_roleplay.library.experimental.variables.wrappers.IntegerWrapper;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.dark_roleplay.medieval.holders.configs.Miscellaneous;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RegeneratingOre
extends DRPBlock {
    Block ore = null;
    IBlockState oreState = null;
    IntegerWrapper regenTime = null;

    public RegeneratingOre(String name, BlockSettings settings, int toolLevel, IntegerWrapper regenTime) {
        super(name, settings);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)MedievalBlockProperties.ORE_LIMIT, (Comparable)Integer.valueOf(3)));
        this.regenTime = regenTime;
        this.setHarvestLevel("pickaxe", toolLevel);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 4));
        items.add((Object)new ItemStack((Block)this, 1, 10));
        items.add((Object)new ItemStack((Block)this, 1, 15));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MedievalBlockProperties.ORE_LIMIT, (Comparable)Integer.valueOf(Math.max(meta % 4, 1))).func_177226_a((IProperty)MedievalBlockProperties.ORE_COUNT, (Comparable)Integer.valueOf(((meta & 0xC) >> 2) % 4));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MedievalBlockProperties.ORE_LIMIT) + ((Integer)state.func_177229_b((IProperty)MedievalBlockProperties.ORE_COUNT) << 2 & 0xC);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MedievalBlockProperties.ORE_LIMIT, MedievalBlockProperties.ORE_COUNT});
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        int ore = (Integer)state.func_177229_b((IProperty)MedievalBlockProperties.ORE_COUNT);
        if (ore <= 0 && !player.func_184812_l_()) {
            world.markAndNotifyBlock(pos, null, state, state, world.field_72995_K ? 11 : 3);
            return false;
        }
        if (ore <= 0 && player.func_184812_l_()) {
            this.func_176208_a(world, pos, state, player);
            return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
        }
        this.func_176208_a(world, pos, state, player);
        if (!world.func_184145_b(pos, state.func_177230_c())) {
            world.func_180497_b(pos, state.func_177230_c(), Miscellaneous.REGEN_TIME_IRON, 0);
        }
        return world.func_180501_a(pos, state.func_177226_a((IProperty)MedievalBlockProperties.ORE_COUNT, (Comparable)Integer.valueOf(ore - 1)), world.field_72995_K ? 11 : 3);
    }

    public void setOre(Block ore) {
        this.ore = ore;
        this.oreState = ore.func_176223_P();
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        ItemStack heldItem = player.func_184614_ca();
        int fortune = 0;
        ItemStack minedStack = ItemStack.field_190927_a;
        if (heldItem.func_77948_v()) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)heldItem);
            if (enchantments.get(Enchantments.field_185308_t) != null) {
                fortune = (Integer)enchantments.get(Enchantments.field_185308_t);
                minedStack = new ItemStack(this.ore.func_180660_a(this.oreState, player.func_70681_au(), fortune), this.ore.func_149679_a(fortune, player.func_70681_au()), this.ore.func_180651_a(this.oreState));
            }
            if (enchantments.get(Enchantments.field_185306_r) != null) {
                minedStack = this.ore.func_185473_a(world, pos, this.oreState);
            }
        } else {
            minedStack = new ItemStack(this.ore.func_180660_a(this.oreState, player.func_70681_au(), fortune), this.ore.func_149679_a(fortune, player.func_70681_au()), this.ore.func_180651_a(this.oreState));
        }
        if (!player.func_191521_c(minedStack)) {
            world.func_72838_d((Entity)new EntityItem(world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), minedStack));
        }
        player.func_71023_q(this.ore.getExpDrop(this.oreState, (IBlockAccess)world, pos, fortune));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int ore = (Integer)state.func_177229_b((IProperty)MedievalBlockProperties.ORE_COUNT);
        int oreLimit = (Integer)state.func_177229_b((IProperty)MedievalBlockProperties.ORE_LIMIT);
        world.func_180501_a(pos, state.func_177226_a((IProperty)MedievalBlockProperties.ORE_COUNT, (Comparable)Integer.valueOf(Math.min(ore + 1, oreLimit))), world.field_72995_K ? 11 : 3);
        if (ore + 1 < oreLimit) {
            world.func_180497_b(pos, state.func_177230_c(), this.regenTime.get(), 0);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        System.out.println(meta);
        return this.func_176203_a(meta == 0 ? 4 : (meta == 1 ? 10 : 15));
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return ItemStack.field_190927_a;
    }
}

