/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.utility.storage.chests.simple_chest;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dark_roleplay.core.api.storage.DynamicStorageTileEntity;
import net.dark_roleplay.medieval.DarkRoleplayMedieval;
import net.dark_roleplay.medieval.holders.MedievalASMHolder;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.dark_roleplay.medieval.objects.blocks.utility.storage.chests.simple_chest.SimpleChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;

public class TileEntitySimpleChest
extends DynamicStorageTileEntity {
    @Nullable
    public final IAnimationStateMachine asm;
    public final TimeValues.VariableValue clickTime = new TimeValues.VariableValue(Float.NEGATIVE_INFINITY);

    public TileEntitySimpleChest() {
        super(27);
        this.asm = DarkRoleplayMedieval.proxy.load(MedievalASMHolder.SimpleChest.ASM_FILE, (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"click_time", (Object)this.clickTime));
    }

    public void handleEvents(float time, Iterable<Event> pastEvents) {
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public void goToAnimation(String stage) {
        if (!this.asm.currentState().equals("opening") && !this.asm.currentState().equals("closing")) {
            this.clickTime.setValue(Animation.getWorldTime((World)this.func_145831_w()));
        }
        this.asm.transition(stage);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        return (T)super.getCapability(capability, side);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("inventoryMain")) {
            super.func_145839_a(compound);
        } else {
            NBTTagList newItems = new NBTTagList();
            NBTTagList list = compound.func_150295_c("inventory", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                byte b = tag.func_74771_c("slot");
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74768_a("Slot", (int)b);
                new ItemStack(tag).func_77955_b(itemTag);
            }
            NBTTagCompound newInventory = new NBTTagCompound();
            newInventory.func_74782_a("Items", (NBTBase)newItems);
            newInventory.func_74768_a("Size", 27);
            compound.func_74782_a("inventoryMain", (NBTBase)newInventory);
            super.func_145839_a(compound);
        }
        if (this.func_145830_o() && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() instanceof SimpleChest && ((Boolean)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)MedievalBlockProperties.IS_OPEN)).booleanValue()) {
            this.goToAnimation("open");
        }
    }
}

