/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.utility.storage.shelfs;

import net.dark_roleplay.medieval.objects.blocks.utility.storage.shelfs.TileEnittyUniversalShelf;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.opengl.GL11;

public class ShelfRenderInformation {
    private ItemMap[] slots = new ItemMap[0];
    private RenderItem itemRenderer;

    public ShelfRenderInformation(TileEnittyUniversalShelf te, RenderItem itemRenderer, Vec3d ... offsets) {
        IItemHandler invHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.slots = new ItemMap[invHandler.getSlots()];
        for (int i = 0; i < invHandler.getSlots(); ++i) {
            this.slots[i] = new ItemMap(ItemStack.field_190927_a, null, offsets[i]);
        }
        this.itemRenderer = itemRenderer;
    }

    public ItemMap[] getSlots() {
        return this.slots;
    }

    public class ItemMap {
        public ItemStack stack;
        public IBakedModel model;
        public Vec3d offset;

        public ItemMap(ItemStack stack, IBakedModel model, Vec3d offset) {
            this.stack = stack;
            this.model = model;
            this.offset = offset;
        }

        public void refresh(ItemStack stack, World world) {
            if (this.stack.equals(stack)) {
                return;
            }
            this.model = ShelfRenderInformation.this.itemRenderer.func_184393_a(stack, world, (EntityLivingBase)null);
            this.stack = stack;
        }

        public void render() {
            if (this.stack != null && this.model != null) {
                GL11.glPushMatrix();
                GlStateManager.func_179137_b((double)this.offset.field_72450_a, (double)this.offset.field_72448_b, (double)this.offset.field_72449_c);
                GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
                ShelfRenderInformation.this.itemRenderer.func_180454_a(this.stack, ForgeHooksClient.handleCameraTransforms((IBakedModel)this.model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.NONE, (boolean)false));
                GL11.glPopMatrix();
            }
        }
    }
}

