/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.blocks.utility.storage.shelfs;

import javax.annotation.Nullable;
import net.dark_roleplay.medieval.objects.blocks.utility.storage.shelfs.ShelfRenderInformation;
import net.dark_roleplay.medieval.objects.other.MultiStackHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEnittyUniversalShelf
extends TileEntity {
    private ShelfRenderInformation renderInformation;
    private MultiStackHandler itemStackHandler;
    private Vec3d[] offsets;

    public TileEnittyUniversalShelf(int size, Vec3d ... offsets) {
        this.offsets = offsets;
        this.itemStackHandler = new MultiStackHandler(size, 2){

            protected void onContentsChanged(int slot) {
                TileEnittyUniversalShelf.this.func_70296_d();
                IBlockState state = TileEnittyUniversalShelf.this.field_145850_b.func_180495_p(TileEnittyUniversalShelf.this.func_174877_v());
                TileEnittyUniversalShelf.this.field_145850_b.func_184138_a(TileEnittyUniversalShelf.this.func_174877_v(), state, state, 2);
            }
        };
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        return compound;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 8.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public ShelfRenderInformation getRenderInformation(RenderItem itemRenderer) {
        if (this.renderInformation == null) {
            this.renderInformation = new ShelfRenderInformation(this, itemRenderer, this.offsets);
        }
        return this.renderInformation;
    }
}

