/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.guis.hud.timbered_clay;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import net.dark_roleplay.core_modules.guis.api.huds.Hud;
import net.dark_roleplay.medieval.objects.blocks.building.timbered_clay.TimberedClay;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class TimberedClayHud
extends Hud {
    private boolean enabled = true;

    public TimberedClayHud(ResourceLocation registryName) {
        super(registryName);
        this.posX = 0;
        this.posY = 0;
        this.alignment = Hud.ALIGNMENT.LEFT;
    }

    public void render(int width, int height, float partialTicks) {
        if (!this.enabled) {
            return;
        }
        if (TimberedClay.clicks.containsKey(Minecraft.func_71410_x().field_71439_g)) {
            TimberedClay.ClickInfo info = TimberedClay.clicks.get(Minecraft.func_71410_x().field_71439_g);
            int baseX = this.alignment.getBaseX(width, 0) + this.posX;
            int baseY = this.alignment.getBaseY(height, 0) + this.posY;
            IBlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(info.getPos());
            if (!(state.func_177230_c() instanceof TimberedClay)) {
                return;
            }
            String[] types = state.func_177230_c().getRegistryName().func_110623_a().split("_timbered_clay_");
            if (TimberedClay.recipes.containsKey(types[1])) {
                List recipes = TimberedClay.recipes.get(types[1]).stream().filter(rec -> rec.getLoc1() == info.getLoc() || rec.getLoc2() == info.getLoc()).collect(Collectors.toList());
                int amount = recipes.size();
                int yOffset = -(amount * 18 / 2);
                int i = 0;
                float[] mult1 = this.getMultipliers(info.getLoc());
                for (TimberedClay.TimberRecipe recipe : recipes) {
                    recipe.getLoc1();
                    float[] mult2 = this.getMultipliers(recipe.getLoc1() == info.getLoc() ? recipe.getLoc2() : recipe.getLoc1());
                    Hud.drawCenteredRect((int)(baseX + 8), (int)(baseY + 8 + yOffset + i * 18), (int)9, (double)0.0, (int)-1358954496);
                    TimberedClayHud.drawLine((int)(baseX + 3 + (int)(mult1[0] * 10.0f)), (int)(baseY + 3 + yOffset + i * 18 + (int)(mult1[1] * 10.0f)), (int)(baseX + 3 + (int)(mult2[0] * 10.0f)), (int)(baseY + 3 + yOffset + i * 18 + (int)(mult2[1] * 10.0f)), (int)-86);
                    Hud.drawCenteredRect((int)(baseX + 3 + (int)(mult1[0] * 10.0f)), (int)(baseY + 3 + yOffset + i * 18 + (int)(mult1[1] * 10.0f)), (int)2, (double)0.0, (int)-21846);
                    Hud.drawCenteredRect((int)(baseX + 3 + (int)(mult2[0] * 10.0f)), (int)(baseY + 3 + yOffset + i * 18 + (int)(mult2[1] * 10.0f)), (int)2, (double)0.0, (int)-5570646);
                    ++i;
                }
            }
        }
    }

    private float[] getMultipliers(TimberedClay.ClickLoc loc) {
        float[] multipliers;
        switch (loc) {
            case BOTTOM: {
                multipliers = new float[]{0.5f, 1.0f};
                break;
            }
            case BOTTOM_LEFT: {
                multipliers = new float[]{0.0f, 1.0f};
                break;
            }
            case BOTTOM_RIGHT: {
                multipliers = new float[]{1.0f, 1.0f};
                break;
            }
            case CENTER: {
                multipliers = new float[]{0.5f, 0.5f};
                break;
            }
            case LEFT: {
                multipliers = new float[]{0.0f, 0.5f};
                break;
            }
            case RIGHT: {
                multipliers = new float[]{1.0f, 0.5f};
                break;
            }
            case TOP: {
                multipliers = new float[]{0.5f, 0.0f};
                break;
            }
            case TOP_LEFT: {
                multipliers = new float[]{0.0f, 0.0f};
                break;
            }
            case TOP_RIGHT: {
                multipliers = new float[]{1.0f, 0.0f};
                break;
            }
            default: {
                multipliers = new float[]{0.0f, 0.0f};
            }
        }
        return multipliers;
    }

    public JsonObject writeToDefaultConfig() {
        JsonObject obj = super.writeToDefaultConfig();
        obj.addProperty("enabled", Boolean.valueOf(true));
        return obj;
    }

    public void readFromConfig(JsonObject obj) {
        super.readFromConfig(obj);
        this.enabled = obj.has("enabled") ? obj.get("enabled").getAsBoolean() : true;
    }
}

