/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.guis.sign_drawing;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import net.dark_roleplay.medieval.holders.MedievalNetwork;
import net.dark_roleplay.medieval.objects.blocks.decoration.shop_signs.TileEntityShopSign;
import net.dark_roleplay.medieval.objects.other.ImageConversion;
import net.dark_roleplay.medieval.objects.packets.blocks.SyncPacket_ShopSign;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiSignDrawing
extends GuiScreen {
    private BufferedImage img;
    private ResourceLocation imgLoc;
    private boolean imgChanged = false;
    private static final int COLOR_BLACK = new Color(0, 0, 0).getRGB();
    private static final int COLOR_BG = new Color(98, 75, 61).getRGB();
    private static final int COLOR_INVISIBLE = new Color(0, 0, 0, 0).getRGB();
    private static final int COLOR_DRAWING_1 = new Color(32, 16, 0, 255).getRGB();
    private static final int COLOR_DRAWING_2 = new Color(48, 32, 0, 255).getRGB();
    private static final int COLOR_DRAWING_3 = new Color(64, 48, 0, 255).getRGB();
    private int drawWidth = 32;
    private int drawHeight = 24;
    TileEntityShopSign te;
    int[] imgBuf;
    private int sizeX;
    private int sizeY;
    private int scaleFactor = 8;
    private int posX;
    private int posY;
    private boolean leftDown = false;
    private boolean rightDown = false;

    public GuiSignDrawing(TileEntityShopSign te) {
        this.te = te;
        if (te.getIMG() != null) {
            this.imgBuf = ImageConversion.bufToIntAr(te.getIMG());
        } else {
            this.imgBuf = new int[this.drawWidth * this.drawHeight];
            for (int i = 0; i < this.imgBuf.length; ++i) {
                int line = i / this.drawWidth % 2;
                this.imgBuf[i] = COLOR_INVISIBLE;
            }
        }
        this.img = ImageConversion.intArToBuf(this.drawWidth, this.drawHeight, this.imgBuf);
        this.imgLoc = Minecraft.func_71410_x().func_110434_K().func_110578_a("gui_carve_carving", new DynamicTexture(this.img));
    }

    public void func_73866_w_() {
        this.sizeX = this.drawWidth * this.scaleFactor;
        this.sizeY = this.drawHeight * this.scaleFactor;
        this.posX = (this.field_146294_l - this.sizeX) / 2;
        this.posY = (this.field_146295_m - this.sizeY) / 2;
    }

    public void func_146281_b() {
        this.te.setDrawing(this.img);
        MedievalNetwork.sendToServer((IMessage)new SyncPacket_ShopSign(this.te));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.imgChanged) {
            this.imgLoc = Minecraft.func_71410_x().func_110434_K().func_110578_a("gui_carve_carving", new DynamicTexture(this.img));
            this.imgChanged = false;
        }
        this.field_146297_k.func_110434_K().func_110577_a(this.imgLoc);
        GuiSignDrawing.func_73734_a((int)this.posX, (int)this.posY, (int)(this.posX + this.sizeX), (int)(this.posY + this.sizeY), (int)COLOR_BG);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiSignDrawing.drawFullTextureScaled(this.posX, this.posY, this.sizeX, this.sizeY);
        GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
        this.drawLines(this.posX, this.posY, this.sizeX, this.sizeY);
        if (this.leftDown) {
            this.mouseDragged(mouseX, mouseY, 0);
        } else if (this.rightDown) {
            this.mouseDragged(mouseX, mouseY, 1);
        }
    }

    private void drawLines(int posX, int posY, int sizeX, int sizeY) {
        int i;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glLineWidth((float)1.0f);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        for (i = 0; i < this.drawWidth + 1; ++i) {
            this.drawVerLine(posX + this.scaleFactor * i, posY, sizeY);
        }
        for (i = 0; i < this.drawHeight + 1; ++i) {
            this.drawHorLine(posX, posY + this.scaleFactor * i, sizeX);
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    private void drawHorLine(int posX, int posY, int length) {
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)posX, (float)posY);
        GL11.glVertex2f((float)(posX + length), (float)posY);
        GL11.glEnd();
    }

    private void drawVerLine(int posX, int posY, int length) {
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)posX, (float)posY);
        GL11.glVertex2f((float)posX, (float)(posY + length));
        GL11.glEnd();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int posX = (mouseX - this.posX) / this.scaleFactor;
        int posY = (mouseY - this.posY) / this.scaleFactor;
        if (posX >= 0 && posX < this.drawWidth && posY >= 0 && posY < this.drawHeight) {
            this.imgBuf[posX + this.drawWidth * posY] = mouseButton == 0 ? COLOR_DRAWING_1 : COLOR_INVISIBLE;
            this.img = ImageConversion.intArToBuf(this.drawWidth, this.drawHeight, this.imgBuf);
            this.imgChanged = true;
        }
        if (mouseButton == 0) {
            this.leftDown = true;
        } else {
            this.rightDown = true;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (state == 0) {
            this.leftDown = false;
        } else {
            this.rightDown = false;
        }
    }

    protected void mouseDragged(int mouseX, int mouseY, int mouseButton) {
        int posX = (mouseX - this.posX) / this.scaleFactor;
        int posY = (mouseY - this.posY) / this.scaleFactor;
        if (posX >= 0 && posX < this.drawWidth && posY >= 0 && posY < this.drawHeight) {
            this.imgBuf[posX + this.drawWidth * posY] = mouseButton == 0 ? COLOR_DRAWING_1 : COLOR_INVISIBLE;
            this.img = ImageConversion.intArToBuf(this.drawWidth, this.drawHeight, this.imgBuf);
            this.imgChanged = true;
        }
    }

    public static void drawFullTextureScaled(int x, int y, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

