/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.items.blocks;

import net.dark_roleplay.library_old.items.DRPItem;
import net.dark_roleplay.medieval.holders.MedievalBlockProperties;
import net.dark_roleplay.medieval.holders.MedievalBlocks;
import net.dark_roleplay.medieval.objects.blocks.building.hanging_bridge.HangingBridge;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemHangingBridge
extends DRPItem {
    public ItemHangingBridge(String name, String itemFolder, int stackSize, String ... subNames) {
        super(name, itemFolder, stackSize, subNames);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound comp = new NBTTagCompound();
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(comp);
        } else {
            comp = stack.func_77978_p();
        }
        if (player.func_70093_af()) {
            if (comp.func_74764_b("pos1X")) {
                comp.func_82580_o("pos1X");
                comp.func_82580_o("pos1Y");
                comp.func_82580_o("pos1Z");
                player.func_145747_a((ITextComponent)new TextComponentString("Position has been cleared!"));
            }
            stack.func_77982_d(comp);
            return EnumActionResult.SUCCESS;
        }
        if (!comp.func_74764_b("pos1X")) {
            comp.func_74768_a("pos1X", pos.func_177958_n());
            comp.func_74768_a("pos1Y", pos.func_177956_o());
            comp.func_74768_a("pos1Z", pos.func_177952_p());
            stack.func_77982_d(comp);
            player.func_145747_a((ITextComponent)new TextComponentString("First Position set to: " + pos.func_177958_n() + "|" + pos.func_177956_o() + "|" + pos.func_177952_p()));
        } else {
            int drop;
            int i;
            BlockPos pos2 = new BlockPos(comp.func_74762_e("pos1X"), comp.func_74762_e("pos1Y"), comp.func_74762_e("pos1Z"));
            if (pos.func_177956_o() != pos2.func_177956_o()) {
                player.func_145747_a((ITextComponent)new TextComponentString("Booth ends of the Hangingbridge need to be on the same level!"));
                stack.func_77982_d(null);
                return EnumActionResult.SUCCESS;
            }
            int dist = (int)pos.func_185332_f(pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            if (dist > 65) {
                comp.func_82580_o("pos1X");
                comp.func_82580_o("pos1Y");
                comp.func_82580_o("pos1Z");
                stack.func_77982_d(comp);
                player.func_145747_a((ITextComponent)new TextComponentString("The Distance is to big! (maximum 64 blocks yours is: " + dist + "Blocks"));
                stack.func_77982_d(null);
                return EnumActionResult.SUCCESS;
            }
            if (pos.func_177958_n() != pos2.func_177958_n() && pos.func_177952_p() != pos2.func_177952_p()) {
                player.func_145747_a((ITextComponent)new TextComponentString("Hanging Bridges cannot be placed diagonally!"));
                stack.func_77982_d(null);
                return EnumActionResult.SUCCESS;
            }
            if (stack.func_190916_E() < dist - 1 && !player.field_71075_bZ.field_75098_d) {
                player.func_145747_a((ITextComponent)new TextComponentString("You are missing " + (dist - 1 - stack.func_190916_E()) + " Hangingbridges!"));
                stack.func_77982_d(null);
                return EnumActionResult.SUCCESS;
            }
            int posX1 = pos.func_177958_n();
            int posX2 = pos2.func_177958_n();
            int posZ1 = pos.func_177952_p();
            int posZ2 = pos2.func_177952_p();
            int length = posX1 == posX2 ? (posZ1 > posZ2 ? posZ1 - posZ2 : posZ2 - posZ1) : (posX1 > posX2 ? posX1 - posX2 : posX2 - posX1);
            double offsetX1 = (double)length / 2.0;
            double offsetX2 = (double)length / 2.0;
            double x1 = Math.pow(offsetX1, 2.0);
            double x2 = Math.pow(offsetX2, 2.0);
            double y1 = -offsetX1;
            double y2 = offsetX2;
            double r1 = length / 2;
            double r2 = length / 2;
            double x3 = x1 * Math.abs(y2);
            double x4 = x2 * Math.abs(y1);
            double y3 = y1 * Math.abs(y2);
            double y4 = y2 * Math.abs(y1);
            double r3 = r1 * Math.abs(y2);
            double r4 = r2 * Math.abs(y1);
            double x5 = x3 + x4;
            double r5 = r3 + r4;
            double a = r5 / x5;
            double b = (a * x1 - r1) / -y1;
            for (i = 1; i < length; ++i) {
                BlockPos placePos;
                drop = (int)(a * Math.pow(i - length / 2, 2.0) + (b * (double)i - (double)(length / 2)));
                if (posX1 == posX2) {
                    placePos = posZ1 > posZ2 ? pos2.func_177982_a(0, -Math.abs(drop / 16), i) : pos.func_177982_a(0, -Math.abs(drop / 16), i);
                } else {
                    BlockPos blockPos = placePos = posX1 > posX2 ? pos2.func_177982_a(i, -Math.abs(drop / 16), 0) : pos.func_177982_a(i, -Math.abs(drop / 16), 0);
                }
                if (world.func_175623_d(placePos)) continue;
                player.func_145747_a((ITextComponent)new TextComponentString("Path is Obstructed! Cannot place Bridge here!"));
                stack.func_77982_d(null);
                return EnumActionResult.SUCCESS;
            }
            for (i = 1; i < length; ++i) {
                IBlockState state;
                BlockPos placePos;
                drop = (int)(a * Math.pow(i - length / 2, 2.0) + (b * (double)i - (double)(length / 2)));
                if (posX1 == posX2) {
                    BlockPos blockPos = placePos = posZ1 > posZ2 ? pos2.func_177982_a(0, -Math.abs(drop / 16), i) : pos.func_177982_a(0, -Math.abs(drop / 16), i);
                    if (drop % 16 / 8 == 0) {
                        state = MedievalBlocks.HANGING_BRIDGE_TOP.func_176223_P().func_177226_a(MedievalBlockProperties.AXIS_HORIZONTAL, (Comparable)EnumFacing.Axis.X).func_177226_a((IProperty)HangingBridge.HEIGHT, (Comparable)Integer.valueOf(7 - Math.abs(drop % 8)));
                        world.func_175656_a(placePos, state);
                    } else {
                        state = MedievalBlocks.HANGING_BRIDGE_BOTTOM.func_176223_P().func_177226_a(MedievalBlockProperties.AXIS_HORIZONTAL, (Comparable)EnumFacing.Axis.X).func_177226_a((IProperty)HangingBridge.HEIGHT, (Comparable)Integer.valueOf(7 - Math.abs(drop % 8)));
                        world.func_175656_a(placePos, state);
                    }
                    world.markAndNotifyBlock(placePos, world.func_175726_f(placePos), world.func_180495_p(placePos), state, 3);
                    continue;
                }
                BlockPos blockPos = placePos = posX1 > posX2 ? pos2.func_177982_a(i, -Math.abs(drop / 16), 0) : pos.func_177982_a(i, -Math.abs(drop / 16), 0);
                if (drop % 16 / 8 == 0) {
                    state = MedievalBlocks.HANGING_BRIDGE_TOP.func_176223_P().func_177226_a(MedievalBlockProperties.AXIS_HORIZONTAL, (Comparable)EnumFacing.Axis.Z).func_177226_a((IProperty)HangingBridge.HEIGHT, (Comparable)Integer.valueOf(7 - Math.abs(drop % 8)));
                    world.func_175656_a(placePos, state);
                } else {
                    state = MedievalBlocks.HANGING_BRIDGE_BOTTOM.func_176223_P().func_177226_a(MedievalBlockProperties.AXIS_HORIZONTAL, (Comparable)EnumFacing.Axis.Z).func_177226_a((IProperty)HangingBridge.HEIGHT, (Comparable)Integer.valueOf(7 - Math.abs(drop % 8)));
                    world.func_175656_a(placePos, state);
                }
                world.markAndNotifyBlock(placePos, world.func_175726_f(placePos), world.func_180495_p(placePos), state, 3);
            }
            stack.func_190918_g(dist - 1);
            stack.func_77982_d(null);
        }
        return EnumActionResult.SUCCESS;
    }
}

