/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.other;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import net.minecraft.nbt.NBTTagCompound;

public class ImageConversion {
    public static NBTTagCompound imgToNBT(BufferedImage img) {
        NBTTagCompound imgNBT = new NBTTagCompound();
        int[] imageBytes = ((DataBufferInt)img.getData().getDataBuffer()).getData();
        imgNBT.func_74768_a("width", img.getWidth());
        imgNBT.func_74768_a("height", img.getHeight());
        imgNBT.func_74783_a("imgBuf", imageBytes);
        return imgNBT;
    }

    public static BufferedImage imgFromNBT(NBTTagCompound imgNBT) {
        if (!(imgNBT.func_74764_b("width") && imgNBT.func_74764_b("height") && imgNBT.func_74764_b("imgBuf"))) {
            return null;
        }
        int width = imgNBT.func_74762_e("width");
        int height = imgNBT.func_74762_e("height");
        int[] imgBuf = imgNBT.func_74759_k("imgBuf");
        if (imgBuf == null) {
            return null;
        }
        return ImageConversion.intArToBuf(width, height, imgBuf);
    }

    public static BufferedImage intArToBuf(int width, int height, int[] imageBuf) {
        BufferedImage image = new BufferedImage(width, height, 2);
        image.setData(Raster.createRaster(image.getSampleModel(), new DataBufferInt(imageBuf, imageBuf.length), new Point()));
        return image;
    }

    public static int[] bufToIntAr(BufferedImage img) {
        return ((DataBufferInt)img.getData().getDataBuffer()).getData();
    }
}

