/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.other;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class MultiStackHandler
extends ItemStackHandler {
    protected int[] stackSizes;
    protected int slotMultiplier = 4;

    public MultiStackHandler() {
        this(1);
    }

    public MultiStackHandler(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.stackSizes = new int[size];
    }

    public MultiStackHandler(int size, int slotMultiplier) {
        this(size);
        this.slotMultiplier = slotMultiplier;
    }

    public MultiStackHandler(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
        this.stackSizes = new int[stacks.size()];
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.stackSizes[i] = ((ItemStack)this.stacks.get(i)).func_190916_E();
            ((ItemStack)this.stacks.get(i)).func_190920_e(1);
        }
    }

    public void setSize(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.stackSizes = new int[size];
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        if (ItemStack.func_77989_b((ItemStack)((ItemStack)this.stacks.get(slot)), (ItemStack)stack)) {
            return;
        }
        this.stackSizes[slot] = stack.func_190916_E();
        stack.func_190920_e(1);
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        ItemStack out = (ItemStack)this.stacks.get(slot);
        if (out.func_190926_b()) {
            return out;
        }
        out = this.stackSizes[slot] >= out.func_77976_d() ? ItemHandlerHelper.copyStackWithSize((ItemStack)out, (int)out.func_77976_d()) : ItemHandlerHelper.copyStackWithSize((ItemStack)out, (int)this.stackSizes[slot]);
        return out;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int amount = this.stackSizes[slot];
        int limit = this.getStackLimit(slot, stack) * this.slotMultiplier;
        int remaining = limit - amount;
        if (remaining <= 0) {
            return stack;
        }
        if (existing.func_190926_b() || stack.func_77969_a(existing) && ItemStack.func_77970_a((ItemStack)existing, (ItemStack)stack)) {
            if (stack.func_190916_E() <= remaining) {
                if (!simulate) {
                    this.stackSizes[slot] = amount + stack.func_190916_E();
                    if (existing.func_190926_b()) {
                        this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    }
                    this.onContentsChanged(slot);
                }
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() > remaining) {
                if (!simulate) {
                    this.stackSizes[slot] = amount + remaining;
                    if (existing.func_190926_b()) {
                        this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    }
                    this.onContentsChanged(slot);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - remaining));
            }
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(Math.min(amount, existing.func_77976_d()), this.stackSizes[slot]);
        if (!simulate) {
            if (toExtract == this.stackSizes[slot]) {
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
            }
            int n = slot;
            this.stackSizes[n] = this.stackSizes[n] - toExtract;
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("amount", this.stackSizes[i]);
            itemTag.func_74768_a("slot", i);
            ((ItemStack)this.stacks.get(i)).func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("items", (NBTBase)nbtTagList);
        nbt.func_74768_a("size", this.stacks.size());
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.setSize(nbt.func_74764_b("size") ? nbt.func_74762_e("size") : 1);
        NBTTagList tagList = (NBTTagList)nbt.func_74781_a("items");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int amount = itemTags.func_74762_e("amount");
            this.stacks.set(itemTags.func_74762_e("slot"), (Object)new ItemStack(itemTags));
            this.stackSizes[itemTags.func_74762_e((String)"slot")] = amount;
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }
}

