/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.packets.blocks;

import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import net.dark_roleplay.library.networking.PacketBase;
import net.dark_roleplay.medieval.objects.blocks.decoration.shop_signs.TileEntityShopSign;
import net.dark_roleplay.medieval.objects.other.ImageConversion;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SyncPacket_ShopSign
extends PacketBase.Server<SyncPacket_ShopSign> {
    BufferedImage img;
    BlockPos pos;

    public SyncPacket_ShopSign() {
        this.img = null;
        this.pos = null;
    }

    public SyncPacket_ShopSign(TileEntityShopSign te) {
        this.img = te.getIMG();
        this.pos = te.func_174877_v();
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        int width = buf.readInt();
        int height = buf.readInt();
        int[] imageBytes = new int[width * height];
        for (int i = 0; i < imageBytes.length; ++i) {
            imageBytes[i] = buf.readInt();
        }
        this.img = ImageConversion.intArToBuf(width, height, imageBytes);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.img.getWidth());
        buf.writeInt(this.img.getHeight());
        int[] imageBytes = ((DataBufferInt)this.img.getData().getDataBuffer()).getData();
        for (int i = 0; i < imageBytes.length; ++i) {
            buf.writeInt(imageBytes[i]);
        }
    }

    public void handleServerSide(final SyncPacket_ShopSign message, final EntityPlayer player) {
        player.func_184102_h().func_152344_a(new Runnable(){

            @Override
            public void run() {
                World world = player.func_130014_f_();
                TileEntity tileEntity = world.func_175625_s(message.pos);
                if (!(tileEntity instanceof TileEntityShopSign)) {
                    return;
                }
                TileEntityShopSign te = (TileEntityShopSign)tileEntity;
                te.setDrawing(message.img);
            }
        });
    }
}

