/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.world_gen.materials;

import java.util.Random;
import net.dark_roleplay.medieval.holders.MedievalBlocks;
import net.dark_roleplay.medieval.holders.configs.WorldGen;
import net.dark_roleplay.medieval.objects.world_gen.materials.SimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class DryClayGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!WorldGen.GENERATE_DRY_CLAY) {
            return;
        }
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    public void generateOverworld(World world, Random rand, int x, int z) {
        Random rnd = new Random(world.func_72905_C());
        int xOffset = rnd.nextInt(1000);
        int zOffset = rnd.nextInt(1000);
        float frequency = 800.0f;
        for (int x2 = 1; x2 <= 16; ++x2) {
            for (int z2 = 1; z2 <= 16; ++z2) {
                int x3 = x + x2;
                int z3 = z + z2;
                float chance = SimplexNoise.noise(x3 + xOffset, z3 + zOffset, frequency);
                if (!(chance > 0.9f)) continue;
                int y = this.getHeighestOccurence((Block)Blocks.field_150349_c, world, x3, z3);
                if (y == 0) {
                    y = this.getHeighestOccurence(Blocks.field_150346_d, world, x3, z3);
                }
                if (y == 0) continue;
                for (int i = 0; i < 5; ++i) {
                    if (y <= 0) {
                        ++z;
                        continue;
                    }
                    BlockPos pos = new BlockPos(x3, y - i, z3);
                    Block b = this.getBlockToPlace(world, pos);
                    if (b == Blocks.field_150350_a) continue;
                    world.func_175656_a(pos, b.func_176223_P());
                }
            }
        }
    }

    public Block getBlockToPlace(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != Blocks.field_150346_d && block != Blocks.field_150349_c) {
            return Blocks.field_150350_a;
        }
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150355_j) {
            return Blocks.field_150435_aG;
        }
        if (block == Blocks.field_150349_c) {
            return MedievalBlocks.DRY_CLAY_GRASS;
        }
        return MedievalBlocks.DRY_CLAY;
    }

    public int getHeighestOccurence(Block block, World world, int x, int z) {
        for (int i = world.func_72940_L(); i > 32; --i) {
            if (world.func_180495_p(new BlockPos(x, i, z)).func_177230_c() != block) continue;
            return i;
        }
        return 0;
    }
}

