/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.objects.world_gen.village.carpenter;

import java.util.List;
import java.util.Random;
import net.dark_roleplay.medieval.holders.MedievalVillagers;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class CarpenterHouse
extends StructureVillagePieces.House1 {
    private static final ResourceLocation STRUCTURE_RES_LOC = new ResourceLocation("drpmedieval", "new_carpenter_house");
    private static final int X_SIZE = 9;
    private static final int Y_SIZE = 10;
    private static final int Z_SIZE = 14;
    private int averageGroundLevel = -1;

    public CarpenterHouse() {
    }

    public CarpenterHouse(StructureBoundingBox boundingBox, EnumFacing par5) {
        this.func_186164_a(par5);
        this.field_74887_e = boundingBox;
    }

    public static CarpenterHouse buildComponent(List<StructureComponent> pieces, int p1, int p2, int p3, EnumFacing p4) {
        StructureBoundingBox boundingBox = StructureBoundingBox.func_175897_a((int)p1, (int)p2, (int)p3, (int)0, (int)0, (int)0, (int)9, (int)10, (int)14, (EnumFacing)p4);
        return CarpenterHouse.func_74895_a((StructureBoundingBox)boundingBox) && StructureComponent.func_74883_a(pieces, (StructureBoundingBox)boundingBox) == null ? new CarpenterHouse(boundingBox, p4) : null;
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, sbb);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 10 - 2, 0);
        }
        this.spawnActualHouse(world, sbb);
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 14; ++j) {
                this.func_74871_b(world, i, 10, j, sbb);
                this.func_175808_b(world, Blocks.field_150346_d.func_176223_P(), i, -1, j, sbb);
            }
        }
        this.func_74893_a(world, sbb, 3, 1, 5, 1);
        return true;
    }

    private void fillWithBlocks(World world, StructureBoundingBox sbb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block block) {
        this.func_175804_a(world, sbb, minX, minY, minZ, maxX, maxY, maxZ, block.func_176223_P(), block.func_176223_P(), false);
    }

    private void spawnActualHouse(World world, StructureBoundingBox sbb) {
        TemplateManager manager = world.func_72860_G().func_186340_h();
        MinecraftServer server = world.func_73046_m();
        if (manager != null && server != null) {
            Rotation rotation;
            Mirror mirror;
            EnumFacing facing = this.func_186165_e();
            if (facing == EnumFacing.SOUTH) {
                mirror = Mirror.NONE;
                rotation = Rotation.NONE;
            } else if (facing == EnumFacing.WEST) {
                mirror = Mirror.NONE;
                rotation = Rotation.CLOCKWISE_90;
            } else if (facing == EnumFacing.EAST) {
                mirror = Mirror.LEFT_RIGHT;
                rotation = Rotation.CLOCKWISE_90;
            } else {
                mirror = Mirror.LEFT_RIGHT;
                rotation = Rotation.NONE;
            }
            PlacementSettings placement = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_186223_a(sbb);
            Template template = manager.func_186237_a(server, STRUCTURE_RES_LOC);
            if (template != null) {
                template.func_186253_b(world, new BlockPos(this.func_74865_a(0, 0), this.func_74862_a(0), this.func_74873_b(0, 0)), placement);
            }
        }
    }

    protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof) {
        return MedievalVillagers.CARPENTER;
    }
}

