/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.medieval.testing.blockstate_loading;

import net.dark_roleplay.medieval.testing.blockstate_loading.ModelRenderer;
import net.dark_roleplay.medieval.testing.blockstate_loading.TextureQuad;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelCube {
    private final PositionTextureVertex[] vertexPositions;
    private final TextureQuad[] quadList;
    public final float posX1;
    public final float posY1;
    public final float posZ1;
    public final float posX2;
    public final float posY2;
    public final float posZ2;
    public String boxName;

    public ModelCube(ModelRenderer renderer, int texU, int texV, float x, float y, float z, float dx, float dy, float dz, float delta) {
        this(renderer, texU, texV, x, y, z, dx, dy, dz, delta, renderer.mirror);
    }

    public ModelCube(ModelRenderer renderer, int texU, int texV, float x, float y, float z, float dx, float dy, float dz, float delta, boolean mirror) {
        this.posX1 = x;
        this.posY1 = y;
        this.posZ1 = z;
        this.posX2 = x + dx;
        this.posY2 = y + dy;
        this.posZ2 = z + dz;
        this.vertexPositions = new PositionTextureVertex[8];
        this.quadList = new TextureQuad[6];
        float f = x + dx;
        float f1 = y + dy;
        float f2 = z + dz;
        x -= delta;
        y -= delta;
        z -= delta;
        f += delta;
        f1 += delta;
        f2 += delta;
        if (mirror) {
            float f3 = f;
            f = x;
            x = f3;
        }
        PositionTextureVertex positiontexturevertex7 = new PositionTextureVertex(x, y, z, 0.0f, 0.0f);
        PositionTextureVertex positiontexturevertex = new PositionTextureVertex(f, y, z, 0.0f, 8.0f);
        PositionTextureVertex positiontexturevertex1 = new PositionTextureVertex(f, f1, z, 8.0f, 8.0f);
        PositionTextureVertex positiontexturevertex2 = new PositionTextureVertex(x, f1, z, 8.0f, 0.0f);
        PositionTextureVertex positiontexturevertex3 = new PositionTextureVertex(x, y, f2, 0.0f, 0.0f);
        PositionTextureVertex positiontexturevertex4 = new PositionTextureVertex(f, y, f2, 0.0f, 8.0f);
        PositionTextureVertex positiontexturevertex5 = new PositionTextureVertex(f, f1, f2, 8.0f, 8.0f);
        PositionTextureVertex positiontexturevertex6 = new PositionTextureVertex(x, f1, f2, 8.0f, 0.0f);
        this.vertexPositions[0] = positiontexturevertex7;
        this.vertexPositions[1] = positiontexturevertex;
        this.vertexPositions[2] = positiontexturevertex1;
        this.vertexPositions[3] = positiontexturevertex2;
        this.vertexPositions[4] = positiontexturevertex3;
        this.vertexPositions[5] = positiontexturevertex4;
        this.vertexPositions[6] = positiontexturevertex5;
        this.vertexPositions[7] = positiontexturevertex6;
        this.quadList[0] = new TextureQuad(new PositionTextureVertex[]{positiontexturevertex4, positiontexturevertex, positiontexturevertex1, positiontexturevertex5}, (float)Math.ceil((float)texU + dz + dx), (float)Math.ceil((float)texV + dz), (float)texU + dz + dx + dz, (float)texV + dz + dy, renderer.textureWidth, renderer.textureHeight);
        this.quadList[1] = new TextureQuad(new PositionTextureVertex[]{positiontexturevertex7, positiontexturevertex3, positiontexturevertex6, positiontexturevertex2}, (float)Math.ceil(texU), (float)Math.ceil((float)texV + dz), (float)texU + dz, (float)texV + dz + dy, renderer.textureWidth, renderer.textureHeight);
        this.quadList[2] = new TextureQuad(new PositionTextureVertex[]{positiontexturevertex4, positiontexturevertex3, positiontexturevertex7, positiontexturevertex}, (float)Math.ceil((float)texU + dz), (float)Math.ceil(texV), (float)texU + dz + dx, (float)texV + dz, renderer.textureWidth, renderer.textureHeight);
        this.quadList[3] = new TextureQuad(new PositionTextureVertex[]{positiontexturevertex1, positiontexturevertex2, positiontexturevertex6, positiontexturevertex5}, (float)Math.ceil((float)texU + dz + dx), (float)Math.ceil((float)texV + dz), (float)texU + dz + dx + dx, texV, renderer.textureWidth, renderer.textureHeight);
        this.quadList[4] = new TextureQuad(new PositionTextureVertex[]{positiontexturevertex, positiontexturevertex7, positiontexturevertex2, positiontexturevertex1}, (float)Math.ceil((float)texU + dz), (float)Math.ceil((float)texV + dz), (float)texU + dz + dx, (float)texV + dz + dy, renderer.textureWidth, renderer.textureHeight);
        this.quadList[5] = new TextureQuad(new PositionTextureVertex[]{positiontexturevertex3, positiontexturevertex4, positiontexturevertex5, positiontexturevertex6}, (float)Math.ceil((float)texU + dz + dx + dz), (float)Math.ceil((float)texV + dz), (float)texU + dz + dx + dz + dx, (float)texV + dz + dy, renderer.textureWidth, renderer.textureHeight);
        if (mirror) {
            for (TextureQuad texturedquad : this.quadList) {
                texturedquad.flipFace();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(BufferBuilder renderer, float scale) {
        for (TextureQuad texturedquad : this.quadList) {
            texturedquad.draw(renderer, scale);
        }
    }

    public ModelCube setBoxName(String name) {
        this.boxName = name;
        return this;
    }
}

