/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.loading.FileLoader;
import software.bernie.geckolib.loading.json.FormatVersion;
import software.bernie.geckolib.loading.json.raw.Model;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.loading.object.BakedModelFactory;
import software.bernie.geckolib.loading.object.GeometryTree;
import software.bernie.geckolib.util.CompoundException;

public final class GeckoLibCache {
    private static final Set<String> EXCLUDED_NAMESPACES = ObjectOpenHashSet.of((Object)"moreplayermodels", (Object)"customnpcs", (Object)"gunsrpg");
    private static Map<class_2960, BakedAnimations> ANIMATIONS = Collections.emptyMap();
    private static Map<class_2960, BakedGeoModel> MODELS = Collections.emptyMap();

    public static Map<class_2960, BakedAnimations> getBakedAnimations() {
        return ANIMATIONS;
    }

    public static Map<class_2960, BakedGeoModel> getBakedModels() {
        return MODELS;
    }

    public static void registerReloadListener() {
        class_3300 class_33002;
        class_310 mc = class_310.method_1551();
        if (mc != null && (class_33002 = mc.method_1478()) instanceof class_3304) {
            class_3304 resourceManager = (class_3304)class_33002;
            resourceManager.method_14477(GeckoLibCache::reload);
        }
    }

    public static CompletableFuture<Void> reload(class_3302.class_4045 stage, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap models = new Object2ObjectOpenHashMap();
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = GeckoLibCache.loadAnimations(backgroundExecutor, resourceManager, ((Map)animations)::put);
        completableFutureArray[1] = GeckoLibCache.loadModels(backgroundExecutor, resourceManager, ((Map)models)::put);
        return ((CompletableFuture)CompletableFuture.allOf(completableFutureArray).thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0))).thenAcceptAsync(arg_0 -> GeckoLibCache.lambda$reload$0((Map)animations, (Map)models, arg_0), gameExecutor);
    }

    private static CompletableFuture<Void> loadAnimations(Executor backgroundExecutor, class_3300 resourceManager, BiConsumer<class_2960, BakedAnimations> elementConsumer) {
        return GeckoLibCache.loadResources(backgroundExecutor, resourceManager, "animations", resource -> {
            try {
                return FileLoader.loadAnimationsFile(resource, resourceManager);
            }
            catch (CompoundException ex) {
                ex.withMessage(resource.toString() + ": Error loading animation file").printStackTrace();
                return new BakedAnimations((Map<String, Animation>)new Object2ObjectOpenHashMap());
            }
            catch (Exception ex) {
                throw GeckoLibConstants.exception(resource, "Error loading animation file", ex);
            }
        }, elementConsumer);
    }

    private static CompletableFuture<Void> loadModels(Executor backgroundExecutor, class_3300 resourceManager, BiConsumer<class_2960, BakedGeoModel> elementConsumer) {
        return GeckoLibCache.loadResources(backgroundExecutor, resourceManager, "geo", resource -> {
            try {
                Model model = FileLoader.loadModelFile(resource, resourceManager);
                if (model.formatVersion() != FormatVersion.V_1_12_0) {
                    throw new IllegalArgumentException("Unsupported geometry json version. Supported versions: 1.12.0");
                }
                return BakedModelFactory.getForNamespace(resource.method_12836()).constructGeoModel(GeometryTree.fromModel(model));
            }
            catch (Exception ex) {
                throw GeckoLibConstants.exception(resource, "Error loading model file", ex);
            }
        }, elementConsumer);
    }

    private static <T> CompletableFuture<Void> loadResources(Executor executor, class_3300 resourceManager, String type, Function<class_2960, T> loader, BiConsumer<class_2960, T> map) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> resourceManager.method_14488(type, fileName -> fileName.toString().endsWith(".json")), executor).thenApplyAsync(resources -> {
            Object2ObjectOpenHashMap tasks = new Object2ObjectOpenHashMap();
            for (class_2960 resource : resources.keySet()) {
                tasks.put(resource, CompletableFuture.supplyAsync(() -> loader.apply(resource), executor));
            }
            return tasks;
        }, executor)).thenAcceptAsync(tasks -> {
            for (Map.Entry entry : tasks.entrySet()) {
                if (EXCLUDED_NAMESPACES.contains(((class_2960)entry.getKey()).method_12836().toLowerCase(Locale.ROOT))) continue;
                map.accept((class_2960)entry.getKey(), ((CompletableFuture)entry.getValue()).join());
            }
        }, executor);
    }

    public static synchronized void registerNamespaceExclusion(String namespace) {
        EXCLUDED_NAMESPACES.add(namespace);
    }

    private static /* synthetic */ void lambda$reload$0(Map animations, Map models, Void empty) {
        ANIMATIONS = animations;
        MODELS = models;
    }
}

