/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.object;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.loading.json.raw.Bone;
import software.bernie.geckolib.loading.json.raw.Cube;
import software.bernie.geckolib.loading.json.raw.FaceUV;
import software.bernie.geckolib.loading.json.raw.ModelProperties;
import software.bernie.geckolib.loading.json.raw.UVUnion;
import software.bernie.geckolib.loading.object.BoneStructure;
import software.bernie.geckolib.loading.object.GeometryTree;
import software.bernie.geckolib.util.RenderUtil;

public interface BakedModelFactory {
    public static final Map<String, BakedModelFactory> FACTORIES = new Object2ObjectOpenHashMap(1);
    public static final BakedModelFactory DEFAULT_FACTORY = new Builtin();

    public BakedGeoModel constructGeoModel(GeometryTree var1);

    public GeoBone constructBone(BoneStructure var1, ModelProperties var2, @Nullable GeoBone var3);

    public GeoCube constructCube(Cube var1, ModelProperties var2, GeoBone var3);

    default public GeoQuad[] buildQuads(UVUnion uvUnion, VertexSet vertices, Cube cube, float textureWidth, float textureHeight, boolean mirror) {
        GeoQuad[] quads = new GeoQuad[]{this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, class_2350.field_11039), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, class_2350.field_11034), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, class_2350.field_11043), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, class_2350.field_11035), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, class_2350.field_11036), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, class_2350.field_11033)};
        return quads;
    }

    default public GeoQuad buildQuad(VertexSet vertices, Cube cube, UVUnion uvUnion, float textureWidth, float textureHeight, boolean mirror, class_2350 direction) {
        double[][] dArrayArray;
        if (!uvUnion.isBoxUV()) {
            FaceUV faceUV = uvUnion.faceUV().fromDirection(direction);
            if (faceUV == null) {
                return null;
            }
            return GeoQuad.build(vertices.verticesForQuad(direction, false, mirror || cube.mirror() == Boolean.TRUE), faceUV.uv(), faceUV.uvSize(), textureWidth, textureHeight, mirror, direction);
        }
        double[] uv = cube.uv().boxUVCoords();
        double[] uvSize = cube.size();
        class_243 uvSizeVec = new class_243(Math.floor(uvSize[0]), Math.floor(uvSize[1]), Math.floor(uvSize[2]));
        switch (direction) {
            default: {
                throw new MatchException(null, null);
            }
            case field_11039: {
                double[][] dArrayArray2 = new double[2][];
                dArrayArray2[0] = new double[]{uv[0] + uvSizeVec.field_1350 + uvSizeVec.field_1352, uv[1] + uvSizeVec.field_1350};
                dArrayArray = dArrayArray2;
                dArrayArray2[1] = new double[]{uvSizeVec.field_1350, uvSizeVec.field_1351};
                break;
            }
            case field_11034: {
                double[][] dArrayArray3 = new double[2][];
                dArrayArray3[0] = new double[]{uv[0], uv[1] + uvSizeVec.field_1350};
                dArrayArray = dArrayArray3;
                dArrayArray3[1] = new double[]{uvSizeVec.field_1350, uvSizeVec.field_1351};
                break;
            }
            case field_11043: {
                double[][] dArrayArray4 = new double[2][];
                dArrayArray4[0] = new double[]{uv[0] + uvSizeVec.field_1350, uv[1] + uvSizeVec.field_1350};
                dArrayArray = dArrayArray4;
                dArrayArray4[1] = new double[]{uvSizeVec.field_1352, uvSizeVec.field_1351};
                break;
            }
            case field_11035: {
                double[][] dArrayArray5 = new double[2][];
                dArrayArray5[0] = new double[]{uv[0] + uvSizeVec.field_1350 + uvSizeVec.field_1352 + uvSizeVec.field_1350, uv[1] + uvSizeVec.field_1350};
                dArrayArray = dArrayArray5;
                dArrayArray5[1] = new double[]{uvSizeVec.field_1352, uvSizeVec.field_1351};
                break;
            }
            case field_11036: {
                double[][] dArrayArray6 = new double[2][];
                dArrayArray6[0] = new double[]{uv[0] + uvSizeVec.field_1350, uv[1]};
                dArrayArray = dArrayArray6;
                dArrayArray6[1] = new double[]{uvSizeVec.field_1352, uvSizeVec.field_1350};
                break;
            }
            case field_11033: {
                double[][] dArrayArray7 = new double[2][];
                dArrayArray7[0] = new double[]{uv[0] + uvSizeVec.field_1350 + uvSizeVec.field_1352, uv[1] + uvSizeVec.field_1350};
                dArrayArray = dArrayArray7;
                dArrayArray7[1] = new double[]{uvSizeVec.field_1352, -uvSizeVec.field_1350};
            }
        }
        double[][] uvData = dArrayArray;
        return GeoQuad.build(vertices.verticesForQuad(direction, true, mirror || cube.mirror() == Boolean.TRUE), uvData[0], uvData[1], textureWidth, textureHeight, mirror, direction);
    }

    public static BakedModelFactory getForNamespace(String namespace) {
        return FACTORIES.getOrDefault(namespace, DEFAULT_FACTORY);
    }

    public static void register(String namespace, BakedModelFactory factory) {
        FACTORIES.put(namespace, factory);
    }

    public record VertexSet(GeoVertex bottomLeftBack, GeoVertex bottomRightBack, GeoVertex topLeftBack, GeoVertex topRightBack, GeoVertex topLeftFront, GeoVertex topRightFront, GeoVertex bottomLeftFront, GeoVertex bottomRightFront) {
        public VertexSet(class_243 origin, class_243 vertexSize, double inflation) {
            this(new GeoVertex(origin.field_1352 - inflation, origin.field_1351 - inflation, origin.field_1350 - inflation), new GeoVertex(origin.field_1352 - inflation, origin.field_1351 - inflation, origin.field_1350 + vertexSize.field_1350 + inflation), new GeoVertex(origin.field_1352 - inflation, origin.field_1351 + vertexSize.field_1351 + inflation, origin.field_1350 - inflation), new GeoVertex(origin.field_1352 - inflation, origin.field_1351 + vertexSize.field_1351 + inflation, origin.field_1350 + vertexSize.field_1350 + inflation), new GeoVertex(origin.field_1352 + vertexSize.field_1352 + inflation, origin.field_1351 + vertexSize.field_1351 + inflation, origin.field_1350 - inflation), new GeoVertex(origin.field_1352 + vertexSize.field_1352 + inflation, origin.field_1351 + vertexSize.field_1351 + inflation, origin.field_1350 + vertexSize.field_1350 + inflation), new GeoVertex(origin.field_1352 + vertexSize.field_1352 + inflation, origin.field_1351 - inflation, origin.field_1350 - inflation), new GeoVertex(origin.field_1352 + vertexSize.field_1352 + inflation, origin.field_1351 - inflation, origin.field_1350 + vertexSize.field_1350 + inflation));
        }

        public GeoVertex[] quadWest() {
            return new GeoVertex[]{this.topRightBack, this.topLeftBack, this.bottomLeftBack, this.bottomRightBack};
        }

        public GeoVertex[] quadEast() {
            return new GeoVertex[]{this.topLeftFront, this.topRightFront, this.bottomRightFront, this.bottomLeftFront};
        }

        public GeoVertex[] quadNorth() {
            return new GeoVertex[]{this.topLeftBack, this.topLeftFront, this.bottomLeftFront, this.bottomLeftBack};
        }

        public GeoVertex[] quadSouth() {
            return new GeoVertex[]{this.topRightFront, this.topRightBack, this.bottomRightBack, this.bottomRightFront};
        }

        public GeoVertex[] quadUp() {
            return new GeoVertex[]{this.topRightBack, this.topRightFront, this.topLeftFront, this.topLeftBack};
        }

        public GeoVertex[] quadDown() {
            return new GeoVertex[]{this.bottomLeftBack, this.bottomLeftFront, this.bottomRightFront, this.bottomRightBack};
        }

        public GeoVertex[] verticesForQuad(class_2350 direction, boolean boxUv, boolean mirror) {
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11039 -> {
                    if (mirror) {
                        yield this.quadEast();
                    }
                    yield this.quadWest();
                }
                case class_2350.field_11034 -> {
                    if (mirror) {
                        yield this.quadWest();
                    }
                    yield this.quadEast();
                }
                case class_2350.field_11043 -> this.quadNorth();
                case class_2350.field_11035 -> this.quadSouth();
                case class_2350.field_11036 -> {
                    if (mirror && !boxUv) {
                        yield this.quadDown();
                    }
                    yield this.quadUp();
                }
                case class_2350.field_11033 -> mirror && !boxUv ? this.quadUp() : this.quadDown();
            };
        }
    }

    public static final class Builtin
    implements BakedModelFactory {
        @Override
        public BakedGeoModel constructGeoModel(GeometryTree geometryTree) {
            ObjectArrayList bones = new ObjectArrayList();
            for (BoneStructure boneStructure : geometryTree.topLevelBones().values()) {
                bones.add(this.constructBone(boneStructure, geometryTree.properties(), null));
            }
            return new BakedGeoModel((List<GeoBone>)bones, geometryTree.properties());
        }

        @Override
        public GeoBone constructBone(BoneStructure boneStructure, ModelProperties properties, GeoBone parent) {
            Bone bone = boneStructure.self();
            GeoBone newBone = new GeoBone(parent, bone.name(), bone.mirror(), bone.inflate(), bone.neverRender(), bone.reset());
            class_243 rotation = RenderUtil.arrayToVec(bone.rotation());
            class_243 pivot = RenderUtil.arrayToVec(bone.pivot());
            newBone.updateRotation((float)Math.toRadians(-rotation.field_1352), (float)Math.toRadians(-rotation.field_1351), (float)Math.toRadians(rotation.field_1350));
            newBone.updatePivot((float)(-pivot.field_1352), (float)pivot.field_1351, (float)pivot.field_1350);
            for (Cube cube : bone.cubes()) {
                newBone.getCubes().add(this.constructCube(cube, properties, newBone));
            }
            for (BoneStructure child : boneStructure.children().values()) {
                newBone.getChildBones().add(this.constructBone(child, properties, newBone));
            }
            return newBone;
        }

        @Override
        public GeoCube constructCube(Cube cube, ModelProperties properties, GeoBone bone) {
            boolean mirror;
            boolean bl = mirror = cube.mirror() == Boolean.TRUE;
            double inflate = cube.inflate() != null ? cube.inflate() / 16.0 : (bone.getInflate() == null ? 0.0 : bone.getInflate() / 16.0);
            class_243 size = RenderUtil.arrayToVec(cube.size());
            class_243 origin = RenderUtil.arrayToVec(cube.origin());
            class_243 rotation = RenderUtil.arrayToVec(cube.rotation());
            class_243 pivot = RenderUtil.arrayToVec(cube.pivot());
            origin = new class_243(-(origin.field_1352 + size.field_1352) / 16.0, origin.field_1351 / 16.0, origin.field_1350 / 16.0);
            class_243 vertexSize = size.method_18805(0.0625, 0.0625, 0.0625);
            pivot = pivot.method_18805(-1.0, 1.0, 1.0);
            rotation = new class_243(Math.toRadians(-rotation.field_1352), Math.toRadians(-rotation.field_1351), Math.toRadians(rotation.field_1350));
            GeoQuad[] quads = this.buildQuads(cube.uv(), new VertexSet(origin, vertexSize, inflate), cube, (float)properties.textureWidth(), (float)properties.textureHeight(), mirror);
            return new GeoCube(quads, pivot, rotation, size, inflate, mirror);
        }
    }
}

