/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.model;

import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoReplacedEntity;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationProcessor;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.loading.math.MathParser;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.util.RenderUtil;

public abstract class GeoModel<T extends GeoAnimatable> {
    private final AnimationProcessor<T> processor = new AnimationProcessor(this);
    private BakedGeoModel currentModel = null;
    private double animTime;
    private double lastGameTickTime;
    private long lastRenderedInstance = -1L;

    public abstract class_2960 getModelResource(T var1);

    public abstract class_2960 getTextureResource(T var1);

    public abstract class_2960 getAnimationResource(T var1);

    public boolean crashIfBoneMissing() {
        return false;
    }

    @Nullable
    public class_1921 getRenderType(T animatable, class_2960 texture) {
        return class_1921.method_23578((class_2960)texture);
    }

    public BakedGeoModel getBakedModel(class_2960 location) {
        BakedGeoModel model = GeckoLibCache.getBakedModels().get(location);
        if (model == null) {
            if (!location.method_12832().contains("geo/")) {
                throw GeckoLibConstants.exception(location, "Invalid model resource path provided - GeckoLib models must be placed in assets/<modid>/geo/");
            }
            throw GeckoLibConstants.exception(location, "Unable to find model");
        }
        if (model != this.currentModel) {
            this.processor.setActiveModel(model);
            this.currentModel = model;
        }
        return this.currentModel;
    }

    public Optional<GeoBone> getBone(String name) {
        return Optional.ofNullable(this.getAnimationProcessor().getBone(name));
    }

    public Animation getAnimation(T animatable, String name) {
        class_2960 location = this.getAnimationResource(animatable);
        BakedAnimations bakedAnimations = GeckoLibCache.getBakedAnimations().get(location);
        if (bakedAnimations == null) {
            if (!location.method_12832().contains("animations/")) {
                throw GeckoLibConstants.exception(location, "Invalid animation resource path provided - GeckoLib animations must be placed in assets/<modid>/animations/");
            }
            throw GeckoLibConstants.exception(location, "Unable to find animation file.");
        }
        return bakedAnimations.getAnimation(name);
    }

    public AnimationProcessor<T> getAnimationProcessor() {
        return this.processor;
    }

    public void addAdditionalStateData(T animatable, long instanceId, BiConsumer<DataTicket<T>, T> dataConsumer) {
    }

    @ApiStatus.Internal
    public void handleAnimations(T animatable, long instanceId, AnimationState<T> animationState, float partialTick) {
        boolean isReRender;
        class_310 mc = class_310.method_1551();
        AnimatableManager animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(instanceId);
        Double currentTick = animationState.getData(DataTickets.TICK);
        if (currentTick == null) {
            double d;
            if (animatable instanceof class_1297) {
                class_1297 entity = (class_1297)animatable;
                d = entity.field_6012;
            } else {
                d = RenderUtil.getCurrentTick();
            }
            currentTick = d;
        }
        if (animatableManager.getFirstTickTime() == -1.0) {
            animatableManager.startedAt(currentTick + (double)partialTick);
        }
        double currentFrameTime = animatable instanceof class_1297 || animatable instanceof GeoReplacedEntity ? currentTick + (double)partialTick : currentTick - animatableManager.getFirstTickTime();
        boolean bl = isReRender = !animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime();
        if (isReRender && instanceId == this.lastRenderedInstance) {
            return;
        }
        if (!mc.method_1493() || animatable.shouldPlayAnimsWhileGamePaused()) {
            animatableManager.updatedAt(currentFrameTime);
            double lastUpdateTime = animatableManager.getLastUpdateTime();
            this.animTime += lastUpdateTime - this.lastGameTickTime;
            this.lastGameTickTime = lastUpdateTime;
        }
        animationState.animationTick = this.animTime;
        this.lastRenderedInstance = instanceId;
        AnimationProcessor<T> processor = this.getAnimationProcessor();
        processor.preAnimationSetup(animationState, this.animTime);
        if (!processor.getRegisteredBones().isEmpty()) {
            processor.tickAnimation(animatable, this, animatableManager, this.animTime, animationState, this.crashIfBoneMissing());
        }
        this.setCustomAnimations(animatable, instanceId, animationState);
    }

    public void setCustomAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
    }

    public void applyMolangQueries(AnimationState<T> animationState, double animTime) {
        class_310 mc = class_310.method_1551();
        T animatable = animationState.getAnimatable();
        MathParser.setVariable("query.life_time", () -> animTime / 20.0);
        MathParser.setVariable("query.actor_count", () -> ((class_638)mc.field_1687).method_18120());
        MathParser.setVariable("query.time_of_day", () -> (float)mc.field_1687.method_8532() / 24000.0f);
        MathParser.setVariable("query.moon_phase", () -> ((class_638)mc.field_1687).method_30273());
        if (animatable instanceof class_1297) {
            class_1297 entity = (class_1297)animatable;
            MathParser.setVariable("query.distance_from_camera", () -> mc.field_1773.method_19418().method_19326().method_1022(entity.method_19538()));
            MathParser.setVariable("query.is_on_ground", () -> RenderUtil.booleanToFloat(entity.method_24828()));
            MathParser.setVariable("query.is_in_water", () -> RenderUtil.booleanToFloat(entity.method_5799()));
            MathParser.setVariable("query.is_in_water_or_rain", () -> RenderUtil.booleanToFloat(entity.method_5637()));
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                MathParser.setVariable("query.health", () -> ((class_1309)livingEntity).method_6032());
                MathParser.setVariable("query.max_health", () -> ((class_1309)livingEntity).method_6063());
                MathParser.setVariable("query.is_on_fire", () -> RenderUtil.booleanToFloat(livingEntity.method_5809()));
                MathParser.setVariable("query.ground_speed", () -> {
                    class_243 velocity = livingEntity.method_18798();
                    return class_3532.method_15355((float)((float)(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350)));
                });
                MathParser.setVariable("query.yaw_speed", () -> livingEntity.method_5705((float)animTime - livingEntity.method_5705((float)animTime - 0.1f)));
            }
        }
    }
}

