/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.core.LootManager;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final List<String> CLIENT_DEFAULT_RENDER_AS_BLOCK = ImmutableList.of((Object)"minecraft:oak_sapling", (Object)"minecraft:birch_sapling", (Object)"minecraft:spruce_sapling", (Object)"minecraft:jungle_sapling", (Object)"minecraft:acacia_sapling", (Object)"minecraft:dark_oak_sapling", (Object)"minecraft:cobweb", (Object)"minecraft:grass", (Object)"minecraft:dead_bush", (Object)"minecraft:fern", (Object)"minecraft:seagrass", (Object)"minecraft:sea_pickle", (Object[])new String[]{"minecraft:dandelion", "minecraft:poppy", "minecraft:blue_orchid", "minecraft:allium", "minecraft:azure_bluet", "minecraft:red_tulip", "minecraft:orange_tulip", "minecraft:white_tulip", "minecraft:pink_tulip", "minecraft:oxeye_daisy", "minecraft:cornflower", "minecraft:lily_of_the_valley", "minecraft:wither_rose", "minecraft:brown_mushroom", "minecraft:red_mushroom", "minecraft:crimson_fungus", "minecraft:warped_fungus", "minecraft:crimson_roots", "minecraft:warped_roots", "minecraft:nether_sprouts", "minecraft:weeping_vines", "minecraft:twisting_vines", "minecraft:sugar_cane", "minecraft:kelp", "minecraft:bamboo", "minecraft:torch", "minecraft:end_rod", "minecraft:soul_torch", "minecraft:chain", "minecraft:vine", "minecraft:lily_pad", "minecraft:flower_pot", "minecraft:sunflower", "minecraft:lilac", "minecraft:rose_bush", "minecraft:peony", "minecraft:tall_grass", "minecraft:large_fern", "minecraft:glass_pane", "minecraft:white_stained_glass_pane", "minecraft:orange_stained_glass_pane", "minecraft:magenta_stained_glass_pane", "minecraft:light_blue_stained_glass_pane", "minecraft:yellow_stained_glass_pane", "minecraft:lime_stained_glass_pane", "minecraft:pink_stained_glass_pane", "minecraft:gray_stained_glass_pane", "minecraft:light_gray_stained_glass_pane", "minecraft:cyan_stained_glass_pane", "minecraft:purple_stained_glass_pane", "minecraft:blue_stained_glass_pane", "minecraft:brown_stained_glass_pane", "minecraft:green_stained_glass_pane", "minecraft:red_stained_glass_pane", "minecraft:black_stained_glass_pane", "minecraft:tube_coral", "minecraft:brain_coral", "minecraft:bubble_coral", "minecraft:fire_coral", "minecraft:horn_coral", "minecraft:dead_brain_coral", "minecraft:dead_bubble_coral", "minecraft:dead_horn_coral", "minecraft:dead_tube_coral", "minecraft:tube_coral_fan", "minecraft:brain_coral_fan", "minecraft:bubble_coral_fan", "minecraft:fire_coral_fan", "minecraft:horn_coral_fan", "minecraft:dead_tube_coral_fan", "minecraft:dead_brain_coral_fan", "minecraft:dead_bubble_coral_fan", "minecraft:dead_fire_coral_fan", "minecraft:dead_horn_coral_fan", "minecraft:oak_sign", "minecraft:spruce_sign", "minecraft:birch_sign", "minecraft:jungle_sign", "minecraft:acacia_sign", "minecraft:dark_oak_sign", "minecraft:crimson_sign", "minecraft:warped_sign", "minecraft:campfire", "minecraft:lantern", "minecraft:soul_lantern", "minecraft:bell", "minecraft:soul_campfire", "minecraft:redstone_torch", "minecraft:lever", "minecraft:tripwire_hook", "minecraft:string", "minecraft:hopper", "minecraft:iron_door", "minecraft:oak_door", "minecraft:spruce_door", "minecraft:birch_door", "minecraft:jungle_door", "minecraft:acacia_door", "minecraft:dark_oak_door", "minecraft:crimson_door", "minecraft:warped_door", "minecraft:repeater", "minecraft:comparator", "minecraft:redstone", "minecraft:rail", "minecraft:powered_rail", "minecraft:detector_rail", "minecraft:activator_rail", "minecraft:cake", "lightmanscurrency:coinpile_copper", "lightmanscurrency:coinpile_iron", "lightmanscurrency:coinpile_gold", "lightmanscurrency:coinpile_emerald", "lightmanscurrency:coinpile_diamond", "lightmanscurrency:coinpile_netherite", "minecraft:small_amethyst_bud", "minecraft:medium_amethyst_bud", "minecraft:large_amethyst_bud", "minecraft:amethyst_cluster", "minecraft:glow_berries", "minecraft:glow_lichen", "minecraft:lightning_rod"});
    private static boolean canMint = false;
    private static boolean canMelt = false;
    private static boolean mintCopper = false;
    private static boolean mintIron = false;
    private static boolean mintGold = false;
    private static boolean mintEmerald = false;
    private static boolean mintDiamond = false;
    private static boolean mintNetherite = false;
    private static boolean meltCopper = false;
    private static boolean meltIron = false;
    private static boolean meltGold = false;
    private static boolean meltEmerald = false;
    private static boolean meltDiamond = false;
    private static boolean meltNetherite = false;
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    public static boolean canMint() {
        return canMint;
    }

    public static boolean localCanMint() {
        return (Boolean)Config.COMMON.allowCoinMinting.get();
    }

    public static boolean canMelt() {
        return canMelt;
    }

    public static boolean localCanMelt() {
        return (Boolean)Config.COMMON.allowCoinMelting.get();
    }

    public static boolean canMint(Item item) {
        if (item == ModItems.COIN_COPPER) {
            return mintCopper;
        }
        if (item == ModItems.COIN_IRON) {
            return mintIron;
        }
        if (item == ModItems.COIN_GOLD) {
            return mintGold;
        }
        if (item == ModItems.COIN_EMERALD) {
            return mintEmerald;
        }
        if (item == ModItems.COIN_DIAMOND) {
            return mintDiamond;
        }
        if (item == ModItems.COIN_NETHERITE) {
            return mintNetherite;
        }
        return true;
    }

    public static boolean canMelt(Item item) {
        if (item == ModItems.COIN_COPPER) {
            return meltCopper;
        }
        if (item == ModItems.COIN_IRON) {
            return meltIron;
        }
        if (item == ModItems.COIN_GOLD) {
            return meltGold;
        }
        if (item == ModItems.COIN_EMERALD) {
            return meltEmerald;
        }
        if (item == ModItems.COIN_DIAMOND) {
            return meltDiamond;
        }
        if (item == ModItems.COIN_NETHERITE) {
            return meltNetherite;
        }
        return true;
    }

    public static CompoundTag getSyncData() {
        CompoundTag data = new CompoundTag();
        data.m_128379_("canMint", ((Boolean)Config.COMMON.allowCoinMinting.get()).booleanValue());
        data.m_128379_("canMelt", ((Boolean)Config.COMMON.allowCoinMelting.get()).booleanValue());
        data.m_128379_("mintCopper", ((Boolean)Config.COMMON.mintCopper.get()).booleanValue());
        data.m_128379_("mintIron", ((Boolean)Config.COMMON.mintIron.get()).booleanValue());
        data.m_128379_("mintGold", ((Boolean)Config.COMMON.mintGold.get()).booleanValue());
        data.m_128379_("mintEmerald", ((Boolean)Config.COMMON.mintEmerald.get()).booleanValue());
        data.m_128379_("mintDiamond", ((Boolean)Config.COMMON.mintDiamond.get()).booleanValue());
        data.m_128379_("mintNetherite", ((Boolean)Config.COMMON.mintNetherite.get()).booleanValue());
        data.m_128379_("meltCopper", ((Boolean)Config.COMMON.meltCopper.get()).booleanValue());
        data.m_128379_("meltIron", ((Boolean)Config.COMMON.meltIron.get()).booleanValue());
        data.m_128379_("meltGold", ((Boolean)Config.COMMON.meltGold.get()).booleanValue());
        data.m_128379_("meltEmerald", ((Boolean)Config.COMMON.meltEmerald.get()).booleanValue());
        data.m_128379_("meltDiamond", ((Boolean)Config.COMMON.meltDiamond.get()).booleanValue());
        data.m_128379_("meltNetherite", ((Boolean)Config.COMMON.meltNetherite.get()).booleanValue());
        CompoundTag coinValues = new CompoundTag();
        coinValues.m_128405_("iron", ((Integer)Config.COMMON.ironCoinWorth.get()).intValue());
        coinValues.m_128405_("gold", ((Integer)Config.COMMON.goldCoinWorth.get()).intValue());
        coinValues.m_128405_("emerald", ((Integer)Config.COMMON.emeraldCoinWorth.get()).intValue());
        coinValues.m_128405_("diamond", ((Integer)Config.COMMON.diamondCoinWorth.get()).intValue());
        coinValues.m_128405_("netherite", ((Integer)Config.COMMON.netheriteCoinWorth.get()).intValue());
        data.m_128365_("coinValues", (Tag)coinValues);
        CompoundTag coinpileValues = new CompoundTag();
        coinpileValues.m_128405_("copper", ((Integer)Config.COMMON.coinpileCopperWorth.get()).intValue());
        coinpileValues.m_128405_("iron", ((Integer)Config.COMMON.coinpileIronWorth.get()).intValue());
        coinpileValues.m_128405_("gold", ((Integer)Config.COMMON.coinpileGoldWorth.get()).intValue());
        coinpileValues.m_128405_("emerald", ((Integer)Config.COMMON.coinpileEmeraldWorth.get()).intValue());
        coinpileValues.m_128405_("diamond", ((Integer)Config.COMMON.coinpileDiamondWorth.get()).intValue());
        coinpileValues.m_128405_("netherite", ((Integer)Config.COMMON.coinpileNetheriteWorth.get()).intValue());
        data.m_128365_("coinpileValues", (Tag)coinpileValues);
        CompoundTag coinblockValues = new CompoundTag();
        coinblockValues.m_128405_("copper", ((Integer)Config.COMMON.coinBlockCopperWorth.get()).intValue());
        coinblockValues.m_128405_("iron", ((Integer)Config.COMMON.coinBlockIronWorth.get()).intValue());
        coinblockValues.m_128405_("gold", ((Integer)Config.COMMON.coinBlockGoldWorth.get()).intValue());
        coinblockValues.m_128405_("emerald", ((Integer)Config.COMMON.coinBlockEmeraldWorth.get()).intValue());
        coinblockValues.m_128405_("diamond", ((Integer)Config.COMMON.coinBlockDiamondWorth.get()).intValue());
        coinblockValues.m_128405_("netherite", ((Integer)Config.COMMON.coinBlockNetheriteWorth.get()).intValue());
        data.m_128365_("coinblockValues", (Tag)coinblockValues);
        return data;
    }

    public static void syncConfig() {
        Config.syncConfig(Config.getSyncData());
    }

    public static void syncConfig(CompoundTag data) {
        canMint = data.m_128471_("canMint");
        canMelt = data.m_128471_("canMelt");
        mintCopper = data.m_128471_("mintCopper");
        mintIron = data.m_128471_("mintIron");
        mintGold = data.m_128471_("mintGold");
        mintEmerald = data.m_128471_("mintEmerald");
        mintDiamond = data.m_128471_("mintDiamond");
        mintNetherite = data.m_128471_("mintNetherite");
        meltCopper = data.m_128471_("meltCopper");
        meltIron = data.m_128471_("meltIron");
        meltGold = data.m_128471_("meltGold");
        meltEmerald = data.m_128471_("meltEmerald");
        meltDiamond = data.m_128471_("meltDiamond");
        meltNetherite = data.m_128471_("meltNetherite");
        CompoundTag coinValues = data.m_128469_("coinValues");
        MoneyUtil.changeCoinConversion(ModItems.COIN_IRON, ModItems.COIN_COPPER, coinValues.m_128451_("iron"));
        MoneyUtil.changeCoinConversion(ModItems.COIN_GOLD, ModItems.COIN_IRON, coinValues.m_128451_("gold"));
        MoneyUtil.changeCoinConversion(ModItems.COIN_EMERALD, ModItems.COIN_GOLD, coinValues.m_128451_("emerald"));
        MoneyUtil.changeCoinConversion(ModItems.COIN_DIAMOND, ModItems.COIN_EMERALD, coinValues.m_128451_("diamond"));
        MoneyUtil.changeCoinConversion(ModItems.COIN_NETHERITE, ModItems.COIN_DIAMOND, coinValues.m_128451_("netherite"));
        CompoundTag coinpileValues = data.m_128469_("coinpileValues");
        MoneyUtil.changeCoinConversion(ModBlocks.COINPILE_COPPER.item, ModItems.COIN_COPPER, coinpileValues.m_128451_("copper"));
        MoneyUtil.changeCoinConversion(ModBlocks.COINPILE_IRON.item, ModItems.COIN_IRON, coinpileValues.m_128451_("iron"));
        MoneyUtil.changeCoinConversion(ModBlocks.COINPILE_GOLD.item, ModItems.COIN_GOLD, coinpileValues.m_128451_("gold"));
        MoneyUtil.changeCoinConversion(ModBlocks.COINPILE_EMERALD.item, ModItems.COIN_EMERALD, coinpileValues.m_128451_("emerald"));
        MoneyUtil.changeCoinConversion(ModBlocks.COINPILE_DIAMOND.item, ModItems.COIN_DIAMOND, coinpileValues.m_128451_("diamond"));
        MoneyUtil.changeCoinConversion(ModBlocks.COINPILE_NETHERITE.item, ModItems.COIN_NETHERITE, coinpileValues.m_128451_("netherite"));
        CompoundTag coinblockValues = data.m_128469_("coinblockValues");
        MoneyUtil.changeCoinConversion(ModBlocks.COINBLOCK_COPPER.item, ModBlocks.COINPILE_COPPER.item, coinblockValues.m_128451_("copper"));
        MoneyUtil.changeCoinConversion(ModBlocks.COINBLOCK_IRON.item, ModBlocks.COINPILE_IRON.item, coinblockValues.m_128451_("iron"));
        MoneyUtil.changeCoinConversion(ModBlocks.COINBLOCK_GOLD.item, ModBlocks.COINPILE_GOLD.item, coinblockValues.m_128451_("gold"));
        MoneyUtil.changeCoinConversion(ModBlocks.COINBLOCK_EMERALD.item, ModBlocks.COINPILE_EMERALD.item, coinblockValues.m_128451_("emerald"));
        MoneyUtil.changeCoinConversion(ModBlocks.COINBLOCK_DIAMOND.item, ModBlocks.COINPILE_DIAMOND.item, coinblockValues.m_128451_("diamond"));
        MoneyUtil.changeCoinConversion(ModBlocks.COINBLOCK_NETHERITE.item, ModBlocks.COINPILE_NETHERITE.item, coinblockValues.m_128451_("netherite"));
    }

    static {
        Pair clientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (Client)clientPair.getLeft();
        Pair commonPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)commonPair.getRight();
        COMMON = (Common)commonPair.getLeft();
        Pair serverPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)serverPair.getRight();
        SERVER = (Server)serverPair.getLeft();
    }

    public static class Common {
        private final ForgeConfigSpec.BooleanValue allowCoinMinting;
        private final ForgeConfigSpec.BooleanValue allowCoinMelting;
        private final ForgeConfigSpec.BooleanValue mintCopper;
        private final ForgeConfigSpec.BooleanValue mintIron;
        private final ForgeConfigSpec.BooleanValue mintGold;
        private final ForgeConfigSpec.BooleanValue mintEmerald;
        private final ForgeConfigSpec.BooleanValue mintDiamond;
        private final ForgeConfigSpec.BooleanValue mintNetherite;
        private final ForgeConfigSpec.BooleanValue meltCopper;
        private final ForgeConfigSpec.BooleanValue meltIron;
        private final ForgeConfigSpec.BooleanValue meltGold;
        private final ForgeConfigSpec.BooleanValue meltEmerald;
        private final ForgeConfigSpec.BooleanValue meltDiamond;
        private final ForgeConfigSpec.BooleanValue meltNetherite;
        public final ForgeConfigSpec.BooleanValue addCustomWanderingTrades;
        public final ForgeConfigSpec.BooleanValue addBankerVillager;
        public final ForgeConfigSpec.BooleanValue addCashierVillager;
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.BooleanValue enableEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> copperEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ironEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> goldEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> emeraldEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> diamondEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> netheriteEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bossCopperEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bossIronEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bossGoldEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bossEmeraldEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bossDiamondEntityDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bossNetheriteEntityDrops;
        public final ForgeConfigSpec.BooleanValue enableChestLoot;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> copperChestDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ironChestDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> goldChestDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> emeraldChestDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> diamondChestDrops;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> netheriteChestDrops;
        public final ForgeConfigSpec.IntValue ironCoinWorth;
        public final ForgeConfigSpec.IntValue goldCoinWorth;
        public final ForgeConfigSpec.IntValue emeraldCoinWorth;
        public final ForgeConfigSpec.IntValue diamondCoinWorth;
        public final ForgeConfigSpec.IntValue netheriteCoinWorth;
        public final ForgeConfigSpec.IntValue coinpileCopperWorth;
        public final ForgeConfigSpec.IntValue coinpileIronWorth;
        public final ForgeConfigSpec.IntValue coinpileGoldWorth;
        public final ForgeConfigSpec.IntValue coinpileEmeraldWorth;
        public final ForgeConfigSpec.IntValue coinpileDiamondWorth;
        public final ForgeConfigSpec.IntValue coinpileNetheriteWorth;
        public final ForgeConfigSpec.IntValue coinBlockCopperWorth;
        public final ForgeConfigSpec.IntValue coinBlockIronWorth;
        public final ForgeConfigSpec.IntValue coinBlockGoldWorth;
        public final ForgeConfigSpec.IntValue coinBlockEmeraldWorth;
        public final ForgeConfigSpec.IntValue coinBlockDiamondWorth;
        public final ForgeConfigSpec.IntValue coinBlockNetheriteWorth;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common configuration settings").push("common");
            this.allowCoinMinting = builder.comment("Determines whether or not coins should be craftable via the Coin Minting Machine.").translation("lightmanscurrency.configgui.canMintCoins").define("canMintCoins", true);
            this.allowCoinMelting = builder.comment("Determines whether or not coins can be melted back into their source material in the Coin Minting Machine.").translation("lightmanscurrency.configgui.canMeltCoins").define("canMeltCoins", false);
            builder.comment("Specific Coin Minting Settings.").push("coin_minting");
            this.mintCopper = builder.comment("Whether copper coins can be minted.").define("canMintCopper", true);
            this.mintIron = builder.comment("Whether iron coins can be minted.").define("canMintIron", true);
            this.mintGold = builder.comment("Whether gold coins can be minted.").define("canMintGold", true);
            this.mintEmerald = builder.comment("Whether emerald coins can be minted.").define("canMintEmerald", true);
            this.mintDiamond = builder.comment("Whether diamond coins can be minted.").define("canMintDiamond", true);
            this.mintNetherite = builder.comment("Whether netherite coins can be minted.").define("canMintNetherite", true);
            builder.pop();
            builder.comment("Specific Coin Melting Settings.").push("coin_melting");
            this.meltCopper = builder.comment("Whether copper coins can be melted.").define("canMeltCopper", true);
            this.meltIron = builder.comment("Whether iron coins can be melted.").define("canMeltIron", true);
            this.meltGold = builder.comment("Whether gold coins can be melted.").define("canMeltGold", true);
            this.meltEmerald = builder.comment("Whether emerald coins can be melted.").define("canMeltEmerald", true);
            this.meltDiamond = builder.comment("Whether diamond coins can be melted.").define("canMeltDiamond", true);
            this.meltNetherite = builder.comment("Whether netherite coins can be melted.").define("canMeltNetherite", true);
            builder.pop();
            builder.comment("Villager Related Settings.").push("villagers");
            this.addCustomWanderingTrades = builder.comment("Whether the wandering trader will have additional trades that allow you to buy misc items with money.").define("addCustomWanderingTrades", true);
            this.addBankerVillager = builder.comment("Whether the banker villager profession will have any registered trades. The banker sells Lightman's Currency items for coins.").define("addBanker", true);
            this.addCashierVillager = builder.comment("Whether the cashier villager profession will have any registered trades.. The cashier sells an amalgamation of vanilla traders products for coins.").define("addCashier", true);
            builder.pop();
            this.debugLevel = builder.comment(new String[]{"Level of debug messages to be shown in the logs.", "0-All debug messages. 1-Warnings/Errors only. 2-Errors only. 3-No debug messages.", "Note: All debug messages will still be sent debug.log regardless of settings."}).defineInRange("debugLevel", 0, 0, 3);
            builder.comment("Entity loot settings. Inputs can be either loot-table id, or the LivingEntities id.").push("entity_loot");
            this.enableEntityDrops = builder.comment("Whether coins can be dropped by entities. Does not effect chest loot generation.").define("enableEntityDrops", true);
            this.copperEntityDrops = builder.comment("Entities that will occasionally drop copper coins.").defineList("copper", LootManager.ENTITY_COPPER_DROPLIST, o -> o instanceof String);
            this.ironEntityDrops = builder.comment("Entities that will occasionally drop copper -> iron coins.").defineList("iron", LootManager.ENTITY_IRON_DROPLIST, o -> o instanceof String);
            this.goldEntityDrops = builder.comment("Entities that will occasionally drop copper -> gold coins.").defineList("gold", LootManager.ENTITY_GOLD_DROPLIST, o -> o instanceof String);
            this.emeraldEntityDrops = builder.comment("Entities that will occasionally drop copper -> emerald coins.").defineList("emerald", LootManager.ENTITY_EMERALD_DROPLIST, o -> o instanceof String);
            this.diamondEntityDrops = builder.comment("Entities that will occasionally drop copper -> diamond coins.").defineList("diamond", LootManager.ENTITY_DIAMOND_DROPLIST, o -> o instanceof String);
            this.netheriteEntityDrops = builder.comment("Entities that will occasionally drop copper -> netherite coins.").defineList("netherite", LootManager.ENTITY_NETHERITE_DROPLIST, o -> o instanceof String);
            this.bossCopperEntityDrops = builder.comment("Entities that will drop a large amount of copper coins.").defineList("boss_copper", LootManager.ENTITY_BOSS_COPPER_DROPLIST, o -> o instanceof String);
            this.bossIronEntityDrops = builder.comment("Entities that will drop a large amount of copper -> iron coins.").defineList("boss_iron", LootManager.ENTITY_BOSS_IRON_DROPLIST, o -> o instanceof String);
            this.bossGoldEntityDrops = builder.comment("Entities that will drop a large amount of copper -> gold coins.").defineList("boss_gold", LootManager.ENTITY_BOSS_GOLD_DROPLIST, o -> o instanceof String);
            this.bossEmeraldEntityDrops = builder.comment("Entities that will drop a large amount of copper -> emerald coins.").defineList("boss_emerald", LootManager.ENTITY_BOSS_EMERALD_DROPLIST, o -> o instanceof String);
            this.bossDiamondEntityDrops = builder.comment("Entities that will drop a large amount of copper -> diamond coins.").defineList("boss_diamond", LootManager.ENTITY_BOSS_DIAMOND_DROPLIST, o -> o instanceof String);
            this.bossNetheriteEntityDrops = builder.comment("Entities that will drop a large amount of copper -> netherite coins.").defineList("boss_netherite", LootManager.ENTITY_BOSS_NETHERITE_DROPLIST, o -> o instanceof String);
            builder.pop();
            builder.comment("Chest loot settings.").push("chest_loot");
            this.enableChestLoot = builder.comment("Whether coins can spawn in chests Does not effect entity loot drops.").define("enableChestLoot", true);
            this.copperChestDrops = builder.comment("Chests that will occasionally spawn copper coins.").defineList("copper", LootManager.CHEST_COPPER_DROPLIST, o -> o instanceof String);
            this.ironChestDrops = builder.comment("Chests that will occasionally spawn copper -> iron coins.").defineList("iron", LootManager.CHEST_IRON_DROPLIST, o -> o instanceof String);
            this.goldChestDrops = builder.comment("Chests that will occasionally spawn copper -> gold coins.").defineList("gold", LootManager.CHEST_GOLD_DROPLIST, o -> o instanceof String);
            this.emeraldChestDrops = builder.comment("Chests that will occasionally spawn copper -> emerald coins.").defineList("emerald", LootManager.CHEST_EMERALD_DROPLIST, o -> o instanceof String);
            this.diamondChestDrops = builder.comment("Chests that will occasionally spawn copper -> diamond coins.").defineList("diamond", LootManager.CHEST_DIAMOND_DROPLIST, o -> o instanceof String);
            this.netheriteChestDrops = builder.comment("Chests that will occasionally spawn copper -> netherite coins.").defineList("netherite", LootManager.CHEST_NETHERITE_DROPLIST, o -> o instanceof String);
            builder.pop();
            builder.comment("Coin value settings.").push("coin_value");
            this.ironCoinWorth = builder.comment("How many copper coins are required to make 1 iron coin.").defineInRange("coinValueIron", 10, 2, 64);
            this.goldCoinWorth = builder.comment("How many iron coins are required to make 1 gold coin.").defineInRange("coinValueGold", 10, 2, 64);
            this.emeraldCoinWorth = builder.comment("How many gold coins are required to make 1 emerald coin.").defineInRange("coinValueEmerald", 10, 2, 64);
            this.diamondCoinWorth = builder.comment("How many emerald coins are required to make 1 diamond coin.").defineInRange("coinValueDiamond", 10, 2, 64);
            this.netheriteCoinWorth = builder.comment("How many diamond coins are required to make 1 netherite coin.").defineInRange("coinValueNetherite", 10, 2, 64);
            builder.comment("Coinpile values (leave as default unless a datapack/mod changes the crafting recipes)").push("coinpile");
            this.coinpileCopperWorth = builder.comment("How many copper coins are used to craft a copper coinpile.").defineInRange("coinpileValueCopper", 9, 2, 9);
            this.coinpileIronWorth = builder.comment("How many iron coins are used to craft an iron coinpile.").defineInRange("coinpileValueIron", 9, 2, 9);
            this.coinpileGoldWorth = builder.comment("How many gold coins are used to craft a gold coinpile.").defineInRange("coinpileValueGold", 9, 2, 9);
            this.coinpileEmeraldWorth = builder.comment("How many emerald coins are used to craft an emerald coinpile.").defineInRange("coinpileValueEmerald", 9, 2, 9);
            this.coinpileDiamondWorth = builder.comment("How many diamond coins are used to craft a diamond coinpile.").defineInRange("coinpileValueDiamond", 9, 2, 9);
            this.coinpileNetheriteWorth = builder.comment("How many netherite coins are used to craft a netherite coinpile.").defineInRange("coinpileValueNetherite", 9, 2, 9);
            builder.pop();
            builder.comment(new String[]{"Coin block values.", "Leave at default values unless a datapack/mod changes the crafting recipes!"}).push("coinblock");
            this.coinBlockCopperWorth = builder.comment("How many copper coinpiles are used to craft a copper coin block.").defineInRange("coinBlockValueCopper", 4, 2, 9);
            this.coinBlockIronWorth = builder.comment("How many iron coinpiles are used to craft an iron coin block.").defineInRange("coinBlockValueIron", 4, 2, 9);
            this.coinBlockGoldWorth = builder.comment("How many gold coinpiles are used to craft a gold coin block.").defineInRange("coinBlockValueGold", 4, 2, 9);
            this.coinBlockEmeraldWorth = builder.comment("How many emerald coinpiles are used to craft an emerald coin block.").defineInRange("coinBlockValueEmerald", 4, 2, 9);
            this.coinBlockDiamondWorth = builder.comment("How many diamond coinpiles are used to craft a diamond coin block.").defineInRange("coinBlockValueDiamond", 4, 2, 9);
            this.coinBlockNetheriteWorth = builder.comment("How many netherite coinpiles are used to craft a netherite coin block.").defineInRange("coinBlockValueNetherite", 4, 2, 9);
            builder.pop();
            builder.pop();
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> renderBlocksAsItems;
        public final ForgeConfigSpec.EnumValue<TraderRenderType> traderRenderType;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client configuration settings").push("client");
            this.renderBlocksAsItems = builder.comment("BlockItems that should be spaced out as though they were normal items.").defineList("renderBlocksAsItems", CLIENT_DEFAULT_RENDER_AS_BLOCK, o -> o instanceof String);
            builder.comment("Quality Settings").push("settings");
            this.traderRenderType = builder.comment(new String[]{"How many items the traders should render as stock. Useful to avoid lag in trader-rich areas.", "FULL: Renders all items based on stock as intended.", "PARTIAL: Renders only 1 item per trade slot regardless of stock.", "NONE: Traders do not render items."}).defineEnum("traderRenderType", (Enum)TraderRenderType.FULL);
            builder.pop();
        }

        public static enum TraderRenderType {
            FULL,
            PARTIAL,
            NONE;

        }
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue logLimit;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server Config Settings").push("server");
            this.logLimit = builder.comment("The maximum amount of entries allowed in a text log.").defineInRange("logLimit", 100, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

