/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api;

import io.github.lightman314.lightmanscurrency.api.TextLogger;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;

public class ItemShopLogger
extends TextLogger {
    public ItemShopLogger() {
        super("ItemShopHistory");
    }

    public void AddLog(Player player, ItemTradeData trade, @Nonnull MoneyUtil.CoinValue pricePaid, boolean isCreative) {
        TranslatableComponent creativeText = isCreative ? new TranslatableComponent("log.shoplog.creative") : new TextComponent("");
        TextComponent playerName = new TextComponent("\u00a7a" + player.m_7755_().getString());
        TranslatableComponent boughtText = new TranslatableComponent("log.shoplog." + trade.getTradeType().name().toLowerCase());
        MutableComponent itemName = new TextComponent("").m_7220_(trade.getSellItem().m_41786_()).m_130940_(trade.getSellItem().m_41791_().f_43022_);
        if (trade.getSellItem().m_41788_()) {
            itemName.m_130940_(ChatFormatting.ITALIC);
        }
        TranslatableComponent itemText = new TranslatableComponent("log.shoplog.item.itemformat", new Object[]{trade.getSellItem().m_41613_(), itemName});
        Component cost = ItemShopLogger.getCostText(trade.isFree(), pricePaid);
        if (trade.isBarter()) {
            cost = itemText;
            MutableComponent barterItemName = new TextComponent("").m_7220_(trade.getBarterItem().m_41786_()).m_130940_(trade.getSellItem().m_41791_().f_43022_);
            if (trade.getBarterItem().m_41788_()) {
                itemName.m_130940_(ChatFormatting.ITALIC);
            }
            itemText = new TranslatableComponent("log.shoplog.item.itemformat", new Object[]{trade.getBarterItem().m_41613_(), barterItemName});
        }
        this.AddLog((MutableComponent)new TranslatableComponent("log.shoplog.item.format", new Object[]{creativeText, playerName, boughtText, itemText, cost}));
    }
}

