/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.EquipmentRestriction;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class ArmorDisplayTraderBlockEntity
extends ItemTraderBlockEntity {
    public static final int TRADE_COUNT = 4;
    ArmorStand armorStand;
    UUID armorStandID = null;

    public ArmorDisplayTraderBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ARMOR_TRADER, pos, state, 4);
        this.validateTradeLimitations();
    }

    private void spawnArmorStand() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.armorStand = new ArmorStand(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5);
        this.armorStand.m_7678_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5, this.getStandRotation(), 0.0f);
        this.armorStand.m_20331_(true);
        this.armorStand.m_20242_(true);
        this.armorStand.m_20225_(true);
        CompoundTag compound = this.armorStand.m_20240_(new CompoundTag());
        compound.m_128379_("Marker", true);
        compound.m_128379_("NoBasePlate", true);
        this.armorStand.m_20258_(compound);
        this.f_58857_.m_7967_((Entity)this.armorStand);
    }

    private void validateTradeLimitations() {
        if (this.tradeCount > 0) {
            this.restrictTrade(0, ItemTradeRestriction.ARMOR_HEAD);
        }
        if (this.tradeCount > 1) {
            this.restrictTrade(1, ItemTradeRestriction.ARMOR_CHEST);
        }
        if (this.tradeCount > 2) {
            this.restrictTrade(2, ItemTradeRestriction.ARMOR_LEGS);
        }
        if (this.tradeCount > 3) {
            this.restrictTrade(3, ItemTradeRestriction.ARMOR_FEET);
        }
    }

    @Override
    public void serverTick() {
        super.serverTick();
        this.validateTradeLimitations();
        if (this.armorStandID != null) {
            this.validateArmorStand();
            this.armorStandID = null;
        }
        if (this.armorStand == null || !this.armorStand.m_6084_()) {
            this.spawnArmorStand();
        }
        if (this.armorStand != null) {
            this.validateArmorStandValues();
            this.armorStand.m_7678_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)((float)this.f_58858_.m_123343_() + 0.5f), this.getStandRotation(), 0.0f);
            for (int i = 0; i < 4 && i < this.tradeCount; ++i) {
                ItemTradeData thisTrade = this.getTrade(i);
                ItemTradeRestriction r = thisTrade.getRestriction();
                EquipmentSlot slot = null;
                if (r instanceof EquipmentRestriction) {
                    EquipmentRestriction er = (EquipmentRestriction)r;
                    slot = er.getEquipmentSlot();
                }
                if (slot == null) continue;
                if (thisTrade.hasStock(this) || this.isCreative()) {
                    this.armorStand.m_8061_(slot, thisTrade.getSellItem());
                    continue;
                }
                this.armorStand.m_8061_(slot, ItemStack.f_41583_);
            }
        }
    }

    protected void validateArmorStand() {
        if (this.armorStandID == null) {
            return;
        }
        if (this.armorStand != null) {
            ArmorStand newArmorStand;
            if (!this.armorStand.m_142081_().equals(this.armorStandID) && (newArmorStand = this.getArmorStand(this.armorStandID)) != null) {
                this.destroyArmorStand();
                this.armorStand = newArmorStand;
            }
        } else {
            this.armorStand = this.getArmorStand(this.armorStandID);
        }
    }

    protected void validateArmorStandValues() {
        if (!this.armorStand.m_20147_()) {
            this.armorStand.m_20331_(true);
        }
        if (this.armorStand.m_20145_()) {
            this.armorStand.m_6842_(false);
        }
        if (!this.armorStand.f_19794_) {
            this.armorStand.m_20242_(true);
        }
        if (!this.armorStand.m_20067_()) {
            this.armorStand.m_20225_(true);
        }
        if (!this.armorStand.m_31677_() || !this.armorStand.m_31674_()) {
            CompoundTag compound = this.armorStand.m_20240_(new CompoundTag());
            if (!this.armorStand.m_31677_()) {
                compound.m_128379_("Marker", true);
            }
            if (!this.armorStand.m_31674_()) {
                compound.m_128379_("NoBasePlate", true);
            }
            this.armorStand.m_20258_(compound);
        }
    }

    public void destroyArmorStand() {
        if (this.armorStand != null) {
            this.armorStand.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public CompoundTag m_6945_(CompoundTag compound) {
        this.writeArmorStandData(compound);
        return super.m_6945_(compound);
    }

    protected CompoundTag writeArmorStandData(CompoundTag compound) {
        if (this.armorStand != null) {
            compound.m_128362_("ArmorStand", this.armorStand.m_142081_());
        }
        return compound;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("ArmorStand")) {
            this.armorStandID = compound.m_128342_("ArmorStand");
        }
    }

    protected ArmorStand getArmorStand(UUID id) {
        Entity entity = null;
        if (this.f_58857_ instanceof ServerLevel) {
            entity = ((ServerLevel)this.f_58857_).m_8791_(id);
        }
        if (entity != null && entity instanceof ArmorStand) {
            return (ArmorStand)entity;
        }
        LightmansCurrency.LogError("Could not find an armor stand with UUID " + id);
        return null;
    }

    protected float getStandRotation() {
        Direction facing = Direction.NORTH;
        if (this.m_58900_().m_60734_() instanceof IRotatableBlock) {
            facing = ((IRotatableBlock)this.m_58900_().m_60734_()).getFacing(this.m_58900_());
        }
        if (facing == Direction.SOUTH) {
            return 180.0f;
        }
        if (facing == Direction.NORTH) {
            return 0.0f;
        }
        if (facing == Direction.WEST) {
            return -90.0f;
        }
        if (facing == Direction.EAST) {
            return 90.0f;
        }
        return 0.0f;
    }
}

