/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import com.google.common.base.Supplier;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ILoggerSupport;
import io.github.lightman314.lightmanscurrency.api.ItemShopLogger;
import io.github.lightman314.lightmanscurrency.blockentity.CashRegisterBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.menus.ItemEditMenu;
import io.github.lightman314.lightmanscurrency.menus.ItemTraderMenu;
import io.github.lightman314.lightmanscurrency.menus.ItemTraderMenuCR;
import io.github.lightman314.lightmanscurrency.menus.ItemTraderStorageMenu;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.item_trader.MessageSetTraderRules;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageOpenStorage;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class ItemTraderBlockEntity
extends TraderBlockEntity
implements IItemTrader,
ILoggerSupport<ItemShopLogger>,
ITradeRuleHandler {
    public static final int TRADELIMIT = 16;
    public static final int VERSION = 1;
    protected Container storage;
    private final ItemShopLogger logger = new ItemShopLogger();
    protected int tradeCount = 1;
    private long rotationTime = 0L;
    protected NonNullList<ItemTradeData> trades;
    List<TradeRule> tradeRules = new ArrayList<TradeRule>();

    public ItemTraderBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ITEM_TRADER, pos, state);
        this.trades = ItemTradeData.listOfSize(this.tradeCount);
        this.storage = new SimpleContainer(this.getStorageSize());
    }

    public ItemTraderBlockEntity(BlockPos pos, BlockState state, int tradeCount) {
        super(ModBlockEntities.ITEM_TRADER, pos, state);
        this.tradeCount = tradeCount;
        this.trades = ItemTradeData.listOfSize(tradeCount);
        this.storage = new SimpleContainer(this.getStorageSize());
    }

    protected ItemTraderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.trades = ItemTradeData.listOfSize(this.tradeCount);
        this.storage = new SimpleContainer(this.getStorageSize());
    }

    protected ItemTraderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int tradeCount) {
        super(type, pos, state);
        this.tradeCount = tradeCount;
        this.trades = ItemTradeData.listOfSize(tradeCount);
        this.storage = new SimpleContainer(this.getStorageSize());
    }

    public void restrictTrade(int index, ItemTradeRestriction restriction) {
        this.getTrade(index).setRestriction(restriction);
    }

    private int getStorageSize() {
        return this.getTradeCount() * 9;
    }

    @Override
    public int getTradeCount() {
        return MathUtil.clamp(this.tradeCount, 1, 16);
    }

    public void addTrade() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.tradeCount >= 16) {
            return;
        }
        this.overrideTradeCount(this.tradeCount + 1);
        this.forceReOpen();
    }

    public void removeTrade() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.tradeCount <= 1) {
            return;
        }
        this.overrideTradeCount(this.tradeCount - 1);
        this.forceReOpen();
    }

    private void forceReOpen() {
        for (Player player : this.getUsers()) {
            if (player.f_36096_ instanceof ItemTraderStorageMenu) {
                this.openStorageMenu(player);
                continue;
            }
            if (player.f_36096_ instanceof ItemTraderMenuCR) {
                this.openCashRegisterTradeMenu(player, ((ItemTraderMenuCR)player.f_36096_).cashRegister);
                continue;
            }
            if (!(player.f_36096_ instanceof ItemTraderMenu)) continue;
            this.openTradeMenu(player);
        }
    }

    public void overrideTradeCount(int newTradeCount) {
        int i;
        if (this.tradeCount == newTradeCount) {
            return;
        }
        this.tradeCount = MathUtil.clamp(newTradeCount, 1, 16);
        NonNullList<ItemTradeData> oldTrades = this.trades;
        this.trades = ItemTradeData.listOfSize(this.getTradeCount());
        for (int i2 = 0; i2 < oldTrades.size() && i2 < this.trades.size(); ++i2) {
            this.trades.set(i2, (Object)((ItemTradeData)oldTrades.get(i2)));
        }
        Container oldStorage = this.storage;
        this.storage = new SimpleContainer(this.getStorageSize());
        for (i = 0; i < this.storage.m_6643_() && i < oldStorage.m_6643_(); ++i) {
            this.storage.m_6836_(i, oldStorage.m_8020_(i));
        }
        if (oldStorage.m_6643_() > this.getStorageSize()) {
            for (i = this.getStorageSize(); i < oldStorage.m_6643_(); ++i) {
                InventoryUtil.TryPutItemStack(this.storage, oldStorage.m_8020_(i));
            }
        }
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeTrades(new CompoundTag());
            this.writeStorage(compound);
            TileEntityUtil.sendUpdatePacket(this, this.superWrite(compound));
        }
    }

    @Override
    public ItemTradeData getTrade(int tradeSlot) {
        if (tradeSlot < 0 || tradeSlot >= this.trades.size()) {
            LightmansCurrency.LogError("Cannot get trade in index " + tradeSlot + " from a trader with only " + this.trades.size() + " trades.");
            return new ItemTradeData();
        }
        return (ItemTradeData)this.trades.get(tradeSlot);
    }

    public NonNullList<ItemTradeData> getAllTrades() {
        return this.trades;
    }

    @Override
    public void markTradesDirty() {
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeTrades(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, this.superWrite(compound));
        }
        this.m_6596_();
    }

    @Override
    public void markStorageDirty() {
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeStorage(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, this.superWrite(compound));
        }
        this.m_6596_();
    }

    @Override
    public ItemShopLogger getLogger() {
        return this.logger;
    }

    @Override
    public void clearLogger() {
        this.logger.clear();
        this.markLoggerDirty();
    }

    @Override
    public void markLoggerDirty() {
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeLogger(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, this.superWrite(compound));
        }
        this.m_6596_();
    }

    @Override
    public int getTradeStock(int tradeSlot) {
        ItemTradeData trade = this.getTrade(tradeSlot);
        if (!trade.getSellItem().m_41619_()) {
            if (this.isCreative) {
                return Integer.MAX_VALUE;
            }
            return trade.stockCount(this);
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Vector3f> GetStackRenderPos(int tradeSlot, boolean isBlock) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.GetStackRenderPos(tradeSlot, this.m_58900_(), isBlock);
        }
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>();
        posList.add(new Vector3f(0.0f, 0.0f, 0.0f));
        return posList;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternion> GetStackRenderRot(int tradeSlot, float partialTicks, boolean isBlock) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            List<Quaternion> rotation = traderBlock.GetStackRenderRot(tradeSlot, this.m_58900_(), isBlock);
            if (rotation == null) {
                rotation = new ArrayList<Quaternion>();
                rotation.add(Vector3f.f_122225_.m_122240_(((float)this.rotationTime + partialTicks) * 2.0f));
            }
            return rotation;
        }
        ArrayList<Quaternion> rotation = new ArrayList<Quaternion>();
        rotation.add(Vector3f.f_122225_.m_122240_(0.0f));
        return rotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3f GetStackRenderScale(int tradeSlot, boolean isBlock) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.GetStackRenderScale(tradeSlot, this.m_58900_(), isBlock);
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.maxRenderIndex();
        }
        return 0;
    }

    @Override
    public CompoundTag m_6945_(CompoundTag compound) {
        this.writeStorage(compound);
        this.writeTrades(compound);
        this.writeLogger(compound);
        this.writeTradeRules(compound);
        return super.m_6945_(compound);
    }

    protected CompoundTag writeStorage(CompoundTag compound) {
        InventoryUtil.saveAllItems("Items", compound, this.storage);
        return compound;
    }

    public CompoundTag writeTrades(CompoundTag compound) {
        compound.m_128405_("TradeLimit", this.tradeCount);
        ItemTradeData.saveAllData(compound, this.trades);
        return compound;
    }

    public CompoundTag writeLogger(CompoundTag compound) {
        this.logger.write(compound);
        return compound;
    }

    public CompoundTag writeTradeRules(CompoundTag compound) {
        TradeRule.writeRules(compound, this.tradeRules);
        return compound;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("TradeLimit", 3)) {
            this.tradeCount = MathUtil.clamp(compound.m_128451_("TradeLimit"), 1, 16);
        }
        if (compound.m_128441_("Trades")) {
            this.trades = ItemTradeData.loadAllData(compound, this.getTradeCount());
        }
        if (compound.m_128441_("Items")) {
            this.storage = InventoryUtil.loadAllItems("Items", compound, this.getStorageSize());
        }
        this.logger.read(compound);
        if (compound.m_128425_("TradeRules", 9)) {
            this.tradeRules = TradeRule.readRules(compound);
        }
        super.m_142466_(compound);
    }

    @Override
    public void dumpContents(Level world, BlockPos pos) {
        super.dumpContents(world, pos);
        InventoryUtil.dumpContents(world, pos, this.storage);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_142082_(-1, 0, -1), this.f_58858_.m_142082_(2, 2, 2));
    }

    @Override
    public void clientTick() {
        super.clientTick();
        ++this.rotationTime;
    }

    @Override
    public MenuProvider getTradeMenuProvider() {
        return new TradeContainerProvider(this);
    }

    @Override
    public MenuProvider getStorageMenuProvider() {
        return new StorageContainerProvider(this);
    }

    @Override
    public MenuProvider getCashRegisterTradeMenuProvider(CashRegisterBlockEntity cashRegister) {
        return new TradeCRContainerProvider(this, cashRegister);
    }

    protected MenuProvider getItemEditMenuProvider(int tradeIndex) {
        return new ItemEditContainerProvider(this, tradeIndex);
    }

    @Override
    public void openItemEditMenu(Player player, int tradeIndex) {
        MenuProvider provider = this.getItemEditMenuProvider(tradeIndex);
        if (provider == null) {
            LightmansCurrency.LogError("No item edit container provider was given for the trader of type " + this.m_58903_().getRegistryName().toString());
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the storage menu.");
            return;
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (Consumer)new TraderBlockEntity.TradeIndexDataWriter(this, this.f_58858_, tradeIndex));
    }

    @Override
    public Container getStorage() {
        return this.storage;
    }

    @Override
    public int GetCurrentVersion() {
        return 1;
    }

    @Override
    protected void onVersionUpdate(int oldVersion) {
        if (oldVersion < 1) {
            for (ItemTradeData trade : this.trades) {
                ItemStack tradeStack = trade.getSellItem();
                if (!tradeStack.m_41619_()) {
                    tradeStack = InventoryUtil.TryPutItemStack(this.storage, tradeStack);
                }
                if (tradeStack.m_41619_()) continue;
                InventoryUtil.dumpContents(this.f_58857_, this.f_58858_, InventoryUtil.buildInventory(tradeStack));
            }
        }
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.beforeTrade(event));
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        this.tradeRules.forEach(rule -> rule.tradeCost(event));
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.afterTrade(event));
    }

    @Override
    public void addRule(TradeRule newRule) {
        if (newRule == null) {
            return;
        }
        for (int i = 0; i < this.tradeRules.size(); ++i) {
            if (newRule.type != this.tradeRules.get((int)i).type) continue;
            LightmansCurrency.LogInfo("Blocked rule addition due to rule of same type already present.");
            return;
        }
        this.tradeRules.add(newRule);
    }

    @Override
    public List<TradeRule> getRules() {
        return this.tradeRules;
    }

    @Override
    public void setRules(List<TradeRule> rules) {
        this.tradeRules = rules;
    }

    @Override
    public void removeRule(TradeRule rule) {
        if (this.tradeRules.contains(rule)) {
            this.tradeRules.remove(rule);
        }
    }

    @Override
    public void clearRules() {
        this.tradeRules.clear();
    }

    @Override
    public void markRulesDirty() {
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeTradeRules(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, this.superWrite(compound));
        }
        this.m_6596_();
    }

    public void closeRuleScreen(Player player) {
        this.openStorageMenu(player);
    }

    public ITradeRuleScreenHandler GetRuleScreenBackHandler() {
        return new TraderScreenHandler(this);
    }

    private class TradeContainerProvider
    implements MenuProvider {
        ItemTraderBlockEntity tileEntity;

        public TradeContainerProvider(ItemTraderBlockEntity tileEntity) {
            this.tileEntity = tileEntity;
        }

        public Component m_5446_() {
            return this.tileEntity.getName();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player entity) {
            return new ItemTraderMenu(id, inventory, this.tileEntity);
        }
    }

    private class StorageContainerProvider
    implements MenuProvider {
        ItemTraderBlockEntity tileEntity;

        public StorageContainerProvider(ItemTraderBlockEntity tileEntity) {
            this.tileEntity = tileEntity;
        }

        public Component m_5446_() {
            return this.tileEntity.getName();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player entity) {
            return new ItemTraderStorageMenu(id, inventory, this.tileEntity);
        }
    }

    private class TradeCRContainerProvider
    implements MenuProvider {
        ItemTraderBlockEntity tileEntity;
        CashRegisterBlockEntity registerEntity;

        public TradeCRContainerProvider(ItemTraderBlockEntity tileEntity, CashRegisterBlockEntity registerEntity) {
            this.tileEntity = tileEntity;
            this.registerEntity = registerEntity;
        }

        public Component m_5446_() {
            return this.tileEntity.getName();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player entity) {
            return new ItemTraderMenuCR(id, inventory, this.tileEntity, this.registerEntity);
        }
    }

    private class ItemEditContainerProvider
    implements MenuProvider {
        ItemTraderBlockEntity tileEntity;
        int tradeIndex;

        public ItemEditContainerProvider(ItemTraderBlockEntity tileEntity, int tradeIndex) {
            this.tileEntity = tileEntity;
            this.tradeIndex = tradeIndex;
        }

        public Component m_5446_() {
            return this.tileEntity.getName();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player entity) {
            return new ItemEditMenu(id, inventory, (Supplier<IItemTrader>)((Supplier)() -> this.tileEntity), this.tradeIndex);
        }
    }

    private static class TraderScreenHandler
    implements ITradeRuleScreenHandler {
        private final ItemTraderBlockEntity tileEntity;

        public TraderScreenHandler(ItemTraderBlockEntity tileEntity) {
            this.tileEntity = tileEntity;
        }

        @Override
        public ITradeRuleHandler ruleHandler() {
            return this.tileEntity;
        }

        @Override
        public void reopenLastScreen() {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenStorage(this.tileEntity.f_58858_));
        }

        @Override
        public void updateServer(List<TradeRule> newRules) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetTraderRules(this.tileEntity.f_58858_, newRules));
        }
    }
}

