/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.items.TicketItem;
import io.github.lightman314.lightmanscurrency.menus.PaygateMenu;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PaygateBlockEntity
extends TickableBlockEntity
implements MenuProvider,
Nameable {
    public static final int PRICE_MIN = 0;
    public static final int PRICE_MAX = Integer.MAX_VALUE;
    public static final int DURATION_MIN = 1;
    public static final int DURATION_MAX = 200;
    private Component customName;
    private UUID ownerID = null;
    private UUID ticketID = null;
    private String ownerName = "";
    private MoneyUtil.CoinValue storedMoney = new MoneyUtil.CoinValue(new MoneyUtil.CoinValue.CoinValuePair[0]);
    private MoneyUtil.CoinValue price = new MoneyUtil.CoinValue(new MoneyUtil.CoinValue.CoinValuePair[0]);
    private int duration = 40;
    private int timer = 0;

    public PaygateBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.PAYGATE, pos, state);
    }

    public void setOwner(Entity player) {
        this.ownerID = player.m_142081_();
        this.ownerName = player.m_7755_().getString();
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeOwner(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
    }

    public boolean isOwner(Entity player) {
        if (this.ownerID == null) {
            return true;
        }
        return player.m_142081_().equals(this.ownerID);
    }

    public boolean canBreak(Player player) {
        if (this.isOwner((Entity)player)) {
            return true;
        }
        return TradingOffice.isAdminPlayer(player);
    }

    public boolean isActive() {
        return this.timer > 0;
    }

    public MoneyUtil.CoinValue getStoredMoney() {
        return this.storedMoney;
    }

    public void addStoredMoney(MoneyUtil.CoinValue amount) {
        this.storedMoney.addValue(amount);
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeStoredMoney(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
    }

    public void clearStoredMoney() {
        this.storedMoney = new MoneyUtil.CoinValue(new MoneyUtil.CoinValue.CoinValuePair[0]);
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeStoredMoney(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
    }

    public MoneyUtil.CoinValue getPrice() {
        return this.price;
    }

    public void setPrice(MoneyUtil.CoinValue value) {
        this.price = value;
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writePrice(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int value) {
        this.duration = MathUtil.clamp(value, 1, 200);
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeDuration(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
    }

    public void SetTicketID(UUID ticketID) {
        this.ticketID = ticketID;
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeTicket(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
    }

    public boolean HasPairedTicket() {
        return this.ticketID != null;
    }

    public boolean validTicket(ItemStack ticket) {
        if (ticket.m_41619_()) {
            return false;
        }
        if (ticket.m_41720_() instanceof TicketItem) {
            return !TicketItem.isMasterTicket(ticket) && this.validTicket(TicketItem.GetTicketID(ticket));
        }
        return false;
    }

    public boolean validTicket(UUID ticketID) {
        if (this.ticketID == null || ticketID == null) {
            return false;
        }
        return this.ticketID.equals(ticketID);
    }

    public void activate() {
        this.timer = this.duration;
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(true)));
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        this.writeOwner(compound);
        this.writeStoredMoney(compound);
        this.writePrice(compound);
        this.writeDuration(compound);
        this.writeTimer(compound);
        this.writeTicket(compound);
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        return super.m_6945_(compound);
    }

    private CompoundTag writeOwner(CompoundTag compound) {
        if (this.ownerID != null) {
            compound.m_128362_("OwnerID", this.ownerID);
        }
        compound.m_128359_("OwnerName", this.ownerName);
        return compound;
    }

    private CompoundTag writeStoredMoney(CompoundTag compound) {
        this.storedMoney.writeToNBT(compound, "StoredMoney");
        return compound;
    }

    private CompoundTag writePrice(CompoundTag compound) {
        this.price.writeToNBT(compound, "Price");
        return compound;
    }

    private CompoundTag writeDuration(CompoundTag compound) {
        compound.m_128405_("Duration", this.duration);
        return compound;
    }

    private CompoundTag writeTimer(CompoundTag compound) {
        compound.m_128405_("Timer", this.timer);
        return compound;
    }

    private CompoundTag writeTicket(CompoundTag compound) {
        if (this.ticketID != null) {
            compound.m_128362_("TicketID", this.ticketID);
        }
        return compound;
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("OwnerID")) {
            this.ownerID = compound.m_128342_("OwnerID");
        }
        if (compound.m_128425_("OwnerName", 8)) {
            this.ownerName = compound.m_128461_("OwnerName");
        }
        if (compound.m_128425_("StoredMoney", 3)) {
            this.storedMoney.readFromOldValue(compound.m_128451_("StoredMoney"));
            LightmansCurrency.LogInfo("Reading stored money from older value format. Will be updated to newer value format.");
        } else if (compound.m_128441_("StoredMoney")) {
            this.storedMoney.readFromNBT(compound, "StoredMoney");
        }
        if (compound.m_128425_("Price", 3)) {
            this.price.readFromOldValue(compound.m_128451_("Price"));
            LightmansCurrency.LogInfo("Reading price from older value format. Will be updated to newer value format.");
        } else if (compound.m_128441_("Price")) {
            this.price.readFromNBT(compound, "Price");
        }
        if (compound.m_128425_("Duration", 3)) {
            this.duration = compound.m_128451_("Duration");
        }
        if (compound.m_128425_("Timer", 3)) {
            this.timer = compound.m_128451_("Timer");
        }
        if (compound.m_128441_("TicketID")) {
            this.ticketID = compound.m_128342_("TicketID");
        }
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        super.m_142466_(compound);
    }

    @Override
    public void tick() {
        if (this.timer > 0) {
            --this.timer;
            if (!this.f_58857_.f_46443_) {
                CompoundTag compound = this.writeTimer(new CompoundTag());
                TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
            }
            if (this.timer <= 0) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return new PaygateMenu(windowId, inventory, this);
    }

    public Component m_5446_() {
        return this.getTitle();
    }

    public Component getTitle() {
        return new TranslatableComponent("gui.lightmanscurrency.paygate.title", new Object[]{this.m_7755_(), this.ownerName});
    }

    public Component m_7755_() {
        if (this.customName == null) {
            return new TranslatableComponent("block.lightmanscurrency.paygate");
        }
        return this.customName;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), 0, this.m_6945_(new CompoundTag()));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compound = pkt.m_131708_();
        this.m_142466_(compound);
    }
}

