/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.CashRegisterBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.interfaces.IOwnableBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.interfaces.IPermissions;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.MessageRequestNBT;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageRequestSyncUsers;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageSyncUsers;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public abstract class TraderBlockEntity
extends TickableBlockEntity
implements IOwnableBlockEntity,
IPermissions,
ITrader {
    String customName = "";
    protected UUID ownerID = null;
    protected String ownerName = "";
    protected List<String> allies = new ArrayList<String>();
    protected boolean isCreative = false;
    protected MoneyUtil.CoinValue storedMoney = new MoneyUtil.CoinValue(new MoneyUtil.CoinValue.CoinValuePair[0]);
    private List<Player> users = new ArrayList<Player>();
    private int userCount = 0;
    private boolean versionUpdate = false;
    private int oldVersion = 0;
    private boolean firstTick = true;

    @Override
    public UUID getOwnerID() {
        return this.ownerID;
    }

    protected TraderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void userOpen(Player player) {
        if (!this.users.contains(player)) {
            this.users.add(player);
            this.sendUserUpdate();
        }
    }

    public void userClose(Player player) {
        if (this.users.contains(player)) {
            this.users.remove(player);
            this.sendUserUpdate();
        }
    }

    public int getUserCount() {
        if (this.f_58857_.f_46443_) {
            return this.userCount;
        }
        return this.users.size();
    }

    protected List<Player> getUsers() {
        return this.users;
    }

    private void sendUserUpdate() {
        if (!this.f_58857_.f_46443_) {
            LevelChunk chunk = (LevelChunk)this.f_58857_.m_46865_(this.f_58858_);
            LightmansCurrencyPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new MessageSyncUsers(this.f_58858_, this.getUserCount()));
        }
    }

    public void setUserCount(int value) {
        this.userCount = value;
    }

    @Override
    public boolean isOwner(Player player) {
        if (this.ownerID != null) {
            return player.m_142081_().equals(this.ownerID) || TradingOffice.isAdminPlayer(player);
        }
        LightmansCurrency.LogError("Owner ID for the trading machine is null. Unable to determine if the owner is valid.");
        return true;
    }

    @Override
    public boolean hasPermissions(Player player) {
        return this.isOwner(player) || this.allies.contains(player.m_7755_().getString());
    }

    @Override
    public List<String> getAllies() {
        return this.allies;
    }

    @Override
    public void markAlliesDirty() {
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeAllies(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
    }

    public void setOwner(Entity player) {
        if (this.ownerID == null) {
            this.ownerID = player.m_142081_();
        }
        if (this.ownerID.equals(player.m_142081_())) {
            this.ownerName = player.m_7755_().getString();
        }
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeOwner(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
    }

    @Override
    public boolean canBreak(Player player) {
        return this.isOwner(player);
    }

    @Override
    public boolean isCreative() {
        return this.isCreative;
    }

    public void toggleCreative() {
        boolean bl = this.isCreative = !this.isCreative;
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeCreative(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
    }

    @Override
    public MoneyUtil.CoinValue getStoredMoney() {
        return this.storedMoney;
    }

    public void addStoredMoney(MoneyUtil.CoinValue addedAmount) {
        this.storedMoney.addValue(addedAmount);
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeStoredMoney(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
    }

    public void removeStoredMoney(MoneyUtil.CoinValue removedAmount) {
        long newValue = this.storedMoney.getRawValue() - removedAmount.getRawValue();
        this.storedMoney.readFromOldValue(newValue);
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeStoredMoney(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
    }

    public void clearStoredMoney() {
        this.storedMoney = new MoneyUtil.CoinValue(new MoneyUtil.CoinValue.CoinValuePair[0]);
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeStoredMoney(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
    }

    @Override
    public void clientTick() {
        if (this.firstTick) {
            this.firstTick = false;
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageRequestNBT(this));
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageRequestSyncUsers(this.f_58858_));
        }
    }

    @Override
    public void serverTick() {
        if (this.versionUpdate && this.f_58857_ != null) {
            this.versionUpdate = false;
            this.onVersionUpdate(this.oldVersion);
        }
    }

    @Override
    public Component getName() {
        if (this.customName != "") {
            return new TextComponent(this.customName);
        }
        if (this.f_58857_.f_46443_) {
            return this.m_58900_().m_60734_().m_49954_();
        }
        return new TextComponent("");
    }

    public Component getTitle() {
        if (this.isCreative) {
            return this.getName();
        }
        return new TranslatableComponent("gui.lightmanscurrency.trading.title", new Object[]{this.getName(), this.ownerName});
    }

    @Override
    public boolean hasCustomName() {
        return this.customName != null;
    }

    public void setCustomName(String customName) {
        LightmansCurrency.LogInfo("Custom Name set to '" + customName + "'");
        this.customName = customName;
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeCustomName(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
    }

    public abstract MenuProvider getTradeMenuProvider();

    public void openTradeMenu(Player player) {
        MenuProvider provider = this.getTradeMenuProvider();
        if (provider == null) {
            LightmansCurrency.LogError("No trade menu container provider was given for the trader of type " + this.m_58903_().getRegistryName().toString());
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the trade menu.");
            return;
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)this.f_58858_);
    }

    public abstract MenuProvider getStorageMenuProvider();

    public void openStorageMenu(Player player) {
        MenuProvider provider = this.getStorageMenuProvider();
        if (provider == null) {
            LightmansCurrency.LogError("No storage container provider was given for the trader of type " + this.m_58903_().getRegistryName().toString());
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the storage menu.");
            return;
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)this.f_58858_);
    }

    public abstract MenuProvider getCashRegisterTradeMenuProvider(CashRegisterBlockEntity var1);

    public void openCashRegisterTradeMenu(Player player, CashRegisterBlockEntity cashRegister) {
        MenuProvider provider = this.getCashRegisterTradeMenuProvider(cashRegister);
        if (provider == null) {
            LightmansCurrency.LogError("No cash register container provider was given for the trader of type " + this.m_58903_().getRegistryName().toString());
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the cash register menu.");
            return;
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (Consumer)new CRDataWriter(this.f_58858_, cashRegister.m_58899_()));
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        this.writeOwner(compound);
        this.writeStoredMoney(compound);
        this.writeCreative(compound);
        this.writeCustomName(compound);
        this.writeVersion(compound);
        this.writeAllies(compound);
        return super.m_6945_(compound);
    }

    public CompoundTag superWrite(CompoundTag compound) {
        return super.m_6945_(compound);
    }

    protected CompoundTag writeOwner(CompoundTag compound) {
        if (this.ownerID != null) {
            compound.m_128362_("OwnerID", this.ownerID);
        }
        if (this.ownerName != "") {
            compound.m_128359_("OwnerName", this.ownerName);
        }
        return compound;
    }

    protected CompoundTag writeStoredMoney(CompoundTag compound) {
        this.storedMoney.writeToNBT(compound, "StoredMoney");
        return compound;
    }

    protected CompoundTag writeCreative(CompoundTag compound) {
        compound.m_128379_("Creative", this.isCreative);
        return compound;
    }

    protected CompoundTag writeCustomName(CompoundTag compound) {
        compound.m_128359_("CustomName", this.customName);
        return compound;
    }

    protected CompoundTag writeVersion(CompoundTag compound) {
        compound.m_128405_("TraderVersion", this.GetCurrentVersion());
        return compound;
    }

    protected CompoundTag writeAllies(CompoundTag compound) {
        ListTag allyList = new ListTag();
        this.allies.forEach(ally -> {
            CompoundTag thisAlly = new CompoundTag();
            thisAlly.m_128359_("name", ally);
            allyList.add((Object)thisAlly);
        });
        compound.m_128365_("Allies", (Tag)allyList);
        return compound;
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("OwnerID")) {
            this.ownerID = compound.m_128342_("OwnerID");
        }
        if (compound.m_128425_("OwnerName", 8)) {
            this.ownerName = compound.m_128461_("OwnerName");
        }
        if (compound.m_128425_("StoredMoney", 3)) {
            LightmansCurrency.LogInfo("Reading stored money from older value format. Will be updated to newer value format.");
            this.storedMoney.readFromOldValue(compound.m_128451_("StoredMoney"));
        } else if (compound.m_128441_("StoredMoney")) {
            this.storedMoney.readFromNBT(compound, "StoredMoney");
        }
        if (compound.m_128441_("Creative")) {
            this.isCreative = compound.m_128471_("Creative");
        }
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = compound.m_128461_("CustomName");
        }
        if (compound.m_128425_("Allies", 9)) {
            this.allies.clear();
            ListTag allyList = compound.m_128437_("Allies", 10);
            for (int i = 0; i < allyList.size(); ++i) {
                CompoundTag thisAlly = allyList.m_128728_(i);
                if (!thisAlly.m_128425_("name", 8)) continue;
                this.allies.add(thisAlly.m_128461_("name"));
            }
        }
        if (compound.m_128425_("TraderVersion", 3)) {
            this.oldVersion = compound.m_128451_("TraderVersion");
        }
        if (this.oldVersion < this.GetCurrentVersion()) {
            this.versionUpdate = true;
        }
        super.m_142466_(compound);
    }

    protected abstract void onVersionUpdate(int var1);

    public int GetCurrentVersion() {
        return 0;
    }

    public void dumpContents(Level world, BlockPos pos) {
        List<ItemStack> coinItems = MoneyUtil.getCoinsOfValue(this.storedMoney);
        if (coinItems.size() > 0) {
            InventoryUtil.dumpContents(world, pos, coinItems);
        }
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), 0, this.m_6945_(new CompoundTag()));
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compound = pkt.m_131708_();
        this.m_142466_(compound);
    }

    private class CRDataWriter
    implements Consumer<FriendlyByteBuf> {
        BlockPos traderPos;
        BlockPos registerPos;

        public CRDataWriter(BlockPos traderPos, BlockPos registerPos) {
            this.traderPos = traderPos;
            this.registerPos = registerPos;
        }

        @Override
        public void accept(FriendlyByteBuf buffer) {
            buffer.m_130064_(this.traderPos);
            buffer.m_130064_(this.registerPos);
        }
    }

    protected class TradeIndexDataWriter
    implements Consumer<FriendlyByteBuf> {
        BlockPos traderPos;
        int tradeIndex;

        public TradeIndexDataWriter(BlockPos traderPos, int tradeIndex) {
            this.traderPos = traderPos;
            this.tradeIndex = tradeIndex;
        }

        @Override
        public void accept(FriendlyByteBuf buffer) {
            buffer.m_130064_(this.traderPos);
            buffer.writeInt(this.tradeIndex);
        }
    }
}

