/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.interfaces.IOwnableBlockEntity;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class UniversalTraderBlockEntity
extends BlockEntity
implements IOwnableBlockEntity {
    UUID traderID = null;

    protected UniversalTraderData getData() {
        if (this.traderID != null) {
            return TradingOffice.getData(this.traderID);
        }
        LightmansCurrency.LogError("Trader ID is null. Cannot get the data (" + (this.f_58857_.f_46443_ ? "client" : "server"));
        return null;
    }

    public UniversalTraderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public UUID getTraderID() {
        return this.traderID;
    }

    public void updateOwner(Entity player) {
        if (this.getData() != null && player.m_142081_().equals(this.getData().getOwnerID())) {
            this.getData().updateOwnerName(player.m_5446_().getString());
        } else if (this.getData() == null) {
            LightmansCurrency.LogError("Trader Data for trader of id '" + this.traderID + "' is null (tileEntity.updateOwner," + (this.f_58857_.f_46443_ ? "client" : "server") + ").");
        }
    }

    public boolean isOwner(Player player) {
        if (this.getData() == null) {
            LightmansCurrency.LogError("Trader Data for trader of id '" + this.traderID + "' is null (tileEntity.isOwner," + (this.f_58857_.f_46443_ ? "client" : "server") + ").");
            return true;
        }
        return this.getData().isOwner(player);
    }

    public boolean hasPermissions(Player player) {
        if (this.getData() == null) {
            LightmansCurrency.LogError("Trader Data for trader of id '" + this.traderID + "' is null (tileEntity.isOwner," + (this.f_58857_.f_46443_ ? "client" : "server") + ").");
            return true;
        }
        return this.getData().hasPermissions(player);
    }

    @Override
    public boolean canBreak(Player player) {
        return this.isOwner(player);
    }

    public void init(Player owner) {
        this.init(owner, null);
    }

    public void init(Player owner, String customName) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.traderID == null) {
            this.traderID = UUID.randomUUID();
            UniversalTraderData traderData = this.createInitialData((Entity)owner);
            if (customName != null) {
                traderData.setName(customName);
            }
            TradingOffice.registerTrader(this.traderID, traderData, owner);
            TileEntityUtil.sendUpdatePacket(this);
        }
    }

    protected abstract UniversalTraderData createInitialData(Entity var1);

    public CompoundTag m_6945_(CompoundTag compound) {
        if (this.traderID != null) {
            compound.m_128362_("ID", this.traderID);
        }
        return super.m_6945_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("ID")) {
            this.traderID = compound.m_128342_("ID");
        }
        super.m_142466_(compound);
    }

    public void openStorageMenu(Player player) {
        if (!this.f_58857_.f_46443_ && this.getData() != null) {
            this.getData().openStorageMenu(player);
        }
    }

    public void onDestroyed() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        UniversalTraderData data = this.getData();
        TradingOffice.removeTrader(this.traderID);
        if (data != null) {
            this.dumpContents(data);
        }
    }

    protected void dumpContents(@Nonnull UniversalTraderData data) {
        InventoryUtil.dumpContents(this.f_58857_, this.m_58899_(), MoneyUtil.getCoinsOfValue(data.getStoredMoney()));
    }
}

