/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import io.github.lightman314.lightmanscurrency.blockentity.PaygateBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.interfaces.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.blocks.templates.RotatableBlock;
import io.github.lightman314.lightmanscurrency.blocks.util.TickerUtil;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class PaygateBlock
extends RotatableBlock
implements EntityBlock,
IOwnableBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public PaygateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PaygateBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TickerUtil.createTickerHelper(type, ModBlockEntities.PAYGATE, TickableBlockEntity::tickHandler);
    }

    @Override
    public boolean canBreak(Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PaygateBlockEntity) {
            PaygateBlockEntity paygate = (PaygateBlockEntity)blockEntity;
            return paygate.canBreak(player);
        }
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity tileEntity;
        if (!level.f_46443_ && (tileEntity = level.m_7702_(pos)) instanceof PaygateBlockEntity) {
            PaygateBlockEntity paygate = (PaygateBlockEntity)tileEntity;
            if (paygate.isOwner((Entity)player)) {
                paygate.setOwner((Entity)player);
            }
            if (!paygate.isActive() && paygate.validTicket(player.m_21120_(hand))) {
                paygate.activate();
                player.m_21120_(hand).m_41774_(1);
                ItemStack ticketStub = new ItemStack((ItemLike)ModItems.TICKET_STUB);
                player.m_150109_().m_150079_(ticketStub);
                return InteractionResult.SUCCESS;
            }
            TileEntityUtil.sendUpdatePacket(tileEntity);
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)paygate, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof PaygateBlockEntity) {
            PaygateBlockEntity paygate = (PaygateBlockEntity)blockEntity;
            paygate.setOwner((Entity)player);
            if (stack.m_41788_()) {
                paygate.setCustomName(stack.m_41786_());
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PaygateBlockEntity) {
            PaygateBlockEntity paygate = (PaygateBlockEntity)blockEntity;
            if (!paygate.canBreak(player)) {
                return;
            }
            List<ItemStack> coins = MoneyUtil.getCoinsOfValue(paygate.getStoredMoney());
            InventoryUtil.dumpContents(level, pos, coins);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction dir) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }
}

