/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientTradingOffice {
    private static Map<UUID, UniversalTraderData> loadedTraders = new HashMap<UUID, UniversalTraderData>();

    public static List<UniversalTraderData> getTraderList() {
        return loadedTraders.values().stream().collect(Collectors.toList());
    }

    public static UniversalTraderData getData(UUID traderID) {
        if (loadedTraders.containsKey(traderID)) {
            return loadedTraders.get(traderID);
        }
        return null;
    }

    public static void initData(List<UniversalTraderData> data) {
        loadedTraders.clear();
        data.forEach(trader -> loadedTraders.put(trader.getTraderID(), trader.flagAsClient()));
    }

    public static void updateTrader(CompoundTag compound) {
        UUID traderID = compound.m_128342_("ID");
        if (loadedTraders.containsKey(traderID)) {
            loadedTraders.get(traderID).read(compound);
        } else {
            loadedTraders.put(traderID, TradingOffice.Deserialize(compound).flagAsClient());
        }
    }

    public static void removeTrader(UUID traderID) {
        if (loadedTraders.containsKey(traderID)) {
            loadedTraders.remove(traderID);
        }
    }
}

