/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.item_trader.MessageSetItemPrice;
import io.github.lightman314.lightmanscurrency.network.message.item_trader.MessageSetTraderRules;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageOpenStorage;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class TradeItemPriceScreen
extends Screen
implements CoinValueInput.ICoinValueInput {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/tradeprice.png");
    private int xSize = 176;
    private int ySize = 157;
    Player player;
    ItemTraderBlockEntity tileEntity;
    ItemTradeData trade;
    int tradeIndex;
    Button buttonSetSell;
    Button buttonSetPurchase;
    Button buttonSetBarter;
    Button buttonTradeRules;
    Button buttonSetFree;
    ItemTradeData.ItemTradeType localDirection;
    CoinValueInput priceInput;
    EditBox nameField;

    public TradeItemPriceScreen(ItemTraderBlockEntity tileEntity, int tradeIndex, Player player) {
        super((Component)new TranslatableComponent("gui.lightmanscurrency.changeprice"));
        this.tileEntity = tileEntity;
        this.tradeIndex = tradeIndex;
        this.trade = tileEntity.getTrade(this.tradeIndex);
        this.player = player;
        this.localDirection = this.trade.getTradeType();
    }

    protected void m_7856_() {
        int guiLeft = (this.f_96543_ - this.xSize) / 2;
        int guiTop = (this.f_96544_ - this.ySize) / 2;
        this.priceInput = (CoinValueInput)this.m_142416_((GuiEventListener)new CoinValueInput(guiTop, this.f_96539_, this.trade.getCost(), this));
        this.priceInput.init();
        this.nameField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, guiLeft + 8, guiTop + 69 + 38, 160, 18, (Component)new TextComponent("")));
        this.nameField.m_94144_(this.trade.getCustomName());
        this.nameField.m_94199_(30);
        this.buttonSetSell = (Button)this.m_142416_((GuiEventListener)new Button(guiLeft + 7, guiTop + 69 + 6, 50, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.tradedirection.sale"), this::SetTradeDirection));
        this.buttonSetPurchase = (Button)this.m_142416_((GuiEventListener)new Button(guiLeft + 63, guiTop + 69 + 6, 51, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.tradedirection.purchase"), this::SetTradeDirection));
        this.buttonSetBarter = (Button)this.m_142416_((GuiEventListener)new Button(guiLeft + 120, guiTop + 69 + 6, 50, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.tradedirection.barter"), this::SetTradeDirection));
        this.m_142416_((GuiEventListener)new Button(guiLeft + 7, guiTop + 69 + 62, 50, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.save"), this::PressSaveButton));
        this.m_142416_((GuiEventListener)new Button(guiLeft + 120, guiTop + 69 + 62, 50, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.back"), this::PressBackButton));
        this.buttonSetFree = (Button)this.m_142416_((GuiEventListener)new Button(guiLeft + 63, guiTop + 69 + 62, 51, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.free"), this::PressFreeButton));
        this.buttonTradeRules = (Button)this.m_142416_((GuiEventListener)new IconButton(guiLeft + this.xSize, guiTop + 69, this::PressTradeRuleButton, GUI_TEXTURE, this.xSize, 0));
        this.m_96624_();
    }

    public void m_96624_() {
        if (this.tileEntity.m_58901_()) {
            this.player.m_6915_();
            return;
        }
        this.buttonSetSell.f_93623_ = this.localDirection != ItemTradeData.ItemTradeType.SALE;
        this.buttonSetPurchase.f_93623_ = this.localDirection != ItemTradeData.ItemTradeType.PURCHASE;
        this.buttonSetBarter.f_93623_ = this.localDirection != ItemTradeData.ItemTradeType.BARTER;
        this.buttonSetFree.f_93623_ = this.localDirection != ItemTradeData.ItemTradeType.BARTER;
        this.priceInput.f_93624_ = this.localDirection != ItemTradeData.ItemTradeType.BARTER;
        super.m_96624_();
        this.priceInput.tick();
        this.nameField.m_94120_();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        this.m_93228_(poseStack, startX, startY + 69, 0, 0, this.xSize, this.ySize - 69);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92883_(poseStack, new TranslatableComponent("gui.lightmanscurrency.customname").getString(), (float)startX + 8.0f, (float)(startY + 69) + 28.0f, 0x404040);
        if (this.buttonTradeRules.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(poseStack, (Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.traderules"), mouseX, mouseY);
        }
    }

    protected void PressFreeButton(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetItemPrice(this.tileEntity.m_58899_(), this.tradeIndex, new MoneyUtil.CoinValue(new MoneyUtil.CoinValue.CoinValuePair[0]), true, this.nameField.m_94155_(), this.localDirection.name()));
        this.PressBackButton(button);
    }

    protected void PressSaveButton(Button button) {
        this.SaveChanges();
        this.PressBackButton(button);
    }

    protected void SaveChanges() {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetItemPrice(this.tileEntity.m_58899_(), this.tradeIndex, this.priceInput.getCoinValue(), false, this.nameField.m_94155_(), this.localDirection.name()));
    }

    protected void PressBackButton(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenStorage(this.tileEntity.m_58899_()));
    }

    protected void SetTradeDirection(Button button) {
        if (button == this.buttonSetSell) {
            this.localDirection = ItemTradeData.ItemTradeType.SALE;
        } else if (button == this.buttonSetPurchase) {
            this.localDirection = ItemTradeData.ItemTradeType.PURCHASE;
        } else if (button == this.buttonSetBarter) {
            this.localDirection = ItemTradeData.ItemTradeType.BARTER;
        } else {
            LightmansCurrency.LogWarning("Invalid button triggered SetTradeDirection");
        }
    }

    protected void PressTradeRuleButton(Button button) {
        Minecraft.m_91087_().m_91152_((Screen)new TradeRuleScreen(this.GetRuleScreenBackHandler()));
    }

    public ITradeRuleScreenHandler GetRuleScreenBackHandler() {
        return new CloseRuleHandler(this.tileEntity, this.tradeIndex, this.player);
    }

    @Override
    public <T extends GuiEventListener & Widget> T addCustomWidget(T button) {
        return (T)this.m_142416_(button);
    }

    @Override
    public int getWidth() {
        return this.f_96543_;
    }

    @Override
    public void OnCoinValueChanged(CoinValueInput input) {
    }

    @Override
    public Font getFont() {
        return this.f_96547_;
    }

    private static class CloseRuleHandler
    implements ITradeRuleScreenHandler {
        final ItemTraderBlockEntity tileEntity;
        final int tradeIndex;
        final Player player;

        public CloseRuleHandler(ItemTraderBlockEntity tileEntity, int tradeIndex, Player player) {
            this.tileEntity = tileEntity;
            this.tradeIndex = tradeIndex;
            this.player = player;
        }

        @Override
        public ITradeRuleHandler ruleHandler() {
            return this.tileEntity.getTrade(this.tradeIndex);
        }

        @Override
        public void reopenLastScreen() {
            Minecraft.m_91087_().m_91152_((Screen)new TradeItemPriceScreen(this.tileEntity, this.tradeIndex, this.player));
        }

        @Override
        public void updateServer(List<TradeRule> newRules) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetTraderRules(this.tileEntity.m_58899_(), newRules, this.tradeIndex));
        }
    }
}

