/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.ItemTradeButton;
import io.github.lightman314.lightmanscurrency.common.ItemTraderUtil;
import io.github.lightman314.lightmanscurrency.menus.ItemTraderMenu;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageExecuteTrade;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageOpenStorage;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ItemTraderScreen
extends AbstractContainerScreen<ItemTraderMenu> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/trader.png");
    public static final int TRADEBUTTON_VERT_SPACER = 4;
    public static final int TRADEBUTTON_VERTICALITY = 22;
    public static final int TRADEBUTTON_HORIZ_SPACER = 6;
    public static final int TRADEBUTTON_HORIZONTAL = 85;
    Button buttonShowStorage;
    Button buttonCollectMoney;
    protected List<ItemTradeButton> tradeButtons = new ArrayList<ItemTradeButton>();

    public ItemTraderScreen(ItemTraderMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97727_ = 133 + ItemTraderUtil.getTradeDisplayHeight(((ItemTraderMenu)this.f_97732_).tileEntity);
        this.f_97726_ = ItemTraderUtil.getWidth(((ItemTraderMenu)this.f_97732_).tileEntity);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        ItemTraderScreen.drawTraderBackground(poseStack, (Screen)this, this.f_97732_, this.f_96541_, this.f_97726_, this.f_97727_, ((ItemTraderMenu)this.f_97732_).tileEntity);
    }

    public static void drawTraderBackground(PoseStack poseStack, Screen screen, AbstractContainerMenu container, Minecraft minecraft, int imageWidth, int imageHeight, IItemTrader trader) {
        int x;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = (screen.f_96543_ - imageWidth) / 2;
        int startY = (screen.f_96544_ - imageHeight) / 2;
        int columnCount = ItemTraderUtil.getTradeDisplayColumnCount(trader);
        int rowCount = ItemTraderUtil.getTradeDisplayRowCount(trader);
        int tradeOffset = ItemTraderUtil.getTradeDisplayOffset(trader);
        screen.m_93228_(poseStack, startX + ItemTraderUtil.getTradeDisplayOffset(trader), startY, 0, 0, 6, 17);
        for (x = 0; x < columnCount; ++x) {
            screen.m_93228_(poseStack, startX + tradeOffset + x * 85 + 6, startY, 6, 0, 79, 17);
            if (x >= columnCount - 1) continue;
            screen.m_93228_(poseStack, startX + tradeOffset + x * 85 + 79 + 6, startY, 85, 0, 6, 17);
        }
        screen.m_93228_(poseStack, startX + tradeOffset + ItemTraderUtil.getTradeDisplayWidth(trader) - 6, startY, 91, 0, 6, 17);
        for (int y = 0; y < rowCount; ++y) {
            screen.m_93228_(poseStack, startX + tradeOffset, startY + 17 + y * 22, 0, 17, 6, 22);
            for (int x2 = 0; x2 < columnCount; ++x2) {
                screen.m_93228_(poseStack, startX + tradeOffset + x2 * 85 + 6, startY + 17 + y * 22, 6, 17, 79, 22);
                if (x2 >= columnCount - 1) continue;
                screen.m_93228_(poseStack, startX + tradeOffset + x2 * 85 + 79 + 6, startY + 17 + y * 22, 85, 17, 6, 22);
            }
            screen.m_93228_(poseStack, startX + tradeOffset + ItemTraderUtil.getTradeDisplayWidth(trader) - 6, startY + 17 + y * 22, 91, 17, 6, 22);
        }
        screen.m_93228_(poseStack, startX + tradeOffset, startY + 17 + rowCount * 22, 0, 43, 6, 7);
        for (x = 0; x < columnCount; ++x) {
            screen.m_93228_(poseStack, startX + tradeOffset + x * 85 + 6, startY + 17 + rowCount * 22, 6, 43, 79, 7);
            if (x >= columnCount - 1) continue;
            screen.m_93228_(poseStack, startX + tradeOffset + x * 85 + 79 + 6, startY + 17 + rowCount * 22, 6, 43, 6, 7);
        }
        screen.m_93228_(poseStack, startX + tradeOffset + ItemTraderUtil.getTradeDisplayWidth(trader) - 6, startY + 17 + rowCount * 22, 91, 43, 6, 7);
        screen.m_93228_(poseStack, startX + ItemTraderUtil.getInventoryDisplayOffset(trader), startY + ItemTraderUtil.getTradeDisplayHeight(trader), 0, 50, 176, 133);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        ItemTraderScreen.drawTraderForeground(poseStack, this.f_96547_, ((ItemTraderMenu)this.f_97732_).tileEntity, this.f_97727_, ((ItemTraderMenu)this.f_97732_).tileEntity.getTitle(), this.f_169604_, (Component)new TranslatableComponent("tooltip.lightmanscurrency.credit", new Object[]{MoneyUtil.getStringOfValue(((ItemTraderMenu)this.f_97732_).GetCoinValue())}));
    }

    public static void drawTraderForeground(PoseStack poseStack, Font font, IItemTrader trader, int ySize, Component title, Component inventoryTitle, Component creditText) {
        int tradeOffset = ItemTraderUtil.getTradeDisplayOffset(trader);
        int inventoryOffset = ItemTraderUtil.getInventoryDisplayOffset(trader);
        font.m_92889_(poseStack, title, (float)tradeOffset + 8.0f, 6.0f, 0x404040);
        font.m_92889_(poseStack, inventoryTitle, (float)inventoryOffset + 8.0f, (float)(ySize - 94), 0x404040);
        font.m_92889_(poseStack, creditText, (float)inventoryOffset + 80.0f, (float)ySize - 124.0f, 0x404040);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (((ItemTraderMenu)this.f_97732_).hasPermissions()) {
            int tradeOffset = ItemTraderUtil.getTradeDisplayOffset(((ItemTraderMenu)this.f_97732_).tileEntity);
            this.buttonShowStorage = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ - 20 + tradeOffset, this.f_97736_, this::PressStorageButton, GUI_TEXTURE, 176, 0));
            if (((ItemTraderMenu)this.f_97732_).isOwner()) {
                this.buttonCollectMoney = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ - 20 + tradeOffset, this.f_97736_ + 20, this::PressCollectionButton, GUI_TEXTURE, 192, 0));
                this.buttonCollectMoney.f_93623_ = false;
            }
        }
        this.initTradeButtons();
    }

    protected void initTradeButtons() {
        int tradeCount = ((ItemTraderMenu)this.f_97732_).tileEntity.getTradeCount();
        for (int i = 0; i < tradeCount; ++i) {
            this.tradeButtons.add((ItemTradeButton)this.m_142416_((GuiEventListener)new ItemTradeButton(this.f_97735_ + ItemTraderUtil.getButtonPosX(((ItemTraderMenu)this.f_97732_).tileEntity, i), this.f_97736_ + ItemTraderUtil.getButtonPosY(((ItemTraderMenu)this.f_97732_).tileEntity, i), this::PressTradeButton, i, (Screen)this, this.f_96547_, (Supplier<IItemTrader>)((Supplier)() -> ((ItemTraderMenu)this.f_97732_).tileEntity), (Supplier<Long>)((Supplier)((ItemTraderMenu)this.f_97732_)::GetCoinValue), (Supplier<Container>)((Supplier)((ItemTraderMenu)this.f_97732_)::GetItemInventory))));
        }
    }

    public void m_181908_() {
        ((ItemTraderMenu)this.f_97732_).tick();
        if (this.buttonCollectMoney != null) {
            boolean bl = this.buttonCollectMoney.f_93623_ = ((ItemTraderMenu)this.f_97732_).tileEntity.getStoredMoney().getRawValue() > 0L;
            if (!this.buttonCollectMoney.f_93623_) {
                this.buttonCollectMoney.f_93624_ = !((ItemTraderMenu)this.f_97732_).tileEntity.isCreative();
            }
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        if (this.buttonShowStorage != null && this.buttonShowStorage.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.openstorage"), mouseX, mouseY);
        } else if (this.buttonCollectMoney != null && this.buttonCollectMoney.f_93623_ && this.buttonCollectMoney.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.collectcoins", new Object[]{((ItemTraderMenu)this.f_97732_).tileEntity.getStoredMoney().getString()}), mouseX, mouseY);
        }
        for (int i = 0; i < this.tradeButtons.size(); ++i) {
            this.tradeButtons.get(i).tryRenderTooltip(matrixStack, (Screen)this, ((ItemTraderMenu)this.f_97732_).tileEntity, false, mouseX, mouseY);
        }
    }

    private void PressStorageButton(Button button) {
        if (((ItemTraderMenu)this.f_97732_).hasPermissions()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenStorage(((ItemTraderMenu)this.f_97732_).tileEntity.m_58899_()));
        } else {
            LightmansCurrency.LogWarning("Player without permissions attempted to open the Trader's Storage.");
        }
    }

    private void PressCollectionButton(Button button) {
        if (((ItemTraderMenu)this.f_97732_).isOwner()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCollectCoins());
        } else {
            LightmansCurrency.LogWarning("Non-owner attempted to collect the stored money.");
        }
    }

    private void PressTradeButton(Button button) {
        int tradeIndex = 0;
        if (this.tradeButtons.contains(button)) {
            tradeIndex = this.tradeButtons.indexOf(button);
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageExecuteTrade(tradeIndex));
    }
}

