/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CoinValueInput
extends AbstractWidget {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/coinvalueinput.png");
    public static final int HEIGHT = 69;
    private final int leftOffset;
    private final ICoinValueInput parent;
    private MoneyUtil.CoinValue coinValue;
    private List<Button> increaseButtons;
    private List<Button> decreaseButtons;
    private Component title;

    public CoinValueInput(int y, Component title, MoneyUtil.CoinValue startingValue, @Nonnull ICoinValueInput parent) {
        super(0, y, CoinValueInput.calculateWidth(), 69, title);
        this.title = title;
        this.leftOffset = this.f_93618_ == parent.getWidth() ? 0 : (parent.getWidth() - this.f_93618_) / 2;
        this.parent = parent;
        this.coinValue = startingValue.copy();
    }

    public void init() {
        this.increaseButtons = new ArrayList<Button>();
        this.decreaseButtons = new ArrayList<Button>();
        int buttonCount = MoneyUtil.getAllData().size();
        for (int x = 0; x < buttonCount; ++x) {
            Button newButton = this.parent.addCustomWidget(new PlainButton(this.leftOffset + 10 + x * 30, this.f_93621_ + 15, 20, 10, this::IncreaseButtonHit, GUI_TEXTURE, 0, 69));
            newButton.f_93623_ = true;
            this.increaseButtons.add(newButton);
            newButton = this.parent.addCustomWidget(new PlainButton(this.leftOffset + 10 + x * 30, this.f_93621_ + 53, 20, 10, this::DecreaseButtonHit, GUI_TEXTURE, 20, 69));
            newButton.f_93623_ = false;
            this.decreaseButtons.add(newButton);
        }
        this.tick();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int x;
        this.increaseButtons.forEach(button -> {
            button.f_93624_ = this.f_93624_;
        });
        this.decreaseButtons.forEach(button -> {
            button.f_93624_ = this.f_93624_;
        });
        if (!this.f_93624_) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = this.f_93620_ + this.leftOffset;
        int startY = this.f_93621_;
        this.m_93228_(poseStack, startX, startY, 0, 0, 10, 69);
        List<MoneyUtil.CoinData> coinData = MoneyUtil.getAllData();
        int buttonCount = coinData.size();
        for (x = 0; x < buttonCount; ++x) {
            this.m_93228_(poseStack, startX + 10 + x * 30, startY, 10, 0, 20, 69);
            if (x >= buttonCount - 1) continue;
            this.m_93228_(poseStack, startX + 30 + x * 30, startY, 30, 0, 10, 69);
        }
        this.m_93228_(poseStack, startX + 30 + (buttonCount - 1) * 30, startY, 40, 0, 10, 69);
        for (x = 0; x < buttonCount; ++x) {
            ItemRenderUtil.drawItemStack(this.parent.getFont(), new ItemStack((ItemLike)coinData.get(x).getCoinItem()), startX + x * 30 + 12, startY + 26, false);
            String countString = String.valueOf(this.coinValue.getEntry(coinData.get(x).getCoinItem()));
            int width = this.parent.getFont().m_92895_(countString);
            this.parent.getFont().m_92883_(poseStack, countString, (float)(startX + x * 30 + 20 - width / 2), (float)(startY + 43), 0x404040);
        }
        this.parent.getFont().m_92883_(poseStack, this.title.getString(), (float)startX + 8.0f, (float)startY + 5.0f, 0x404040);
        int priceWidth = this.parent.getFont().m_92895_(this.coinValue.getString());
        this.parent.getFont().m_92883_(poseStack, this.coinValue.getString(), (float)(startX + this.f_93618_) - 5.0f - (float)priceWidth, (float)startY + 5.0f, 0x404040);
    }

    public void tick() {
        List<Item> coinItems = MoneyUtil.getAllCoins();
        for (int i = 0; i < this.decreaseButtons.size(); ++i) {
            this.decreaseButtons.get((int)i).f_93623_ = i >= coinItems.size() ? false : this.coinValue.getEntry(coinItems.get(i)) > 0;
        }
    }

    public static int calculateWidth() {
        int buttonCount = MoneyUtil.getAllData().size();
        return 20 + 20 * buttonCount + 10 * (buttonCount - 1);
    }

    public void IncreaseButtonHit(Button button) {
        if (!this.increaseButtons.contains(button)) {
            return;
        }
        int coinIndex = this.increaseButtons.indexOf(button);
        List<Item> coins = MoneyUtil.getAllCoins();
        if (coinIndex >= 0 && coinIndex < coins.size()) {
            Item coin = coins.get(coinIndex);
            int addAmount = 1;
            if (Screen.m_96638_()) {
                addAmount = this.getLargeIncreaseAmount(coin);
            }
            if (Screen.m_96637_()) {
                addAmount *= 10;
            }
            this.coinValue.addValue(coin, addAmount);
            this.parent.OnCoinValueChanged(this);
        } else {
            LightmansCurrency.LogError("Invalid index (" + coinIndex + ") found for the increasing button.");
        }
    }

    public void DecreaseButtonHit(Button button) {
        if (!this.decreaseButtons.contains(button)) {
            return;
        }
        int coinIndex = this.decreaseButtons.indexOf(button);
        List<Item> coins = MoneyUtil.getAllCoins();
        if (coinIndex >= 0 && coinIndex < coins.size()) {
            Item coin = coins.get(coinIndex);
            int removeAmount = 1;
            if (Screen.m_96638_()) {
                removeAmount = this.getLargeIncreaseAmount(coin);
            }
            if (Screen.m_96637_()) {
                removeAmount *= 10;
            }
            this.coinValue.removeValue(coin, removeAmount);
            this.parent.OnCoinValueChanged(this);
        } else {
            LightmansCurrency.LogError("Invalid index (" + coinIndex + ") found for the decreasing button.");
        }
    }

    private final int getLargeIncreaseAmount(Item coinItem) {
        Pair<Item, Integer> upwardConversion = MoneyUtil.getUpwardConversion(coinItem);
        if (upwardConversion != null) {
            return this.getAmountFromConversion(upwardConversion);
        }
        Pair<Item, Integer> downwardConversion = MoneyUtil.getDownwardConversion(coinItem);
        if (downwardConversion != null) {
            return this.getAmountFromConversion(downwardConversion);
        }
        return 10;
    }

    private final int getAmountFromConversion(Pair<Item, Integer> conversion) {
        if ((Integer)conversion.getSecond() >= 64) {
            return 16;
        }
        if ((Integer)conversion.getSecond() > 10) {
            return 10;
        }
        if ((Integer)conversion.getSecond() > 5) {
            return 5;
        }
        return 2;
    }

    public MoneyUtil.CoinValue getCoinValue() {
        return this.coinValue;
    }

    public void m_142291_(NarrationElementOutput narrator) {
    }

    public static interface ICoinValueInput {
        public <T extends GuiEventListener & Widget> T addCustomWidget(T var1);

        public int getWidth();

        public Font getFont();

        public void OnCoinValueChanged(CoinValueInput var1);
    }
}

