/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemTradeButton
extends Button {
    public static final ResourceLocation TRADE_TEXTURES = new ResourceLocation("lightmanscurrency", "textures/gui/container/traderbuttons.png");
    public static final ResourceLocation DEFAULT_BACKGROUND = new ResourceLocation("lightmanscurrency", "items/empty_item_slot");
    public static final Pair<ResourceLocation, ResourceLocation> BACKGROUND = Pair.of((Object)InventoryMenu.f_39692_, (Object)DEFAULT_BACKGROUND);
    public static final int WIDTH = 79;
    public static final int HEIGHT = 18;
    public static final float TEXTPOS1_X = 59.0f;
    public static final float TEXTPOS2_X = 20.0f;
    public static final float TEXTPOS_Y = 5.0f;
    public static final int SLOT_OFFSET1_X = 62;
    public static final int SLOT_OFFSET2_X = 1;
    public static final int SLOT_OFFSET_Y = 1;
    int tradeIndex;
    Supplier<IItemTrader> source;
    Supplier<Long> availableCoins;
    Supplier<Container> itemSlots;
    Screen screen;
    Font font;

    public ItemTradeButton(int x, int y, Button.OnPress pressable, int tradeIndex, Screen screen, Font font, Supplier<IItemTrader> source, Supplier<Long> availableCoins, Supplier<Container> itemSlots) {
        super(x, y, 79, 18, (Component)new TextComponent(""), pressable);
        this.tradeIndex = tradeIndex;
        this.screen = screen;
        this.font = font;
        this.source = source;
        this.availableCoins = availableCoins;
        this.itemSlots = itemSlots;
    }

    private ItemTradeData getTrade() {
        return ((IItemTrader)this.source.get()).getTrade(this.tradeIndex);
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.f_93623_ = ItemTradeButton.isActive(this.getTrade(), (IItemTrader)this.source.get());
        ItemTradeButton.renderItemTradeButton(poseStack, this.screen, this.font, this.f_93620_, this.f_93621_, this.tradeIndex, (IItemTrader)this.source.get(), false, this.f_93622_, false, (Long)this.availableCoins.get(), (Container)this.itemSlots.get());
    }

    public static void renderItemTradeButton(PoseStack poseStack, Screen screen, Font font, int x, int y, int tradeIndex, IItemTrader trader, boolean inverted) {
        ItemTradeButton.renderItemTradeButton(poseStack, screen, font, x, y, tradeIndex, trader, inverted, false, true, 0L, (Container)new SimpleContainer(1));
    }

    private static void renderItemTradeButton(PoseStack poseStack, Screen screen, Font font, int x, int y, int tradeIndex, IItemTrader trader, boolean inverted, boolean hovered, boolean forceActive, long availableCoins, Container itemSlots) {
        boolean hasStock;
        boolean isValid;
        boolean active;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        ItemTradeData trade = trader.getTrade(tradeIndex);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TRADE_TEXTURES);
        boolean bl = active = forceActive ? true : ItemTradeButton.isActive(trade, trader);
        if (active) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        int offset = ItemTradeButton.getRenderYOffset(trade.getTradeType());
        if (hovered) {
            offset += 18;
        }
        screen.m_93228_(poseStack, x, y, inverted ? 79 : 0, offset, 79, 18);
        boolean hasPermission = forceActive;
        boolean hasDiscount = false;
        boolean bl2 = isValid = forceActive ? true : trade.isValid();
        boolean bl3 = forceActive ? true : (hasStock = trader.isCreative() || trade.hasStock(trader));
        boolean hasSpace = forceActive ? true : trader.isCreative() || trade.hasSpace(trader);
        boolean canAfford = forceActive;
        MoneyUtil.CoinValue cost = trade.getCost();
        if (!forceActive) {
            TradeEvent.TradeCostEvent event = trader.runTradeCostEvent((Player)player, tradeIndex);
            cost = event.getCostResult();
            hasDiscount = event.getCostMultiplier() != 1.0;
            hasPermission = !trader.runPreTradeEvent((Player)player, tradeIndex).isCanceled();
            canAfford = ItemTradeButton.canAfford(trade, availableCoins, itemSlots);
        }
        if (trade.isBarter()) {
            int xPos = x + (inverted ? 62 : 1);
            if (trade.getBarterItem().m_41619_() && forceActive) {
                xPos = x + (inverted ? 62 : 1);
                ItemRenderUtil.drawSlotBackground(poseStack, xPos, y + 1, BACKGROUND);
            } else if (!trade.getBarterItem().m_41619_()) {
                ItemRenderUtil.drawItemStack(screen, font, trade.getBarterItem(), xPos, y + 1, true);
            }
            String text = ItemTradeButton.getTradeText(MoneyUtil.CoinValue.EMPTY, false, isValid, hasStock, hasSpace, hasPermission);
            int textColor = ItemTradeButton.getTradeTextColor(trade.isValid(), canAfford, hasStock, hasPermission, false);
            if (text == "" && !canAfford) {
                text = "X";
                textColor = 0xFF0000;
            }
            int textLength = font.m_92895_(text);
            font.m_92883_(poseStack, text, (float)(x + 39 - textLength / 2), (float)y + 5.0f, textColor);
        } else {
            String tradeText = ItemTradeButton.getTradeText(cost, trade.isFree(), isValid, hasStock, hasSpace, hasPermission);
            int tradeColor = ItemTradeButton.getTradeTextColor(trade.isValid(), canAfford, hasStock, hasPermission, hasDiscount);
            if (inverted) {
                font.m_92883_(poseStack, tradeText, (float)x + 20.0f, (float)y + 5.0f, tradeColor);
            } else {
                int stringLength = font.m_92895_(tradeText);
                font.m_92883_(poseStack, tradeText, (float)x + 59.0f - (float)stringLength, (float)y + 5.0f, tradeColor);
            }
        }
        int xPos = x + (inverted ? 1 : 62);
        ItemStack sellItem = trade.getSellItem();
        if (sellItem.m_41619_() && forceActive) {
            Pair<ResourceLocation, ResourceLocation> background = trade.getRestriction().getEmptySlotBG();
            if (background == null) {
                background = BACKGROUND;
            }
            if (background != null) {
                ItemRenderUtil.drawSlotBackground(poseStack, xPos, y + 1, background);
            }
        } else if (!trade.getSellItem().m_41619_()) {
            ItemRenderUtil.drawItemStack(screen, font, trade.getSellItem(), xPos, y + 1, true);
        }
    }

    public void tryRenderTooltip(PoseStack poseStack, Screen screen, IItemTrader trader, boolean inverted, int mouseX, int mouseY) {
        if (this.f_93622_) {
            ItemTradeButton.tryRenderTooltip(poseStack, screen, this.tradeIndex, trader, this.f_93620_, this.f_93621_, inverted, mouseX, mouseY);
        }
    }

    public static int tryRenderTooltip(PoseStack poseStack, Screen screen, int tradeIndex, IItemTrader trader, int x, int y, boolean inverted, int mouseX, int mouseY) {
        switch (trader.getTrade(tradeIndex).getTradeType()) {
            case BARTER: {
                if (!ItemTradeButton.isMouseOverSlot(1, x, y, mouseX, mouseY, inverted)) break;
                List<Component> tooltip = ItemTradeButton.getTooltipForItem(screen, tradeIndex, 1, trader);
                if (tooltip != null) {
                    screen.m_96597_(poseStack, tooltip, mouseX, mouseY);
                    return 2;
                }
                return -2;
            }
        }
        if (ItemTradeButton.isMouseOverSlot(0, x, y, mouseX, mouseY, inverted)) {
            List<Component> tooltip = ItemTradeButton.getTooltipForItem(screen, tradeIndex, 0, trader);
            if (tooltip != null) {
                screen.m_96597_(poseStack, tooltip, mouseX, mouseY);
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public static boolean isMouseOverSlot(int slotIndex, int x, int y, int mouseX, int mouseY, boolean inverted) {
        int minX = x + (slotIndex == 1 ? 1 : 62);
        if (inverted) {
            minX = x + (slotIndex == 1 ? 62 : 1);
        }
        return mouseX >= minX && mouseX <= minX + 16 && mouseY >= y + 1 && mouseY <= y + 18 - 1;
    }

    public static List<Component> getTooltipForItem(Screen screen, int tradeIndex, int slot, IItemTrader trader) {
        ItemStack itemStack;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        ItemTradeData trade = trader.getTrade(tradeIndex);
        ItemStack itemStack2 = itemStack = slot == 1 ? trade.getBarterItem() : trade.getSellItem();
        if (itemStack.m_41619_()) {
            return null;
        }
        List tooltips = screen.m_96555_(itemStack);
        Component originalName = null;
        if (!trade.getCustomName().isEmpty() && (trade.isSale() || trade.isBarter() && slot != 1)) {
            originalName = (Component)tooltips.get(0);
            tooltips.set(0, new TextComponent("\u00a76" + trade.getCustomName()));
        }
        if (slot == 0) {
            tooltips.add(new TranslatableComponent("tooltip.lightmanscurrency.trader.info"));
            if (originalName != null) {
                tooltips.add(new TranslatableComponent("tooltip.lightmanscurrency.trader.originalname", new Object[]{originalName}));
            }
            tooltips.add(new TranslatableComponent("tooltip.lightmanscurrency.trader.stock", new Object[]{trader.isCreative() ? new TranslatableComponent("tooltip.lightmanscurrency.trader.stock.infinite") : new TextComponent("\u00a76" + trade.stockCount(trader))}));
            TradeEvent.PreTradeEvent pte = trader.runPreTradeEvent((Player)player, tradeIndex);
            if (pte.isCanceled()) {
                pte.getDenialReasons().forEach(reason -> tooltips.add(reason));
            }
        }
        return tooltips;
    }

    public static String getTradeText(MoneyUtil.CoinValue cost, boolean isFree, boolean isValid, boolean hasStock, boolean hasSpace, boolean hasPermission) {
        if (isValid && !hasPermission) {
            return new TranslatableComponent("tooltip.lightmanscurrency.denied").getString();
        }
        if (isValid && !hasStock) {
            return new TranslatableComponent("tooltip.lightmanscurrency.outofstock").getString();
        }
        if (isValid && !hasSpace) {
            return new TranslatableComponent("tooltip.lightmanscurrency.outofspace").getString();
        }
        if (isValid && isFree) {
            return new TranslatableComponent("gui.button.lightmanscurrency.free").getString();
        }
        return cost.getString();
    }

    public static int getTradeTextColor(boolean isValid, boolean canAfford, boolean hasStock, boolean hasPermission, boolean hasDiscount) {
        if (isValid && !hasStock || !canAfford || !hasPermission) {
            return 0xFF0000;
        }
        if (hasDiscount) {
            return 65280;
        }
        return 0xFFFFFF;
    }

    public static int getRenderYOffset(ItemTradeData.ItemTradeType tradeDirection) {
        if (tradeDirection == ItemTradeData.ItemTradeType.PURCHASE) {
            return 36;
        }
        if (tradeDirection == ItemTradeData.ItemTradeType.BARTER) {
            return 72;
        }
        return 0;
    }

    protected static boolean canAfford(ItemTradeData trade, long availableCoins, Container itemSlots) {
        if (trade.isSale()) {
            if (trade.isFree()) {
                return true;
            }
            return availableCoins >= trade.getCost().getRawValue();
        }
        if (trade.isPurchase()) {
            return InventoryUtil.GetItemCount(itemSlots, trade.getSellItem()) >= trade.getSellItem().m_41613_();
        }
        if (trade.isBarter()) {
            return InventoryUtil.GetItemCount(itemSlots, trade.getBarterItem()) >= trade.getBarterItem().m_41613_();
        }
        return true;
    }

    public static boolean isActive(ItemTradeData trade, IItemTrader trader) {
        if (trade.isValid()) {
            return trader.isCreative() || trade.hasStock(trader) && trade.hasSpace(trader);
        }
        return false;
    }
}

