/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandLCAdmin {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder lcAdminCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lcadmin").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"help").executes(CommandLCAdmin::help))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"toggleadmin").requires(commandSource -> commandSource.m_81373_() instanceof ServerPlayer)).executes(CommandLCAdmin::toggleAdmin))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"universaldata").then(Commands.m_82127_((String)"list").executes(CommandLCAdmin::listUniversalData))).then(Commands.m_82127_((String)"search").then(Commands.m_82129_((String)"searchText", (ArgumentType)MessageArgument.m_96832_()).executes(CommandLCAdmin::searchUniversalData)))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"dataID", (ArgumentType)MessageArgument.m_96832_()).executes(CommandLCAdmin::deleteUniversalData))));
        dispatcher.register(lcAdminCommand);
    }

    static int help(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.help.help", new Object[]{"/lcadmin help -> "}), false);
        if (source.m_81373_() instanceof ServerPlayer) {
            source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.toggleadmin.help", new Object[]{"/lcadmin toggleadmin -> "}), false);
        }
        source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.list.help", new Object[]{"/lcadmin universaldata list -> "}), false);
        source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.delete.help", new Object[]{"/lcadmin universaldata delete <traderID> "}), false);
        return 1;
    }

    static int toggleAdmin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ServerPlayer sourcePlayer = source.m_81375_();
        TradingOffice.toggleAdminPlayer((Player)sourcePlayer);
        source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.toggleadmin", new Object[]{new TranslatableComponent("command.lightmanscurrency.lcadmin.toggleadmin." + (TradingOffice.isAdminPlayer((Player)sourcePlayer) ? "enabled" : "disabled"))}), true);
        return 1;
    }

    static int listUniversalData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        List<UniversalTraderData> allTraders = TradingOffice.getTraders();
        if (allTraders.size() > 0) {
            source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.list.title"), true);
            for (int i = 0; i < allTraders.size(); ++i) {
                UniversalTraderData thisTrader = allTraders.get(i);
                if (i > 0) {
                    source.m_81354_((Component)new TextComponent(""), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.list.none"), true);
        }
        return 1;
    }

    static int searchUniversalData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        String searchText = MessageArgument.m_96835_(commandContext, (String)"searchText").getString();
        List<UniversalTraderData> allTraders = TradingOffice.getTraders(searchText);
        if (allTraders.size() > 0) {
            source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.list.title"), true);
            for (int i = 0; i < allTraders.size(); ++i) {
                UniversalTraderData thisTrader = allTraders.get(i);
                if (i > 0) {
                    source.m_81354_((Component)new TextComponent(""), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.list.search.none"), true);
        }
        return 1;
    }

    private static void sendTraderDataFeedback(UniversalTraderData thisTrader, CommandSourceStack source) {
        String traderID = thisTrader.getTraderID().toString();
        source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.list.traderid", new Object[]{new TextComponent(traderID).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, traderID)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.list.traderid.copytooltip"))))}), true);
        source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.list.type", new Object[]{thisTrader.getTraderType()}), true);
        source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.list.owner", new Object[]{thisTrader.getOwnerName(), thisTrader.getOwnerID().toString()}), true);
        String dimension = thisTrader.getWorld().m_135782_().toString();
        source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.list.dimension", new Object[]{dimension}), true);
        BlockPos pos = thisTrader.getPos();
        String position = pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_();
        String teleportPosition = pos.m_123341_() + " " + (pos.m_123342_() + 1) + " " + pos.m_123343_();
        source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.list.position", new Object[]{new TextComponent(position).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/execute in " + dimension + " run tp @s " + teleportPosition)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.list.position.teleporttooltip"))))}), true);
        if (thisTrader.hasCustomName()) {
            source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.list.name", new Object[]{thisTrader.getName()}), true);
        }
    }

    static int deleteUniversalData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        String traderID = MessageArgument.m_96835_(commandContext, (String)"dataID").getString();
        if (traderID == "") {
            source.m_81352_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.delete.noid"));
            return 0;
        }
        List<UniversalTraderData> allTraders = TradingOffice.getTraders();
        for (int i = 0; i < allTraders.size(); ++i) {
            if (!allTraders.get(i).getTraderID().toString().equals(traderID)) continue;
            TradingOffice.removeTrader(allTraders.get(i).getTraderID());
            source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.delete.success", new Object[]{traderID}), true);
            return 1;
        }
        source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcadmin.universaldata.delete.notfound"), true);
        return 0;
    }
}

