/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common;

public class ItemTraderStorageUtil {
    public static final int SCREEN_EXTENSION = 99;

    public static int getRowCount(int tradeCount) {
        return (tradeCount - 1) / ItemTraderStorageUtil.getColumnCount(tradeCount) + 1;
    }

    public static int getColumnCount(int tradeCount) {
        return tradeCount > 6 ? 2 : 1;
    }

    public static int getWidth(int tradeCount) {
        return 14 + ItemTraderStorageUtil.getColumnCount(tradeCount) * 162 + 198;
    }

    public static int getStorageSlotOffset(int tradeCount, int row) {
        if (tradeCount % ItemTraderStorageUtil.getColumnCount(tradeCount) == 1 && row == ItemTraderStorageUtil.getRowCount(tradeCount) - 1) {
            return 81;
        }
        return 0;
    }

    public static int getInventoryOffset(int tradeCount) {
        if (ItemTraderStorageUtil.getColumnCount(tradeCount) > 1) {
            return 81;
        }
        return 0;
    }

    public static boolean isFakeTradeButtonInverted(int tradeCount, int slot) {
        return slot >= ItemTraderStorageUtil.getHalfwayPoint(tradeCount);
    }

    public static int getHalfwayPoint(int tradeCount) {
        if (tradeCount % 2 > 0) {
            return tradeCount / 2 + 1;
        }
        return tradeCount / 2;
    }

    public static int getFakeTradeButtonPosX(int tradeCount, int slot) {
        if (slot < ItemTraderStorageUtil.getHalfwayPoint(tradeCount)) {
            return 0;
        }
        return ItemTraderStorageUtil.getWidth(tradeCount) - 99 + 20;
    }

    public static int getFakeTradeButtonPosY(int tradeCount, int slot) {
        return slot % ItemTraderStorageUtil.getHalfwayPoint(tradeCount) * 18;
    }

    public static int getTradePriceButtonPosX(int tradeCount, int slot) {
        if (!ItemTraderStorageUtil.isFakeTradeButtonInverted(tradeCount, slot)) {
            return ItemTraderStorageUtil.getFakeTradeButtonPosX(tradeCount, slot) + 79;
        }
        return ItemTraderStorageUtil.getFakeTradeButtonPosX(tradeCount, slot) - 20;
    }

    public static int getTradePriceButtonPosY(int tradeCount, int slot) {
        return ItemTraderStorageUtil.getFakeTradeButtonPosY(tradeCount, slot) + -1;
    }

    public static int getTradeSlotPosX(int tradeCount, int slot) {
        if (ItemTraderStorageUtil.isFakeTradeButtonInverted(tradeCount, slot)) {
            return ItemTraderStorageUtil.getFakeTradeButtonPosX(tradeCount, slot) + 79 - 62 - 16;
        }
        return ItemTraderStorageUtil.getFakeTradeButtonPosX(tradeCount, slot) + 62;
    }

    public static int getTradeSlotPosY(int tradeCount, int slot) {
        return ItemTraderStorageUtil.getFakeTradeButtonPosY(tradeCount, slot) + 1;
    }
}

