/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.capability;

import io.github.lightman314.lightmanscurrency.common.capability.CurrencyCapabilities;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class WalletCapability {
    public static void register() {
        CapabilityManager.INSTANCE.register(IWalletHandler.class);
    }

    public static LazyOptional<IWalletHandler> getWalletHandler(@Nonnull Entity entity) {
        return entity.getCapability(CurrencyCapabilities.WALLET);
    }

    public static ICapabilityProvider createProvider(Player playerEntity) {
        return new Provider(playerEntity);
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<IWalletHandler> optional;
        final IWalletHandler handler;

        Provider(Player playerEntity) {
            this.handler = new WalletHandler((LivingEntity)playerEntity);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            return CurrencyCapabilities.WALLET.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            return this.handler.writeTag();
        }

        public void deserializeNBT(Tag tag) {
            this.handler.readTag(tag);
        }
    }

    public static class WalletHandler
    implements IWalletHandler {
        final LivingEntity entity;
        ItemStack backupWallet;
        final Container walletInventory;

        public WalletHandler() {
            this(null);
        }

        public WalletHandler(LivingEntity entity) {
            this.entity = entity;
            this.backupWallet = ItemStack.f_41583_;
            this.walletInventory = new SimpleContainer(1);
        }

        @Override
        public Container getInventory() {
            return this.walletInventory;
        }

        @Override
        public ItemStack getWallet() {
            return this.walletInventory.m_8020_(0);
        }

        @Override
        public void setWallet(ItemStack walletStack) {
            this.walletInventory.m_6836_(0, walletStack);
        }

        @Override
        public LivingEntity getEntity() {
            return this.entity;
        }

        @Override
        public boolean isDirty() {
            return !InventoryUtil.ItemMatches(this.backupWallet, this.getWallet()) || this.backupWallet.m_41613_() != this.getWallet().m_41613_();
        }

        @Override
        public void clean() {
            this.backupWallet = this.getWallet().m_41777_();
        }

        @Override
        public Tag writeTag() {
            CompoundTag compound = new CompoundTag();
            CompoundTag walletItem = this.getWallet().m_41739_(new CompoundTag());
            compound.m_128365_("Wallet", (Tag)walletItem);
            return compound;
        }

        @Override
        public void readTag(Tag tag) {
            if (tag instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)tag;
                ItemStack wallet = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Wallet"));
                this.setWallet(wallet);
                this.clean();
            }
        }
    }
}

