/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders.data;

import com.google.common.base.Function;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.interfaces.IPermissions;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public abstract class UniversalTraderData
implements IPermissions,
ITrader {
    public static final ResourceLocation ICON_RESOURCE = new ResourceLocation("lightmanscurrency", "textures/gui/universal_trader_icons.png");
    UUID traderID = null;
    UUID ownerID;
    String ownerName;
    String traderName = "";
    BlockPos pos;
    ResourceKey<Level> world = Level.f_46428_;
    boolean creative = false;
    MoneyUtil.CoinValue storedMoney = new MoneyUtil.CoinValue(new MoneyUtil.CoinValue.CoinValuePair[0]);
    List<String> allies = new ArrayList<String>();
    private boolean isServer = true;

    public UUID getTraderID() {
        return this.traderID;
    }

    @Override
    public UUID getOwnerID() {
        return this.ownerID;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ResourceKey<Level> getWorld() {
        return this.world;
    }

    @Override
    public boolean isCreative() {
        return this.creative;
    }

    public void toggleCreative() {
        this.creative = !this.creative;
        this.markDirty();
        LightmansCurrency.LogInfo("Creative has been toggled on a Universal Trader.");
    }

    @Override
    public MoneyUtil.CoinValue getStoredMoney() {
        return this.storedMoney;
    }

    public final boolean isServer() {
        return this.isServer;
    }

    public final boolean isClient() {
        return !this.isServer;
    }

    public final UniversalTraderData flagAsClient() {
        this.isServer = false;
        return this;
    }

    @Deprecated
    public final void markDirty() {
        if (this.isServer) {
            TradingOffice.MarkDirty(this.traderID);
        }
    }

    public final void markDirty(CompoundTag compound) {
        if (this.isServer) {
            this.writeCoreData(compound);
            TradingOffice.MarkDirty(this.traderID, compound);
        }
    }

    public final void markDirty(Function<CompoundTag, CompoundTag> writer) {
        if (this.isServer) {
            this.markDirty((CompoundTag)writer.apply((Object)new CompoundTag()));
        }
    }

    public void addStoredMoney(MoneyUtil.CoinValue amount) {
        this.storedMoney.addValue(amount);
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeStoredMoney));
    }

    public void removeStoredMoney(MoneyUtil.CoinValue removedAmount) {
        long newValue = this.storedMoney.getRawValue() - removedAmount.getRawValue();
        this.storedMoney.readFromOldValue(newValue);
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeStoredMoney));
    }

    public void clearStoredMoney() {
        this.storedMoney = new MoneyUtil.CoinValue(new MoneyUtil.CoinValue.CoinValuePair[0]);
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeStoredMoney));
    }

    public UniversalTraderData() {
    }

    public UniversalTraderData(UUID ownerID, String ownerName, BlockPos pos, ResourceKey<Level> world, UUID traderID) {
        this.ownerID = ownerID;
        this.ownerName = ownerName;
        this.traderName = "";
        this.pos = pos;
        this.traderID = traderID;
        this.world = world;
    }

    public void read(CompoundTag compound) {
        this.read(compound, true);
    }

    private void read(CompoundTag compound, boolean checkVersion) {
        if (compound.m_128441_("ID")) {
            this.traderID = compound.m_128342_("ID");
        }
        if (compound.m_128441_("OwnerID")) {
            this.ownerID = compound.m_128342_("OwnerID");
        }
        if (compound.m_128425_("OwnerName", 8)) {
            this.ownerName = compound.m_128461_("OwnerName");
        }
        if (compound.m_128425_("TraderName", 8)) {
            this.traderName = compound.m_128461_("TraderName");
        }
        if (compound.m_128441_("x") && compound.m_128441_("y") && compound.m_128441_("z")) {
            this.pos = new BlockPos(compound.m_128451_("x"), compound.m_128451_("y"), compound.m_128451_("z"));
        }
        if (compound.m_128441_("World")) {
            this.world = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compound.m_128461_("World")));
        }
        if (compound.m_128441_("Creative")) {
            this.creative = compound.m_128471_("Creative");
        }
        if (compound.m_128441_("StoredMoney")) {
            this.storedMoney.readFromNBT(compound, "StoredMoney");
        }
        if (compound.m_128425_("Allies", 9)) {
            this.allies.clear();
            ListTag allyList = compound.m_128437_("Allies", 10);
            for (int i = 0; i < allyList.size(); ++i) {
                CompoundTag thisAlly = allyList.m_128728_(i);
                if (!thisAlly.m_128425_("name", 8)) continue;
                this.allies.add(thisAlly.m_128461_("name"));
            }
        }
        if (checkVersion) {
            this.readVersion(compound);
        }
    }

    public CompoundTag write(CompoundTag compound) {
        this.writeCoreData(compound);
        this.writeOwner(compound);
        this.writeStoredMoney(compound);
        this.writeName(compound);
        this.writeCreative(compound);
        this.writeWorldData(compound);
        this.writeAllies(compound);
        this.writeVersion(compound);
        return compound;
    }

    protected final CompoundTag writeCoreData(CompoundTag compound) {
        if (this.traderID != null) {
            compound.m_128362_("ID", this.traderID);
        }
        compound.m_128359_("type", this.getTraderType().toString());
        return compound;
    }

    protected final CompoundTag writeOwner(CompoundTag compound) {
        if (this.ownerID != null) {
            compound.m_128362_("OwnerID", this.ownerID);
        }
        compound.m_128359_("OwnerName", this.ownerName);
        return compound;
    }

    protected final CompoundTag writeName(CompoundTag compound) {
        compound.m_128359_("TraderName", this.traderName);
        return compound;
    }

    protected final CompoundTag writeCreative(CompoundTag compound) {
        compound.m_128379_("Creative", this.creative);
        return compound;
    }

    protected final CompoundTag writeWorldData(CompoundTag compound) {
        if (this.pos != null) {
            compound.m_128405_("x", this.pos.m_123341_());
            compound.m_128405_("y", this.pos.m_123342_());
            compound.m_128405_("z", this.pos.m_123343_());
        }
        if (this.world != null) {
            compound.m_128359_("World", this.world.m_135782_().toString());
        }
        return compound;
    }

    protected final CompoundTag writeStoredMoney(CompoundTag compound) {
        this.storedMoney.writeToNBT(compound, "StoredMoney");
        return compound;
    }

    protected final CompoundTag writeAllies(CompoundTag compound) {
        ListTag allyList = new ListTag();
        this.allies.forEach(ally -> {
            CompoundTag thisAlly = new CompoundTag();
            thisAlly.m_128359_("name", ally);
            allyList.add((Object)thisAlly);
        });
        compound.m_128365_("Allies", (Tag)allyList);
        return compound;
    }

    protected final CompoundTag writeVersion(CompoundTag compound) {
        compound.m_128405_("TraderVersion", this.GetCurrentVersion());
        return compound;
    }

    protected final void readVersion(CompoundTag compound) {
        int oldVersion;
        if (compound.m_128425_("TraderVersion", 3) && (oldVersion = compound.m_128451_("TraderVersion")) < this.GetCurrentVersion()) {
            this.onVersionUpdate(oldVersion);
        }
    }

    @Override
    public boolean isOwner(Player player) {
        if (this.ownerID != null) {
            return player.m_142081_().equals(this.ownerID) || TradingOffice.isAdminPlayer(player);
        }
        LightmansCurrency.LogError("Owner ID for the universal trading machine is null. Unable to determine if the owner is valid.");
        return true;
    }

    @Override
    public boolean hasPermissions(Player player) {
        return this.isOwner(player) || this.allies.contains(player.m_7755_().getString());
    }

    @Override
    public List<String> getAllies() {
        return this.allies;
    }

    @Override
    public void markAlliesDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeAllies));
    }

    public void updateOwnerName(String ownerName) {
        if (this.ownerName.equals(ownerName)) {
            return;
        }
        this.ownerName = ownerName;
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeOwner));
    }

    protected abstract void onVersionUpdate(int var1);

    public int GetCurrentVersion() {
        return 0;
    }

    public abstract ResourceLocation getTraderType();

    protected abstract MenuProvider getTradeMenuProvider();

    public void openTradeMenu(Player playerEntity) {
        MenuProvider provider = this.getTradeMenuProvider();
        if (provider == null) {
            LightmansCurrency.LogError("No trade container provider was given for the universal trader of type " + this.getTraderType().toString());
            return;
        }
        if (playerEntity instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerEntity), (MenuProvider)provider, (Consumer)new DataWriter(this.getTraderID()));
        } else {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the trade menu.");
        }
    }

    protected abstract MenuProvider getStorageMenuProvider();

    public void openStorageMenu(Player playerEntity) {
        MenuProvider provider = this.getStorageMenuProvider();
        if (provider == null) {
            LightmansCurrency.LogError("No storage container provider was given for the universal trader of type " + this.getTraderType().toString());
            return;
        }
        if (playerEntity instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerEntity), (MenuProvider)provider, (Consumer)new DataWriter(this.getTraderID()));
        } else {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the trade menu.");
        }
    }

    protected Component getDefaultName() {
        return new TranslatableComponent("gui.lightmanscurrency.universaltrader.default");
    }

    public void setName(String newName) {
        this.traderName = newName;
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeName));
    }

    @Override
    public boolean hasCustomName() {
        return this.traderName != "";
    }

    @Override
    public Component getName() {
        if (this.traderName != "") {
            return new TextComponent(this.traderName);
        }
        return this.getDefaultName();
    }

    public Component getTitle() {
        if (this.creative) {
            return this.getName();
        }
        return new TranslatableComponent("gui.lightmanscurrency.trading.title", new Object[]{this.getName(), this.ownerName});
    }

    public static boolean equals(UniversalTraderData data1, UniversalTraderData data2) {
        return data1.write(new CompoundTag()).equals((Object)data2.write(new CompoundTag()));
    }

    public abstract ResourceLocation IconLocation();

    public abstract int IconPositionX();

    public abstract int IconPositionY();

    protected class DataWriter
    implements Consumer<FriendlyByteBuf> {
        final UUID traderID;

        public DataWriter(UUID traderID) {
            this.traderID = traderID;
        }

        @Override
        public void accept(FriendlyByteBuf buffer) {
            buffer.m_130077_(this.traderID);
        }
    }

    protected class TradeIndexDataWriter
    implements Consumer<FriendlyByteBuf> {
        final UUID traderID;
        final int tradeIndex;

        public TradeIndexDataWriter(UUID traderID, int tradeIndex) {
            this.traderID = traderID;
            this.tradeIndex = tradeIndex;
        }

        @Override
        public void accept(FriendlyByteBuf buffer) {
            buffer.m_130077_(this.traderID);
            buffer.writeInt(this.tradeIndex);
        }
    }
}

