/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.core;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class LootManager {
    public static final float LOOTING_MODIFIER = 0.01f;
    private static List<String> NON_LOOT_TABLE_ENTITIES = null;
    private static final String ENTITY = "minecraft:entities/";
    private static final String CHEST = "minecraft:chests/";
    public static final List<String> ENTITY_COPPER_DROPLIST = ImmutableList.of((Object)"minecraft:entities/slime", (Object)"minecraft:entities/silverfish");
    public static final List<String> ENTITY_IRON_DROPLIST = ImmutableList.of((Object)"minecraft:entities/zombie", (Object)"minecraft:entities/skeleton", (Object)"minecraft:entities/creeper", (Object)"minecraft:entities/spider", (Object)"minecraft:entities/cave_spider", (Object)"minecraft:entities/husk", (Object)"minecraft:entities/stray", (Object)"minecraft:entities/magma_cube", (Object)"minecraft:entities/zombie_villager", (Object)"minecraft:entities/drowned");
    public static final List<String> ENTITY_GOLD_DROPLIST = ImmutableList.of((Object)"minecraft:entities/guardian", (Object)"minecraft:entities/elder_guardian", (Object)"minecraft:entities/phantom", (Object)"minecraft:entities/blaze", (Object)"minecraft:entities/ghast", (Object)"minecraft:entities/witch", (Object)"minecraft:entities/hoglin", (Object)"minecraft:entities/piglin_brute", (Object)"minecraft:entities/piglin", (Object)"minecraft:entities/zombified_piglin");
    public static final List<String> ENTITY_EMERALD_DROPLIST = ImmutableList.of((Object)"minecraft:entities/enderman", (Object)"minecraft:entities/evoker", (Object)"minecraft:entities/vindicator", (Object)"minecraft:entities/pillager", (Object)"minecraft:entities/ravager", (Object)"minecraft:entities/shulker");
    public static final List<String> ENTITY_DIAMOND_DROPLIST = ImmutableList.of((Object)"minecraft:entities/wither_skeleton");
    public static final List<String> ENTITY_NETHERITE_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_COPPER_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_IRON_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_GOLD_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_EMERALD_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_DIAMOND_DROPLIST = ImmutableList.of((Object)"minecraft:entities/ender_dragon");
    public static final List<String> ENTITY_BOSS_NETHERITE_DROPLIST = ImmutableList.of((Object)"minecraft:entities/wither");
    public static final List<String> CHEST_COPPER_DROPLIST = ImmutableList.of((Object)"minecraft:chests/underwater_ruin_small", (Object)"minecraft:chests/underwater_ruin_big");
    public static final List<String> CHEST_IRON_DROPLIST = ImmutableList.of();
    public static final List<String> CHEST_GOLD_DROPLIST = ImmutableList.of((Object)"minecraft:chests/jungle_temple", (Object)"minecraft:chests/nether_bridge", (Object)"minecraft:chests/simple_dungeon", (Object)"minecraft:chests/ruined_portal");
    public static final List<String> CHEST_EMERALD_DROPLIST = ImmutableList.of((Object)"minecraft:chests/stronghold_crossing", (Object)"minecraft:chests/stronghold_corridor", (Object)"minecraft:chests/stronghold_library");
    public static final List<String> CHEST_DIAMOND_DROPLIST = ImmutableList.of((Object)"minecraft:chests/buried_treasure", (Object)"minecraft:chests/bastion_hoglin_stable", (Object)"minecraft:chests/bastion_bridge", (Object)"minecraft:chests/bastion_other", (Object)"minecraft:chests/bastion_treasure", (Object)"minecraft:chests/end_city_treasure");
    public static final List<String> CHEST_NETHERITE_DROPLIST = ImmutableList.of();
    private static final List<Pair<String, PoolLevel>> EXTERNAL_ENTITY_ENTRIES = new ArrayList<Pair<String, PoolLevel>>();
    private static final List<Pair<String, PoolLevel>> EXTERNAL_CHEST_ENTRIES = new ArrayList<Pair<String, PoolLevel>>();
    private static final LootPool.Builder ENTITY_LOOT_COPPER = LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 1.0f, 10.0f, 0.75f, "lightmanscurrency:entityloot_copper", true);
    private static final LootPool.Builder ENTITY_LOOT_IRON = LootManager.GenerateEntityCoinPool(ModItems.COIN_IRON, 1.0f, 5.0f, 0.5f, "lightmanscurrency:entityloot_iron", true);
    private static final LootPool.Builder ENTITY_LOOT_GOLD = LootManager.GenerateEntityCoinPool(ModItems.COIN_GOLD, 1.0f, 5.0f, 0.25f, "lightmanscurrency:entityloot_gold", true);
    private static final LootPool.Builder ENTITY_LOOT_EMERALD = LootManager.GenerateEntityCoinPool(ModItems.COIN_EMERALD, 1.0f, 3.0f, 0.1f, "lightmanscurrency:entityloot_emerald", true);
    private static final LootPool.Builder ENTITY_LOOT_DIAMOND = LootManager.GenerateEntityCoinPool(ModItems.COIN_DIAMOND, 1.0f, 3.0f, 0.05f, "lightmanscurrency:entityloot_diamond", true);
    private static final LootPool.Builder ENTITY_LOOT_NETHERITE = LootManager.GenerateEntityCoinPool(ModItems.COIN_NETHERITE, 1.0f, 3.0f, 0.025f, "lightmanscurrency:entityloot_netherite", true);
    private static final List<LootPool.Builder> ENTITY_LOOT_BOSS_COPPER = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false));
    private static final List<LootPool.Builder> ENTITY_LOOT_BOSS_IRON = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_IRON, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false));
    private static final List<LootPool.Builder> ENTITY_LOOT_BOSS_GOLD = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_IRON, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_GOLD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false));
    private static final List<LootPool.Builder> ENTITY_LOOT_BOSS_EMERALD = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_IRON, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_GOLD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_EMERALD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_emerald", false));
    private static final List<LootPool.Builder> ENTITY_LOOT_BOSS_DIAMOND = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_IRON, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_GOLD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_EMERALD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_emerald", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_DIAMOND, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_diamond", false));
    private static final List<LootPool.Builder> ENTITY_LOOT_BOSS_NETHERITE = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_IRON, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_GOLD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_EMERALD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_emerald", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_DIAMOND, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_diamond", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_NETHERITE, 1.0f, 5.0f, 1.0f, "lightmanscurrency:coinloot_boss_netherite", false));
    private static final LootPool.Builder CHEST_LOOT_COPPER = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER}, 1.0f, 5.0f, "lightmanscurrency:chestloot_copper");
    private static final LootPool.Builder CHEST_LOOT_IRON = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON}, 1.0f, 5.0f, "lightmanscurrency:chestloot_iron");
    private static final LootPool.Builder CHEST_LOOT_GOLD = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD}, 2.0f, 6.0f, "lightmanscurrency:chestloot_gold");
    private static final LootPool.Builder CHEST_LOOT_EMERALD = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD}, 3.0f, 6.0f, "lightmanscurrency:chestloot_emerald");
    private static final LootPool.Builder CHEST_LOOT_DIAMOND = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD, ChestLootEntryData.DIAMOND}, 3.0f, 6.0f, "lightmanscurrency:chestloot_diamond");
    private static final LootPool.Builder CHEST_LOOT_NETHERITE = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD, ChestLootEntryData.DIAMOND, ChestLootEntryData.NETHERITE}, 3.0f, 6.0f, "lightmanscurrency:chestloot_netherite");

    @SubscribeEvent
    public static void onLootTablesLoaded(LootTableLoadEvent event) {
        if (NON_LOOT_TABLE_ENTITIES == null) {
            LootManager.initNonLootTableEntities();
        }
        String name = event.getName().toString();
        LootManager.nonLootTableEntityRemovalCheck(name);
        LootTable table = event.getTable();
        if (((List)Config.COMMON.copperEntityDrops.get()).contains(name)) {
            LootManager.AddEntityPoolToTable(table, PoolLevel.COPPER, name);
        } else if (((List)Config.COMMON.ironEntityDrops.get()).contains(name)) {
            LootManager.AddEntityPoolToTable(table, PoolLevel.IRON, name);
        } else if (((List)Config.COMMON.goldEntityDrops.get()).contains(name)) {
            LootManager.AddEntityPoolToTable(table, PoolLevel.GOLD, name);
        } else if (((List)Config.COMMON.emeraldEntityDrops.get()).contains(name)) {
            LootManager.AddEntityPoolToTable(table, PoolLevel.EMERALD, name);
        } else if (((List)Config.COMMON.diamondEntityDrops.get()).contains(name)) {
            LootManager.AddEntityPoolToTable(table, PoolLevel.DIAMOND, name);
        } else if (((List)Config.COMMON.netheriteEntityDrops.get()).contains(name)) {
            LootManager.AddEntityPoolToTable(table, PoolLevel.NETHERITE, name);
        } else if (((List)Config.COMMON.bossCopperEntityDrops.get()).contains(name)) {
            LootManager.AddEntityPoolToTable(table, PoolLevel.BOSS_COPPER, name);
        } else if (((List)Config.COMMON.bossIronEntityDrops.get()).contains(name)) {
            LootManager.AddEntityPoolToTable(table, PoolLevel.BOSS_IRON, name);
        } else if (((List)Config.COMMON.bossGoldEntityDrops.get()).contains(name)) {
            LootManager.AddEntityPoolToTable(table, PoolLevel.BOSS_GOLD, name);
        } else if (((List)Config.COMMON.bossEmeraldEntityDrops.get()).contains(name)) {
            LootManager.AddEntityPoolToTable(table, PoolLevel.BOSS_EMERALD, name);
        } else if (((List)Config.COMMON.bossDiamondEntityDrops.get()).contains(name)) {
            LootManager.AddEntityPoolToTable(table, PoolLevel.BOSS_DIAMOND, name);
        } else if (((List)Config.COMMON.bossNetheriteEntityDrops.get()).contains(name)) {
            LootManager.AddEntityPoolToTable(table, PoolLevel.BOSS_NETHERITE, name);
        } else if (((List)Config.COMMON.copperChestDrops.get()).contains(name)) {
            LootManager.AddChestPoolToTable(table, PoolLevel.COPPER, name);
        } else if (((List)Config.COMMON.ironChestDrops.get()).contains(name)) {
            LootManager.AddChestPoolToTable(table, PoolLevel.IRON, name);
        } else if (((List)Config.COMMON.goldChestDrops.get()).contains(name)) {
            LootManager.AddChestPoolToTable(table, PoolLevel.GOLD, name);
        } else if (((List)Config.COMMON.emeraldChestDrops.get()).contains(name)) {
            LootManager.AddChestPoolToTable(table, PoolLevel.EMERALD, name);
        } else if (((List)Config.COMMON.diamondChestDrops.get()).contains(name)) {
            LootManager.AddChestPoolToTable(table, PoolLevel.DIAMOND, name);
        } else if (((List)Config.COMMON.netheriteChestDrops.get()).contains(name)) {
            LootManager.AddChestPoolToTable(table, PoolLevel.NETHERITE, name);
        } else {
            for (Pair<String, PoolLevel> pair : EXTERNAL_ENTITY_ENTRIES) {
                if (pair.getFirst() != name) continue;
                LootManager.AddEntityPoolToTable(table, (PoolLevel)((Object)pair.getSecond()), name);
            }
            for (Pair<String, PoolLevel> pair : EXTERNAL_CHEST_ENTRIES) {
                if (pair.getFirst() != name) continue;
                LootManager.AddChestPoolToTable(table, (PoolLevel)((Object)pair.getSecond()), name);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntityLiving().f_19853_.f_46443_) {
            return;
        }
        String name = event.getEntityLiving().m_6095_().getRegistryName().toString();
        if (NON_LOOT_TABLE_ENTITIES.contains(name)) {
            Player player = null;
            if (event.getSource().m_7640_() instanceof Player || event.getSource().m_7639_() instanceof Player) {
                player = event.getSource().m_7640_() instanceof Player ? (Player)event.getSource().m_7640_() : (Player)event.getSource().m_7639_();
                if (((List)Config.COMMON.copperEntityDrops.get()).contains(name)) {
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.COPPER);
                } else if (((List)Config.COMMON.ironEntityDrops.get()).contains(name)) {
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.IRON);
                } else if (((List)Config.COMMON.goldEntityDrops.get()).contains(name)) {
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.GOLD);
                } else if (((List)Config.COMMON.emeraldEntityDrops.get()).contains(name)) {
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.EMERALD);
                } else if (((List)Config.COMMON.diamondEntityDrops.get()).contains(name)) {
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.DIAMOND);
                } else if (((List)Config.COMMON.netheriteEntityDrops.get()).contains(name)) {
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.NETHERITE);
                } else if (((List)Config.COMMON.bossCopperEntityDrops.get()).contains(name)) {
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_COPPER);
                } else if (((List)Config.COMMON.bossIronEntityDrops.get()).contains(name)) {
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_IRON);
                } else if (((List)Config.COMMON.bossGoldEntityDrops.get()).contains(name)) {
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_GOLD);
                } else if (((List)Config.COMMON.bossEmeraldEntityDrops.get()).contains(name)) {
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_EMERALD);
                } else if (((List)Config.COMMON.bossDiamondEntityDrops.get()).contains(name)) {
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_DIAMOND);
                } else if (((List)Config.COMMON.bossNetheriteEntityDrops.get()).contains(name)) {
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_NETHERITE);
                } else {
                    for (Pair<String, PoolLevel> pair : EXTERNAL_ENTITY_ENTRIES) {
                        if (pair.getFirst() != name || pair.getSecond() == PoolLevel.BOSS_COPPER || pair.getSecond() == PoolLevel.BOSS_IRON || pair.getSecond() == PoolLevel.BOSS_GOLD || pair.getSecond() == PoolLevel.BOSS_EMERALD || pair.getSecond() == PoolLevel.BOSS_DIAMOND || pair.getSecond() == PoolLevel.BOSS_NETHERITE) continue;
                        LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, (PoolLevel)((Object)pair.getSecond()));
                    }
                }
            }
            if (((List)Config.COMMON.bossCopperEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_COPPER);
            } else if (((List)Config.COMMON.bossIronEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_IRON);
            } else if (((List)Config.COMMON.bossGoldEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_GOLD);
            } else if (((List)Config.COMMON.bossEmeraldEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_EMERALD);
            } else if (((List)Config.COMMON.bossDiamondEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_DIAMOND);
            } else if (((List)Config.COMMON.bossNetheriteEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_NETHERITE);
            } else {
                for (Pair<String, PoolLevel> pair : EXTERNAL_ENTITY_ENTRIES) {
                    if (pair.getFirst() != name || pair.getSecond() != PoolLevel.BOSS_COPPER && pair.getSecond() != PoolLevel.BOSS_IRON && pair.getSecond() != PoolLevel.BOSS_GOLD && pair.getSecond() != PoolLevel.BOSS_EMERALD && pair.getSecond() != PoolLevel.BOSS_DIAMOND && pair.getSecond() != PoolLevel.BOSS_NETHERITE) continue;
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, (PoolLevel)((Object)pair.getSecond()));
                }
            }
        }
    }

    private static void initNonLootTableEntities() {
        NON_LOOT_TABLE_ENTITIES = new ArrayList<String>();
        for (String entity : (List)Config.COMMON.copperEntityDrops.get()) {
            NON_LOOT_TABLE_ENTITIES.add(entity);
        }
        for (String entity : (List)Config.COMMON.ironEntityDrops.get()) {
            NON_LOOT_TABLE_ENTITIES.add(entity);
        }
        for (String entity : (List)Config.COMMON.goldEntityDrops.get()) {
            NON_LOOT_TABLE_ENTITIES.add(entity);
        }
        for (String entity : (List)Config.COMMON.emeraldEntityDrops.get()) {
            NON_LOOT_TABLE_ENTITIES.add(entity);
        }
        for (String entity : (List)Config.COMMON.diamondEntityDrops.get()) {
            NON_LOOT_TABLE_ENTITIES.add(entity);
        }
        for (String entity : (List)Config.COMMON.netheriteEntityDrops.get()) {
            NON_LOOT_TABLE_ENTITIES.add(entity);
        }
        for (String entity : (List)Config.COMMON.bossCopperEntityDrops.get()) {
            NON_LOOT_TABLE_ENTITIES.add(entity);
        }
        for (String entity : (List)Config.COMMON.bossIronEntityDrops.get()) {
            NON_LOOT_TABLE_ENTITIES.add(entity);
        }
        for (String entity : (List)Config.COMMON.bossGoldEntityDrops.get()) {
            NON_LOOT_TABLE_ENTITIES.add(entity);
        }
        for (String entity : (List)Config.COMMON.bossEmeraldEntityDrops.get()) {
            NON_LOOT_TABLE_ENTITIES.add(entity);
        }
        for (String entity : (List)Config.COMMON.bossDiamondEntityDrops.get()) {
            NON_LOOT_TABLE_ENTITIES.add(entity);
        }
        for (String entity : (List)Config.COMMON.bossNetheriteEntityDrops.get()) {
            NON_LOOT_TABLE_ENTITIES.add(entity);
        }
    }

    private static void nonLootTableEntityRemovalCheck(String entity) {
        if (NON_LOOT_TABLE_ENTITIES.contains(entity)) {
            NON_LOOT_TABLE_ENTITIES.remove(entity);
        }
    }

    private static void DropEntityLoot(Entity entity, Player player, PoolLevel coinPool) {
        if (!((Boolean)Config.COMMON.enableEntityDrops.get()).booleanValue()) {
            return;
        }
        LootTable table = LootTable.m_79147_().m_79167_();
        LootContext.Builder contextBuilder = new LootContext.Builder((ServerLevel)entity.f_19853_);
        if (player != null) {
            contextBuilder.m_78972_(LootContextParams.f_81458_, (Object)player).m_78972_(LootContextParams.f_81456_, (Object)player);
        }
        LootContext context = contextBuilder.m_78975_(new LootContextParamSet.Builder().m_81408_(LootContextParams.f_81456_).m_81408_(LootContextParams.f_81458_).m_81405_());
        if (coinPool == PoolLevel.BOSS_COPPER) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_COPPER) {
                table.addPool(builder.m_79082_());
            }
            LootManager.SpawnLootDrops(entity, table.m_79129_(context));
            return;
        }
        if (coinPool == PoolLevel.BOSS_IRON) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_IRON) {
                table.addPool(builder.m_79082_());
            }
            LootManager.SpawnLootDrops(entity, table.m_79129_(context));
            return;
        }
        if (coinPool == PoolLevel.BOSS_GOLD) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_GOLD) {
                table.addPool(builder.m_79082_());
            }
            LootManager.SpawnLootDrops(entity, table.m_79129_(context));
            return;
        }
        if (coinPool == PoolLevel.BOSS_EMERALD) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_EMERALD) {
                table.addPool(builder.m_79082_());
            }
            LootManager.SpawnLootDrops(entity, table.m_79129_(context));
            return;
        }
        if (coinPool == PoolLevel.BOSS_DIAMOND) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_DIAMOND) {
                table.addPool(builder.m_79082_());
            }
            LootManager.SpawnLootDrops(entity, table.m_79129_(context));
            return;
        }
        if (coinPool == PoolLevel.BOSS_NETHERITE) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_NETHERITE) {
                table.addPool(builder.m_79082_());
            }
            LootManager.SpawnLootDrops(entity, table.m_79129_(context));
            return;
        }
        table.addPool(ENTITY_LOOT_COPPER.m_79082_());
        if (coinPool != PoolLevel.COPPER) {
            table.addPool(ENTITY_LOOT_IRON.m_79082_());
            if (coinPool != PoolLevel.IRON) {
                table.addPool(ENTITY_LOOT_GOLD.m_79082_());
                if (coinPool != PoolLevel.GOLD) {
                    table.addPool(ENTITY_LOOT_EMERALD.m_79082_());
                    if (coinPool != PoolLevel.EMERALD) {
                        table.addPool(ENTITY_LOOT_DIAMOND.m_79082_());
                        if (coinPool != PoolLevel.DIAMOND) {
                            table.addPool(ENTITY_LOOT_NETHERITE.m_79082_());
                        }
                    }
                }
            }
        }
        LootManager.SpawnLootDrops(entity, table.m_79129_(context));
    }

    private static void SpawnLootDrops(Entity entity, List<ItemStack> lootDrops) {
        InventoryUtil.dumpContents(entity.f_19853_, entity.m_142538_(), lootDrops);
    }

    private static void AddEntityPoolToTable(LootTable table, PoolLevel coinPool, String name) {
        if (!((Boolean)Config.COMMON.enableEntityDrops.get()).booleanValue()) {
            return;
        }
        if (coinPool == PoolLevel.BOSS_COPPER) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_COPPER) {
                table.addPool(builder.m_79082_());
            }
            return;
        }
        if (coinPool == PoolLevel.BOSS_IRON) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_IRON) {
                table.addPool(builder.m_79082_());
            }
            return;
        }
        if (coinPool == PoolLevel.BOSS_GOLD) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_GOLD) {
                table.addPool(builder.m_79082_());
            }
            return;
        }
        if (coinPool == PoolLevel.BOSS_EMERALD) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_EMERALD) {
                table.addPool(builder.m_79082_());
            }
            return;
        }
        if (coinPool == PoolLevel.BOSS_DIAMOND) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_DIAMOND) {
                table.addPool(builder.m_79082_());
            }
            return;
        }
        if (coinPool == PoolLevel.BOSS_NETHERITE) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_NETHERITE) {
                table.addPool(builder.m_79082_());
            }
            return;
        }
        LightmansCurrency.LogDebug("Added " + coinPool + " level entity loot to the " + name + " loot entry.");
        table.addPool(ENTITY_LOOT_COPPER.m_79082_());
        if (coinPool == PoolLevel.COPPER) {
            return;
        }
        table.addPool(ENTITY_LOOT_IRON.m_79082_());
        if (coinPool == PoolLevel.IRON) {
            return;
        }
        table.addPool(ENTITY_LOOT_GOLD.m_79082_());
        if (coinPool == PoolLevel.GOLD) {
            return;
        }
        table.addPool(ENTITY_LOOT_EMERALD.m_79082_());
        if (coinPool == PoolLevel.EMERALD) {
            return;
        }
        table.addPool(ENTITY_LOOT_DIAMOND.m_79082_());
        if (coinPool == PoolLevel.DIAMOND) {
            return;
        }
        table.addPool(ENTITY_LOOT_NETHERITE.m_79082_());
    }

    private static void AddChestPoolToTable(LootTable table, PoolLevel coinPool, String name) {
        if (!((Boolean)Config.COMMON.enableChestLoot.get()).booleanValue()) {
            return;
        }
        LightmansCurrency.LogDebug("Added " + coinPool + " level chest loot to the " + name + " loot entry.");
        if (coinPool == PoolLevel.COPPER) {
            table.addPool(CHEST_LOOT_COPPER.m_79082_());
        } else if (coinPool == PoolLevel.IRON) {
            table.addPool(CHEST_LOOT_IRON.m_79082_());
        } else if (coinPool == PoolLevel.GOLD) {
            table.addPool(CHEST_LOOT_GOLD.m_79082_());
        } else if (coinPool == PoolLevel.EMERALD) {
            table.addPool(CHEST_LOOT_EMERALD.m_79082_());
        } else if (coinPool == PoolLevel.DIAMOND) {
            table.addPool(CHEST_LOOT_DIAMOND.m_79082_());
        } else if (coinPool == PoolLevel.NETHERITE) {
            table.addPool(CHEST_LOOT_NETHERITE.m_79082_());
        }
    }

    public static void AddEntityCoinPoolToTable(String resource, PoolLevel coinPool) {
        EXTERNAL_ENTITY_ENTRIES.add((Pair<String, PoolLevel>)new Pair((Object)resource, (Object)coinPool));
    }

    public static void AddChestCoinPoolToTable(String resource, PoolLevel coinPool) {
        EXTERNAL_CHEST_ENTRIES.add((Pair<String, PoolLevel>)new Pair((Object)resource, (Object)coinPool));
    }

    private static LootPool.Builder GenerateEntityCoinPool(Item item, float min, float max, float chance, String name, boolean requirePlayerKill) {
        LootPool.Builder lootPoolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).name(name);
        if (requirePlayerKill) {
            lootPoolBuilder.m_6509_(LootItemKilledByPlayerCondition.m_81901_());
        }
        if (chance < 1.0f) {
            lootPoolBuilder.m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)chance, (float)0.01f));
        }
        return lootPoolBuilder;
    }

    private static LootPool.Builder GenerateChestCoinPool(ChestLootEntryData[] lootEntries, float minRolls, float maxRolls, String name) {
        LootPool.Builder lootPoolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)minRolls, (float)maxRolls)).name(name);
        for (ChestLootEntryData entry : lootEntries) {
            lootPoolBuilder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)entry.item).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)entry.minCount, (float)entry.maxCount))).m_79707_(entry.weight));
        }
        return lootPoolBuilder;
    }

    public static enum PoolLevel {
        COPPER,
        IRON,
        GOLD,
        EMERALD,
        DIAMOND,
        NETHERITE,
        BOSS_COPPER,
        BOSS_IRON,
        BOSS_GOLD,
        BOSS_EMERALD,
        BOSS_DIAMOND,
        BOSS_NETHERITE;

    }

    private static class ChestLootEntryData {
        public final Item item;
        public final float minCount;
        public final float maxCount;
        public final int weight;
        public static ChestLootEntryData COPPER = new ChestLootEntryData(ModItems.COIN_COPPER, 1.0f, 10.0f, 1);
        public static ChestLootEntryData IRON = new ChestLootEntryData(ModItems.COIN_IRON, 1.0f, 10.0f, 2);
        public static ChestLootEntryData GOLD = new ChestLootEntryData(ModItems.COIN_GOLD, 1.0f, 10.0f, 3);
        public static ChestLootEntryData EMERALD = new ChestLootEntryData(ModItems.COIN_EMERALD, 1.0f, 10.0f, 4);
        public static ChestLootEntryData DIAMOND = new ChestLootEntryData(ModItems.COIN_DIAMOND, 1.0f, 8.0f, 5);
        public static ChestLootEntryData NETHERITE = new ChestLootEntryData(ModItems.COIN_NETHERITE, 1.0f, 3.0f, 6);

        public ChestLootEntryData(Item item, float minCount, float maxCount, int weight) {
            this.item = item;
            this.minCount = minCount;
            this.maxCount = maxCount;
            this.weight = weight;
        }
    }
}

