/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.core;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.BlockItemPair;
import io.github.lightman314.lightmanscurrency.BlockItemSet;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.Reference;
import io.github.lightman314.lightmanscurrency.blocks.ATMBlock;
import io.github.lightman314.lightmanscurrency.blocks.CashRegisterBlock;
import io.github.lightman314.lightmanscurrency.blocks.CoinBlock;
import io.github.lightman314.lightmanscurrency.blocks.CoinJarBlock;
import io.github.lightman314.lightmanscurrency.blocks.CoinMintBlock;
import io.github.lightman314.lightmanscurrency.blocks.CoinpileBlock;
import io.github.lightman314.lightmanscurrency.blocks.ItemTraderServerBlock;
import io.github.lightman314.lightmanscurrency.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.blocks.TerminalBlock;
import io.github.lightman314.lightmanscurrency.blocks.TicketMachineBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.ArmorDisplayBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.CardDisplayBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.DisplayCaseBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.FreezerBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.ShelfBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.TicketKioskBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.VendingMachineBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.VendingMachineLargeBlock;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.CashRegisterItem;
import io.github.lightman314.lightmanscurrency.items.CoinBlockItem;
import io.github.lightman314.lightmanscurrency.items.CoinJarItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="lightmanscurrency", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks {
    private static final List<Block> BLOCKS = new ArrayList<Block>();
    private static final List<Item> ITEMS = new ArrayList<Item>();
    public static final BlockItemPair COINPILE_COPPER = ModBlocks.register("coinpile_copper", LightmansCurrency.COIN_GROUP, BlockItemType.COIN, (Block)new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_COPPER));
    public static final BlockItemPair COINPILE_IRON = ModBlocks.register("coinpile_iron", LightmansCurrency.COIN_GROUP, BlockItemType.COIN, (Block)new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_IRON));
    public static final BlockItemPair COINPILE_GOLD = ModBlocks.register("coinpile_gold", LightmansCurrency.COIN_GROUP, BlockItemType.COIN, (Block)new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_GOLD));
    public static final BlockItemPair COINPILE_DIAMOND = ModBlocks.register("coinpile_diamond", LightmansCurrency.COIN_GROUP, BlockItemType.COIN, (Block)new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_DIAMOND));
    public static final BlockItemPair COINPILE_EMERALD = ModBlocks.register("coinpile_emerald", LightmansCurrency.COIN_GROUP, BlockItemType.COIN, (Block)new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_EMERALD));
    public static final BlockItemPair COINPILE_NETHERITE = ModBlocks.register("coinpile_netherite", LightmansCurrency.COIN_GROUP, BlockItemType.NETHERITE_COIN, (Block)new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_NETHERITE));
    public static final BlockItemPair COINBLOCK_COPPER = ModBlocks.register("coinblock_copper", LightmansCurrency.COIN_GROUP, BlockItemType.COIN, (Block)new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_COPPER));
    public static final BlockItemPair COINBLOCK_IRON = ModBlocks.register("coinblock_iron", LightmansCurrency.COIN_GROUP, BlockItemType.COIN, (Block)new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_IRON));
    public static final BlockItemPair COINBLOCK_GOLD = ModBlocks.register("coinblock_gold", LightmansCurrency.COIN_GROUP, BlockItemType.COIN, (Block)new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_GOLD));
    public static final BlockItemPair COINBLOCK_EMERALD = ModBlocks.register("coinblock_emerald", LightmansCurrency.COIN_GROUP, BlockItemType.COIN, (Block)new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_EMERALD));
    public static final BlockItemPair COINBLOCK_DIAMOND = ModBlocks.register("coinblock_diamond", LightmansCurrency.COIN_GROUP, BlockItemType.COIN, (Block)new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_DIAMOND));
    public static final BlockItemPair COINBLOCK_NETHERITE = ModBlocks.register("coinblock_netherite", LightmansCurrency.COIN_GROUP, BlockItemType.NETHERITE_COIN, (Block)new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_NETHERITE));
    public static final BlockItemPair MACHINE_ATM = ModBlocks.register("atm", LightmansCurrency.MACHINE_GROUP, new ATMBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
    public static final BlockItemPair MACHINE_MINT = ModBlocks.register("coinmint", LightmansCurrency.MACHINE_GROUP, new CoinMintBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
    public static final BlockItemPair DISPLAY_CASE = ModBlocks.register("display_case", LightmansCurrency.TRADING_GROUP, BlockItemType.DEFAULT, new DisplayCaseBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56744_)));
    public static final BlockItemSet<Reference.Colors> VENDING_MACHINE1 = ModBlocks.registerColored("vending_machine", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new VendingMachineBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))), false);
    public static final BlockItemSet<Reference.Colors> VENDING_MACHINE2 = ModBlocks.registerColored("vending_machine_large", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new VendingMachineLargeBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))), false);
    public static final BlockItemSet<Reference.WoodType> SHELF = ModBlocks.registerWooden("shelf", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, Float.POSITIVE_INFINITY))));
    public static final BlockItemSet<Reference.WoodType> CARD_DISPLAY = ModBlocks.registerWooden("card_display", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new CardDisplayBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56736_))));
    public static final BlockItemPair ARMOR_DISPLAY = ModBlocks.register("armor_display", LightmansCurrency.TRADING_GROUP, new ArmorDisplayBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final BlockItemPair FREEZER = ModBlocks.register("freezer", LightmansCurrency.TRADING_GROUP, new FreezerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final BlockItemPair ITEM_TRADER_SERVER_SMALL = ModBlocks.register("item_trader_server_sml", LightmansCurrency.TRADING_GROUP, new ItemTraderServerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 3));
    public static final BlockItemPair ITEM_TRADER_SERVER_MEDIUM = ModBlocks.register("item_trader_server_med", LightmansCurrency.TRADING_GROUP, new ItemTraderServerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 6));
    public static final BlockItemPair ITEM_TRADER_SERVER_LARGE = ModBlocks.register("item_trader_server_lrg", LightmansCurrency.TRADING_GROUP, new ItemTraderServerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 12));
    public static final BlockItemPair ITEM_TRADER_SERVER_EXTRA_LARGE = ModBlocks.register("item_trader_server_xlrg", LightmansCurrency.TRADING_GROUP, new ItemTraderServerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 16));
    public static final BlockItemPair CASH_REGISTER = ModBlocks.register("cash_register", LightmansCurrency.MACHINE_GROUP, BlockItemType.CASH_REGISTER, new CashRegisterBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0)));
    public static final BlockItemPair TERMINAL = ModBlocks.register("terminal", LightmansCurrency.MACHINE_GROUP, new TerminalBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0)));
    public static final BlockItemPair PAYGATE = ModBlocks.register("paygate", LightmansCurrency.MACHINE_GROUP, new PaygateBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final BlockItemPair TICKET_KIOSK = ModBlocks.register("ticket_kiosk", LightmansCurrency.TRADING_GROUP, new TicketKioskBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
    public static final BlockItemPair TICKET_MACHINE = ModBlocks.register("ticket_machine", LightmansCurrency.MACHINE_GROUP, new TicketMachineBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
    public static final BlockItemPair PIGGY_BANK = ModBlocks.register("piggy_bank", CreativeModeTab.f_40750_, BlockItemType.COIN_JAR, new CoinJarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(0.1f, 2.0f).m_60918_(SoundType.f_56742_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)));
    public static final BlockItemPair COINJAR_BLUE = ModBlocks.register("coinjar_blue", CreativeModeTab.f_40750_, BlockItemType.COIN_JAR, new CoinJarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(0.1f, 2.0f).m_60918_(SoundType.f_56742_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)));

    private static BlockItemPair register(String name, CreativeModeTab itemGroup, Block block) {
        return ModBlocks.register(name, itemGroup, BlockItemType.DEFAULT, block);
    }

    private static BlockItemPair register(String name, CreativeModeTab itemGroup, BlockItemType type, Block block) {
        block.setRegistryName(name);
        BLOCKS.add(block);
        if (block.getRegistryName() != null) {
            BlockItem item = null;
            switch (type) {
                case CASH_REGISTER: {
                    item = new CashRegisterItem(block, new Item.Properties().m_41491_(itemGroup).m_41487_(1));
                    break;
                }
                case COIN: {
                    item = new CoinBlockItem(block, new Item.Properties().m_41491_(itemGroup));
                    break;
                }
                case NETHERITE_COIN: {
                    item = new CoinBlockItem(block, new Item.Properties().m_41491_(itemGroup).m_41486_());
                    break;
                }
                case COIN_JAR: {
                    item = new CoinJarItem(block, new Item.Properties().m_41491_(itemGroup));
                    break;
                }
                default: {
                    item = new BlockItem(block, new Item.Properties().m_41491_(itemGroup));
                }
            }
            if (item != null) {
                item.setRegistryName(name);
                ITEMS.add((Item)item);
            }
            return new BlockItemPair(block, (Item)item);
        }
        return new BlockItemPair(block, null);
    }

    private static BlockItemSet<Reference.Colors> registerColored(String name, CreativeModeTab itemGroup, Supplier<Block> block, boolean whiteNamed) {
        return ModBlocks.registerColored(name, itemGroup, BlockItemType.DEFAULT, block, whiteNamed);
    }

    private static BlockItemSet<Reference.Colors> registerColored(String name, CreativeModeTab itemGroup, BlockItemType type, Supplier<Block> block, boolean whiteNamed) {
        BlockItemSet<Reference.Colors> set = new BlockItemSet<Reference.Colors>();
        for (Reference.Colors color : Reference.Colors.values()) {
            Object thisName = name;
            if (color != Reference.Colors.WHITE || whiteNamed) {
                thisName = (String)thisName + "_" + color.toString().toLowerCase();
            }
            BlockItemPair thisBlock = ModBlocks.register((String)thisName, itemGroup, type, (Block)block.get());
            set.add(color, thisBlock);
        }
        return set;
    }

    private static BlockItemSet<Reference.WoodType> registerWooden(String name, CreativeModeTab itemGroup, Supplier<Block> block) {
        return ModBlocks.registerWooden(name, itemGroup, BlockItemType.DEFAULT, block);
    }

    private static BlockItemSet<Reference.WoodType> registerWooden(String name, CreativeModeTab itemGroup, BlockItemType type, Supplier<Block> block) {
        BlockItemSet<Reference.WoodType> set = new BlockItemSet<Reference.WoodType>();
        for (Reference.WoodType woodType : Reference.WoodType.values()) {
            String thisName = name + "_" + woodType.toString().toLowerCase();
            BlockItemPair thisBlock = ModBlocks.register(thisName, itemGroup, type, (Block)block.get());
            set.add(woodType, thisBlock);
        }
        return set;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        BLOCKS.forEach(block -> event.getRegistry().register((IForgeRegistryEntry)block));
        BLOCKS.clear();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ITEMS.forEach(item -> event.getRegistry().register((IForgeRegistryEntry)item));
        ITEMS.clear();
    }

    private static enum BlockItemType {
        DEFAULT,
        COIN,
        NETHERITE_COIN,
        CASH_REGISTER,
        COIN_JAR;

    }
}

