/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.IItemSet;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.Reference;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.entity.merchant.villager.CustomProfessions;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class VillagerTradeManager {
    private static final List<VillagerTrades.ItemListing> GENERIC_TRADES_WANDERER = ImmutableList.of((Object)((Object)new LazyTrade((ItemLike)ModItems.COIN_GOLD, 1, (ItemLike)ModBlocks.MACHINE_ATM.item)), (Object)((Object)new LazyTrade((ItemLike)ModItems.COIN_IRON, 5, (ItemLike)ModBlocks.CASH_REGISTER.item)), (Object)((Object)new LazyTrade((ItemLike)ModItems.COIN_IRON, 5, (ItemLike)ModBlocks.TERMINAL.item)));
    private static final List<VillagerTrades.ItemListing> RARE_TRADES_WANDERER = ImmutableList.of((Object)((Object)new LazyTrade((ItemLike)ModItems.COIN_GOLD, 2, (ItemLike)ModItems.COIN_IRON, 4, ModBlocks.DISPLAY_CASE)), (Object)((Object)new LazyTrade((ItemLike)ModItems.COIN_GOLD, 4, (ItemLike)ModBlocks.ARMOR_DISPLAY.item)));
    private static final Map<Integer, List<VillagerTrades.ItemListing>> TRADES_BANKER = ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)((Object)new LazyTrade(2, (ItemLike)ModItems.COIN_IRON, 5, ModBlocks.MACHINE_MINT)), (Object)((Object)new LazyTrade(2, (ItemLike)ModItems.COIN_GOLD, 1, ModBlocks.MACHINE_ATM)), (Object)((Object)new LazyTrade(1, (ItemLike)ModItems.COIN_IRON, 5, ModBlocks.CASH_REGISTER)), (Object)((Object)new LazyTrade(1, (ItemLike)ModItems.COIN_IRON, 4, (ItemLike)ModItems.COIN_COPPER, 8, (ItemLike)ModItems.TRADING_CORE))), (Object)2, (Object)ImmutableList.of((Object)new RandomItemForItemTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 6), new ItemLike[]{ModBlocks.SHELF.get(Reference.WoodType.OAK), ModBlocks.SHELF.get(Reference.WoodType.BIRCH), ModBlocks.SHELF.get(Reference.WoodType.SPRUCE), ModBlocks.SHELF.get(Reference.WoodType.JUNGLE)}, 12, 5, 0.05f), (Object)new RandomItemForItemTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 6), new ItemLike[]{ModBlocks.SHELF.get(Reference.WoodType.ACACIA), ModBlocks.SHELF.get(Reference.WoodType.DARK_OAK), ModBlocks.SHELF.get(Reference.WoodType.WARPED), ModBlocks.SHELF.get(Reference.WoodType.CRIMSON)}, 12, 5, 0.05f), (Object)((Object)new LazyTrade(5, (ItemLike)ModItems.COIN_IRON, 10, ModBlocks.DISPLAY_CASE))), (Object)3, (Object)ImmutableList.of((Object)new RandomItemForItemTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 15), new ItemLike[]{ModBlocks.CARD_DISPLAY.get(Reference.WoodType.OAK), ModBlocks.CARD_DISPLAY.get(Reference.WoodType.BIRCH), ModBlocks.CARD_DISPLAY.get(Reference.WoodType.SPRUCE), ModBlocks.CARD_DISPLAY.get(Reference.WoodType.JUNGLE)}, 12, 10, 0.05f), (Object)new RandomItemForItemTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 15), new ItemLike[]{ModBlocks.CARD_DISPLAY.get(Reference.WoodType.ACACIA), ModBlocks.CARD_DISPLAY.get(Reference.WoodType.DARK_OAK), ModBlocks.CARD_DISPLAY.get(Reference.WoodType.CRIMSON), ModBlocks.CARD_DISPLAY.get(Reference.WoodType.WARPED)}, 12, 10, 0.05f), (Object)((Object)new LazyTrade(10, (ItemLike)ModItems.COIN_IRON, 20, ModBlocks.ARMOR_DISPLAY)), (Object)((Object)new LazyTrade(10, (ItemLike)ModItems.COIN_IRON, 15, ModBlocks.ITEM_TRADER_SERVER_SMALL)), (Object)((Object)new LazyTrade(10, (ItemLike)ModItems.COIN_IRON, 10, ModBlocks.TERMINAL))), (Object)4, (Object)ImmutableList.of((Object)new RandomItemSetForItemTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 25), ModBlocks.VENDING_MACHINE1, 12, 15, 0.05f), (Object)((Object)new LazyTrade(15, (ItemLike)ModItems.COIN_IRON, 30, ModBlocks.ITEM_TRADER_SERVER_MEDIUM)), (Object)((Object)new LazyTrade(20, (ItemLike)ModItems.COIN_IRON, 30, ModBlocks.FREEZER))), (Object)5, (Object)ImmutableList.of((Object)new RandomItemSetForItemTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 25), ModBlocks.VENDING_MACHINE2, 12, 30, 0.05f), (Object)((Object)new LazyTrade(30, (ItemLike)ModItems.COIN_GOLD, 6, ModBlocks.ITEM_TRADER_SERVER_LARGE)), (Object)((Object)new LazyTrade(30, (ItemLike)ModItems.COIN_GOLD, 10, ModBlocks.ITEM_TRADER_SERVER_EXTRA_LARGE))));
    private static final float ENCHANTMENT_PRICE_MODIFIER = 0.25f;
    private static final Map<Integer, List<VillagerTrades.ItemListing>> TRADES_CASHIER = ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 4), new ItemStack((ItemLike)ModItems.COIN_COPPER, 5), new ItemStack((ItemLike)Items.f_42406_, 6), 16, 1, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 7), new ItemStack((ItemLike)Items.f_42458_), 16, 1, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 4), new ItemStack((ItemLike)Items.f_42574_), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 8), new ItemStack((ItemLike)Items.f_42412_, 16), 12, 1, 0.05f), (Object)new EnchantedBookForCoinsTrade(1), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 2), new ItemStack((ItemLike)Blocks.f_50078_), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD), new ItemStack((ItemLike)ModItems.COIN_IRON, 5), new ItemStack((ItemLike)Items.f_42676_), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON), new ItemStack((ItemLike)Items.f_42451_), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 1), new ItemStack((ItemLike)ModItems.COIN_IRON, 6), new ItemStack((ItemLike)Items.f_42470_), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 1), new ItemStack((ItemLike)Items.f_42471_), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 1), new ItemStack((ItemLike)ModItems.COIN_IRON, 3), new ItemStack((ItemLike)Items.f_42468_), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 2), new ItemStack((ItemLike)Items.f_42469_), 12, 1, 0.05f), (Object[])new VillagerTrades.ItemListing[]{new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 6), new ItemStack((ItemLike)Items.f_42386_), 12, 1, 0.05f), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON, 3, (ItemLike)Items.f_42383_, 12, 1, 0.05f, 0.25), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON), new ItemStack((ItemLike)Items.f_42428_), 12, 1, 0.05f), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON), new ItemStack((ItemLike)Items.f_42426_), 12, 1, 0.05f), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON), new ItemStack((ItemLike)Items.f_42427_), 12, 1, 0.05f), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON), new ItemStack((ItemLike)Items.f_42429_), 12, 1, 0.05f), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 2), new ItemStack((ItemLike)Items.f_42699_), 12, 1, 0.05f), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 2), new ItemStack((ItemLike)Items.f_42460_, 10), 16, 1, 0.05f)}), (Object)2, (Object)ImmutableList.of((Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 1), new ItemStack((ItemLike)Items.f_42687_, 4), 12, 5, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 6), new ItemStack((ItemLike)Items.f_42410_, 4), 16, 5, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 3), new ItemStack((ItemLike)Items.f_42526_, 15), 16, 10, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 2), new ItemStack((ItemLike)Blocks.f_50683_), 12, 5, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 2), new ItemStack((ItemLike)Blocks.f_50041_), 16, 5, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 4), new ItemStack((ItemLike)Items.f_42411_), 12, 5, 0.05f), (Object)new EnchantedBookForCoinsTrade(5), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 2), new ItemStack((ItemLike)Blocks.f_50681_), 12, 5, 0.05f), (Object)new ItemsForMapTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 3), StructureFeature.f_67023_, MapDecoration.Type.MONUMENT, 12, 5), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 2), new ItemStack((ItemLike)Items.f_42534_), 12, 5, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 4), new ItemStack((ItemLike)Blocks.f_50680_), 12, 5, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 9), new ItemStack((ItemLike)ModItems.COIN_COPPER, 5), new ItemStack((ItemLike)Items.f_42466_), 12, 5, 0.05f), (Object[])new VillagerTrades.ItemListing[]{new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 6), new ItemStack((ItemLike)ModItems.COIN_COPPER, 3), new ItemStack((ItemLike)Items.f_42467_), 12, 5, 0.05f), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 3), new ItemStack((ItemLike)Items.f_42485_, 6), 16, 5, 0.05f), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 3), new ItemStack((ItemLike)Items.f_42582_, 8), 16, 5, 0.05f), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 2), new ItemStack((ItemLike)Blocks.f_50225_, 4), 16, 5, 0.05f)}), (Object)3, (Object)ImmutableList.of((Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 1), new ItemStack((ItemLike)Items.f_42572_, 18), 18, 10, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON, 2, (ItemLike)Items.f_42523_, 3, 10, 0.05f, 0.25), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 7), new ItemStack((ItemLike)Items.f_42717_), 12, 10, 0.05f), (Object)new EnchantedBookForCoinsTrade(10), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 3), new ItemStack((ItemLike)Blocks.f_50058_, 4), 12, 10, 0.05f), (Object)new ItemsForMapTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 4), StructureFeature.f_67015_, MapDecoration.Type.MANSION, 12, 10), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD), new ItemStack((ItemLike)Blocks.f_50141_), 12, 10, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 7), new ItemStack((ItemLike)ModItems.COIN_COPPER, 4), new ItemStack((ItemLike)Items.f_42464_), 12, 10, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 10), new ItemStack((ItemLike)ModItems.COIN_COPPER, 5), new ItemStack((ItemLike)Items.f_42465_), 12, 10, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 6), new ItemStack((ItemLike)Items.f_42740_), 12, 10, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON, 5, (ItemLike)Items.f_42386_, 3, 12, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON, 4, (ItemLike)Items.f_42384_, 3, 12, 0.05f, 0.25), (Object[])new VillagerTrades.ItemListing[]{new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON, 6, (ItemLike)Items.f_42385_, 3, 12, 0.05f, 0.25), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_DIAMOND, 2), new ItemStack((ItemLike)ModItems.COIN_IRON, 1), new ItemStack((ItemLike)Items.f_42392_), 3, 10, 0.05f), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 2), new ItemStack((ItemLike)Blocks.f_50387_, 4), 16, 10, 0.05f), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 2), new ItemStack((ItemLike)Blocks.f_50281_, 4), 16, 10, 0.05f), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 2), new ItemStack((ItemLike)Blocks.f_50175_, 4), 16, 10, 0.05f)}), (Object)4, (Object)ImmutableList.of((Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 2), new ItemStack((ItemLike)Blocks.f_50145_), 12, 15, 0.05f), (Object)new SuspiciousStewForItemTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD, 1), MobEffects.f_19611_, 100, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD, 1), MobEffects.f_19603_, 160, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD, 1), MobEffects.f_19613_, 100, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD, 1), MobEffects.f_19610_, 120, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD, 1), MobEffects.f_19614_, 100, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD, 1), MobEffects.f_19618_, 7, 15), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON, 5, (ItemLike)Items.f_42411_, 3, 15, 0.05f, 0.25), (Object)new EnchantedBookForCoinsTrade(15), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 5), new ItemStack((ItemLike)Items.f_42524_), 12, 15, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 2), new ItemStack((ItemLike)Items.f_42522_), 12, 15, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD), new ItemStack((ItemLike)Items.f_42617_), 12, 15, 0.05f), (Object[])new VillagerTrades.ItemListing[]{new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD), new ItemStack((ItemLike)Items.f_42584_), 12, 15, 0.05f), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND, 7, (ItemLike)Items.f_42474_, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND, 5, (ItemLike)Items.f_42475_, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND, 4, (ItemLike)Items.f_42391_, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND, 3, (ItemLike)Items.f_42391_, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND, 2, (ItemLike)Items.f_42389_, 3, 15, 0.05f, 0.25), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 2), new ItemStack((ItemLike)Blocks.f_50352_, 1), 16, 15, 0.05f)}), (Object)5, (Object)ImmutableList.of((Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 15), new ItemStack((ItemLike)Items.f_42677_), 12, 30, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 2), new ItemStack((ItemLike)Items.f_42546_), 12, 30, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 5), new ItemStack((ItemLike)Items.f_42487_), 12, 30, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON, 10, (ItemLike)Items.f_42717_, 3, 15, 0.05f, 0.25), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 1), new ItemStack((ItemLike)Items.f_42656_), 12, 30, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 1), new ItemStack((ItemLike)Items.f_42724_), 12, 30, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD, 1), new ItemStack((ItemLike)Blocks.f_50200_, 12), 12, 30, 0.05f), (Object)new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 5), new ItemStack((ItemLike)Items.f_42612_), 12, 30, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND, 8, (ItemLike)Items.f_42473_, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND, 6, (ItemLike)Items.f_42472_, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND, 4, (ItemLike)Items.f_42388_, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND, 4, (ItemLike)Items.f_42390_, 3, 30, 0.05f, 0.25), (Object[])new VillagerTrades.ItemListing[]{new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD, 1), new ItemStack((ItemLike)Items.f_42450_), 12, 30, 0.05f), new BasicTrade(new ItemStack((ItemLike)ModItems.COIN_IRON, 2), new ItemStack((ItemLike)Blocks.f_50333_), 12, 30, 0.05f)}));

    @SubscribeEvent
    public static void OnVillagerTradeSetup(VillagerTradesEvent event) {
        block3: {
            block2: {
                if (event.getType() != CustomProfessions.BANKER || !((Boolean)Config.COMMON.addBankerVillager.get()).booleanValue()) break block2;
                LightmansCurrency.LogInfo("Registering banker trades.");
                for (int i = 1; i <= 5; ++i) {
                    List currentTrades = (List)event.getTrades().get(i);
                    List<VillagerTrades.ItemListing> newTrades = TRADES_BANKER.get(i);
                    newTrades.forEach(trade -> currentTrades.add(trade));
                }
                break block3;
            }
            if (event.getType() != CustomProfessions.CASHIER || !((Boolean)Config.COMMON.addCashierVillager.get()).booleanValue()) break block3;
            LightmansCurrency.LogInfo("Registering cashier trades.");
            for (int i = 1; i <= 5; ++i) {
                List currentTrades = (List)event.getTrades().get(i);
                List<VillagerTrades.ItemListing> newTrades = TRADES_CASHIER.get(i);
                newTrades.forEach(trade -> currentTrades.add(trade));
            }
        }
    }

    @SubscribeEvent
    public static void OnWandererTradeSetup(WandererTradesEvent event) {
        if (!((Boolean)Config.COMMON.addCustomWanderingTrades.get()).booleanValue()) {
            return;
        }
        List genericTrades = event.getGenericTrades();
        List rareTrades = event.getRareTrades();
        GENERIC_TRADES_WANDERER.forEach(trade -> genericTrades.add(trade));
        RARE_TRADES_WANDERER.forEach(trade -> rareTrades.add(trade));
    }

    public static class LazyTrade
    extends BasicTrade {
        private static final int MAX_COUNT = 12;
        private static final float PRICE_MULT = 0.05f;

        public LazyTrade(ItemLike priceItem, int priceCount, ItemLike forsaleItem) {
            this(1, priceItem, priceCount, forsaleItem);
        }

        public LazyTrade(ItemLike priceItem, int priceCount, ItemLike forsaleItem, int forsaleCount) {
            this(1, priceItem, priceCount, forsaleItem, forsaleCount);
        }

        public LazyTrade(int xpValue, ItemLike priceItem, int priceCount, ItemLike forsaleItem) {
            this(xpValue, priceItem, priceCount, forsaleItem, 1);
        }

        public LazyTrade(int xpValue, ItemLike priceItem, int priceCount, ItemLike forsaleItem, int forsaleCount) {
            super(new ItemStack(priceItem, priceCount), new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }

        public LazyTrade(ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem);
        }

        public LazyTrade(ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem, int forsaleCount) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, forsaleCount);
        }

        public LazyTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem) {
            this(xpValue, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, 1);
        }

        public LazyTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem, int forsaleCount) {
            super(new ItemStack(priceItem1, priceCount1), new ItemStack(priceItem2, priceCount2), new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }
    }

    public static class RandomItemForItemTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack price1;
        private final ItemStack price2;
        private final ItemLike[] sellItemOptions;
        private final int maxTrades;
        private final int xpValue;
        private final float priceMult;

        public RandomItemForItemTrade(ItemStack price, ItemLike[] sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this(price, ItemStack.f_41583_, sellItemOptions, maxTrades, xpValue, priceMult);
        }

        public RandomItemForItemTrade(ItemStack price1, ItemStack price2, ItemLike[] sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this.price1 = price1;
            this.price2 = price2;
            this.sellItemOptions = sellItemOptions;
            this.maxTrades = maxTrades;
            this.xpValue = xpValue;
            this.priceMult = priceMult;
        }

        public MerchantOffer m_5670_(Entity trader, Random rand) {
            int index = rand.nextInt(this.sellItemOptions.length);
            ItemStack sellItem = new ItemStack(this.sellItemOptions[index]);
            return new MerchantOffer(this.price1, this.price2, sellItem, this.maxTrades, this.xpValue, this.priceMult);
        }
    }

    public static class RandomItemSetForItemTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack price1;
        private final ItemStack price2;
        private final IItemSet<?> sellItemOptions;
        private final int maxTrades;
        private final int xpValue;
        private final float priceMult;

        public RandomItemSetForItemTrade(ItemStack price, IItemSet<?> sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this(price, ItemStack.f_41583_, sellItemOptions, maxTrades, xpValue, priceMult);
        }

        public RandomItemSetForItemTrade(ItemStack price1, ItemStack price2, IItemSet<?> sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this.price1 = price1;
            this.price2 = price2;
            this.sellItemOptions = sellItemOptions;
            this.maxTrades = maxTrades;
            this.xpValue = xpValue;
            this.priceMult = priceMult;
        }

        public MerchantOffer m_5670_(Entity trader, Random rand) {
            List<Item> items = this.sellItemOptions.getAllItems();
            int index = rand.nextInt(items.size());
            ItemStack sellItem = new ItemStack((ItemLike)items.get(index));
            return new MerchantOffer(this.price1, this.price2, sellItem, this.maxTrades, this.xpValue, this.priceMult);
        }
    }

    private static class EnchantedBookForCoinsTrade
    implements VillagerTrades.ItemListing {
        private static final Item baseCoin = ModItems.COIN_GOLD;
        private static final int baseCoinAmount = 5;
        private final int xpValue;

        public EnchantedBookForCoinsTrade(int xpValue) {
            this.xpValue = xpValue;
        }

        public MerchantOffer m_5670_(Entity trader, Random rand) {
            List list = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(Enchantment::m_6594_).collect(Collectors.toList());
            Enchantment enchantment = (Enchantment)list.get(rand.nextInt(list.size()));
            int level = rand.nextInt(enchantment.m_6586_()) + 1;
            ItemStack itemstack = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, level));
            long coinValue = MoneyUtil.getValue(baseCoin);
            long baseValue = coinValue * 5L;
            int valueRandom = rand.nextInt(5 + level * 10);
            long value = baseValue + coinValue * (long)(level + valueRandom);
            if (enchantment.m_6591_()) {
                value *= 2L;
            }
            List<ItemStack> coins = MoneyUtil.getCoinsOfValue(value);
            ItemStack price1 = ItemStack.f_41583_;
            ItemStack price2 = ItemStack.f_41583_;
            if (coins.size() > 0) {
                price1 = coins.get(0);
            }
            if (coins.size() > 1) {
                price2 = coins.get(1);
            }
            LightmansCurrency.LogInfo("EnchantedBookForCoinsTrade.getOffer() -> \nbaseValue=" + baseValue + "\ncoinValue=" + coinValue + "\nlevel=" + level + "\nvalueRandom=" + valueRandom + "\nvalue=" + value + "\nprice1=" + price1.m_41613_() + "x" + price1.m_41720_().getRegistryName() + "\nprice2=" + price2.m_41613_() + "x" + price2.m_41720_().getRegistryName());
            return new MerchantOffer(price1, price2, itemstack, 12, this.xpValue, 0.05f);
        }
    }

    private static class EnchantedItemForCoinsTrade
    implements VillagerTrades.ItemListing {
        private final Item baseCoin;
        private final int baseCoinCount;
        private final Item sellItem;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;
        private final double basePriceModifier;

        private EnchantedItemForCoinsTrade(ItemLike baseCoin, int baseCoinCount, ItemLike sellItem, int maxUses, int xpValue, float priceMultiplier, double basePriceModifier) {
            this.baseCoin = baseCoin.m_5456_();
            this.baseCoinCount = baseCoinCount;
            this.sellItem = sellItem.m_5456_();
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
            this.basePriceModifier = basePriceModifier;
        }

        public MerchantOffer m_5670_(Entity trader, Random rand) {
            int i = 5 + rand.nextInt(15);
            ItemStack itemstack = EnchantmentHelper.m_44877_((Random)rand, (ItemStack)new ItemStack((ItemLike)this.sellItem), (int)i, (boolean)false);
            long coinValue = MoneyUtil.getValue(this.baseCoin);
            long baseValue = coinValue * (long)this.baseCoinCount;
            long priceValue = baseValue + (long)((double)(coinValue * (long)i) * this.basePriceModifier);
            ItemStack price1 = ItemStack.f_41583_;
            ItemStack price2 = ItemStack.f_41583_;
            List<ItemStack> priceStacks = MoneyUtil.getCoinsOfValue(priceValue);
            if (priceStacks.size() > 0) {
                price1 = priceStacks.get(0);
            }
            if (priceStacks.size() > 1) {
                price2 = priceStacks.get(1);
            }
            LightmansCurrency.LogInfo("EnchantedItemForCoinsTrade.getOffer() -> \ni=" + i + "\ncoinValue=" + coinValue + "\nbaseValue=" + baseValue + "\npriceValue=" + priceValue + "\nprice1=" + price1.m_41613_() + "x" + price1.m_41720_().getRegistryName() + "\nprice2=" + price2.m_41613_() + "x" + price2.m_41720_().getRegistryName());
            return new MerchantOffer(price1, price2, itemstack, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    private static class ItemsForMapTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack price1;
        private final ItemStack price2;
        private final StructureFeature<?> structureName;
        private final MapDecoration.Type mapDecorationType;
        private final int maxUses;
        private final int xpValue;

        public ItemsForMapTrade(ItemStack price, StructureFeature<?> structureName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue) {
            this(price, ItemStack.f_41583_, structureName, mapDecorationType, maxUses, xpValue);
        }

        public ItemsForMapTrade(ItemStack price1, ItemStack price2, StructureFeature<?> structureName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue) {
            this.price1 = price1;
            this.price2 = price2;
            this.structureName = structureName;
            this.mapDecorationType = mapDecorationType;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
        }

        public MerchantOffer m_5670_(Entity trader, Random rand) {
            if (!(trader.f_19853_ instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverworld = (ServerLevel)trader.f_19853_;
            BlockPos blockPos = serverworld.m_8717_(this.structureName, trader.m_142538_(), 100, true);
            if (blockPos != null) {
                ItemStack itemstack = MapItem.m_42886_((Level)serverworld, (int)blockPos.m_123341_(), (int)blockPos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42897_((Level)serverworld, (ItemStack)itemstack);
                MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockPos, (String)"+", (MapDecoration.Type)this.mapDecorationType);
                itemstack.m_41714_((Component)new TranslatableComponent("filled_map." + this.structureName.m_67098_().toLowerCase(Locale.ROOT)));
                return new MerchantOffer(this.price1, this.price2, itemstack, this.maxUses, this.xpValue, 0.05f);
            }
            return null;
        }
    }

    private static class SuspiciousStewForItemTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack price1;
        private final ItemStack price2;
        private final MobEffect effect;
        private final int duration;
        private final int xpValue;

        private SuspiciousStewForItemTrade(ItemStack price, MobEffect effect, int duration, int xpValue) {
            this(price, ItemStack.f_41583_, effect, duration, xpValue);
        }

        private SuspiciousStewForItemTrade(ItemStack price1, ItemStack price2, MobEffect effect, int duration, int xpValue) {
            this.price1 = price1;
            this.price2 = price2;
            this.effect = effect;
            this.duration = duration;
            this.xpValue = xpValue;
        }

        public MerchantOffer m_5670_(Entity trader, Random rand) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42718_, 1);
            SuspiciousStewItem.m_43258_((ItemStack)itemstack, (MobEffect)this.effect, (int)this.duration);
            return new MerchantOffer(this.price1, this.price2, itemstack, 12, this.xpValue, 0.05f);
        }
    }

    public static class SetTrade
    extends BasicTrade {
        private static final int MAX_COUNT = 12;
        private static final float PRICE_MULT = 0.05f;

        public SetTrade(ItemLike priceItem, int priceCount, ItemLike forsaleItem) {
            this(1, priceItem, priceCount, forsaleItem);
        }

        public SetTrade(ItemLike priceItem, int priceCount, ItemLike forsaleItem, int forsaleCount) {
            this(1, priceItem, priceCount, forsaleItem, forsaleCount);
        }

        public SetTrade(int xpValue, ItemLike priceItem, int priceCount, ItemLike forsaleItem) {
            this(xpValue, priceItem, priceCount, forsaleItem, 1);
        }

        public SetTrade(int xpValue, ItemLike priceItem, int priceCount, ItemLike forsaleItem, int forsaleCount) {
            super(new ItemStack(priceItem, priceCount), new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }

        public SetTrade(ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem);
        }

        public SetTrade(ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem, int forsaleCount) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, forsaleCount);
        }

        public SetTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem) {
            this(xpValue, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, 1);
        }

        public SetTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem, int forsaleCount) {
            super(new ItemStack(priceItem1, priceCount1), new ItemStack(priceItem2, priceCount2), new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }
    }
}

