/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.events;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Event;

public abstract class TradeEvent
extends Event {
    private final Player player;
    private final TradeData trade;
    private final Supplier<ITrader> traderSource;

    public final Player getPlayer() {
        return this.player;
    }

    public final TradeData getTrade() {
        return this.trade;
    }

    public final ITrader getTrader() {
        return (ITrader)this.traderSource.get();
    }

    protected TradeEvent(Player player, TradeData trade, Supplier<ITrader> trader) {
        this.player = player;
        this.trade = trade;
        this.traderSource = trader;
    }

    public static class PostTradeEvent
    extends TradeEvent {
        private boolean isDirty = false;
        private final MoneyUtil.CoinValue pricePaid;

        public MoneyUtil.CoinValue getPricePaid() {
            return this.pricePaid;
        }

        public PostTradeEvent(Player player, TradeData trade, Supplier<ITrader> trader, MoneyUtil.CoinValue pricePaid) {
            super(player, trade, trader);
            this.pricePaid = pricePaid;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public void markDirty() {
            this.isDirty = true;
        }

        public void clean() {
            this.isDirty = false;
        }
    }

    public static class TradeCostEvent
    extends TradeEvent {
        private double costMultiplier = 1.0;
        MoneyUtil.CoinValue currentCost;

        public double getCostMultiplier() {
            return this.costMultiplier;
        }

        public void applyCostMultiplier(double newCostMultiplier) {
            this.costMultiplier = MathUtil.clamp(this.costMultiplier * newCostMultiplier, 0.0, 2.0);
        }

        public void setCostMultiplier(double newCostMultiplier) {
            this.costMultiplier = MathUtil.clamp(newCostMultiplier, 0.0, 2.0);
        }

        public MoneyUtil.CoinValue getBaseCost() {
            return this.currentCost;
        }

        public MoneyUtil.CoinValue getCostResult() {
            return this.currentCost.ApplyMultiplier(this.costMultiplier);
        }

        public TradeCostEvent(Player player, TradeData trade, Supplier<ITrader> trader) {
            super(player, trade, trader);
            this.currentCost = trade.getCost();
        }
    }

    public static class PreTradeEvent
    extends TradeEvent {
        private final List<Component> denialText = Lists.newArrayList();

        public PreTradeEvent(Player player, TradeData trade, Supplier<ITrader> trader) {
            super(player, trade, trader);
        }

        public void denyTrade(Component reason) {
            this.denialText.add(reason);
            this.setCanceled(true);
        }

        public List<Component> getDenialReasons() {
            return this.denialText;
        }

        public boolean isCancelable() {
            return true;
        }
    }
}

