/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.items;

import io.github.lightman314.lightmanscurrency.CurrencySoundEvents;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.integration.Curios;
import io.github.lightman314.lightmanscurrency.menus.providers.WalletMenuProvider;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class WalletItem
extends Item {
    private static final SoundEvent emptyOpenSound = new SoundEvent(new ResourceLocation("minecraft", "item.armor.equip_leather"));
    private final ResourceLocation MODEL_TEXTURE;
    private final boolean canConvert;
    private final boolean canPickup;
    private final int storageSize;

    public WalletItem(boolean canConvert, boolean canPickup, int storageSize, String modelName, Item.Properties properties) {
        super(properties);
        this.canConvert = canConvert;
        this.canPickup = canPickup;
        this.storageSize = storageSize;
        this.MODEL_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/entity/" + modelName + ".png");
    }

    public static boolean CanConvert(WalletItem wallet) {
        return wallet.canConvert;
    }

    public static boolean CanPickup(WalletItem wallet) {
        return wallet.canPickup;
    }

    public static int InventorySize(WalletItem wallet) {
        return wallet.storageSize;
    }

    public static int InventorySize(ItemStack wallet) {
        if (wallet.m_41720_() instanceof WalletItem) {
            return WalletItem.InventorySize((WalletItem)wallet.m_41720_());
        }
        return 0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (!LightmansCurrency.isCuriosLoaded()) {
            return null;
        }
        return Curios.createWalletProvider(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        MoneyUtil.CoinValue contents;
        super.m_7373_(stack, level, tooltip, flagIn);
        if (this.canPickup) {
            tooltip.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.wallet.pickup"));
        }
        if (this.canConvert) {
            if (this.canPickup) {
                TranslatableComponent onOffText = WalletItem.getAutoConvert(stack) ? new TranslatableComponent("tooltip.lightmanscurrency.wallet.autoConvert.on") : new TranslatableComponent("tooltip.lightmanscurrency.wallet.autoConvert.off");
                tooltip.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.wallet.autoConvert", new Object[]{onOffText}));
            } else {
                tooltip.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.wallet.manualConvert"));
            }
        }
        if ((contents = new MoneyUtil.CoinValue(WalletItem.getWalletInventory(stack))).getRawValue() > 0L) {
            tooltip.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.wallet.storedmoney", new Object[]{"\u00a72" + contents.getString()}));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack wallet = player.m_21120_(hand);
        if (!world.f_46443_) {
            int walletSlot = WalletItem.GetWalletSlot(player.m_150109_(), wallet);
            if (walletSlot >= 0) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new WalletMenuProvider(walletSlot), (Consumer)new DataWriter(walletSlot));
            } else {
                LightmansCurrency.LogError("Could not find the wallet in the players inventory!");
            }
        } else {
            player.f_19853_.m_5594_(player, player.m_142538_(), emptyOpenSound, SoundSource.PLAYERS, 0.75f, 1.25f + player.f_19853_.f_46441_.nextFloat() * 0.5f);
            if (!WalletItem.isEmpty(wallet)) {
                player.f_19853_.m_5594_(player, player.m_142538_(), CurrencySoundEvents.COINS_CLINKING, SoundSource.PLAYERS, 0.4f, 1.0f);
            }
        }
        return InteractionResultHolder.m_19090_((Object)wallet);
    }

    public static boolean isEmpty(ItemStack wallet) {
        NonNullList<ItemStack> inventory = WalletItem.getWalletInventory(wallet);
        for (ItemStack stack : inventory) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    private static int GetWalletSlot(Inventory inventory, ItemStack wallet) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i) != wallet) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack PickupCoin(ItemStack wallet, ItemStack coins) {
        ItemStack returnValue = coins.m_41777_();
        NonNullList<ItemStack> inventory = WalletItem.getWalletInventory(wallet);
        for (int i = 0; i < inventory.size() && !returnValue.m_41619_(); ++i) {
            ItemStack thisStack = (ItemStack)inventory.get(i);
            if (thisStack.m_41619_()) {
                inventory.set(i, (Object)returnValue.m_41777_());
                returnValue = ItemStack.f_41583_;
                continue;
            }
            if (thisStack.m_41720_() != returnValue.m_41720_()) continue;
            int amountToAdd = MathUtil.clamp(returnValue.m_41613_(), 0, thisStack.m_41741_() - thisStack.m_41613_());
            thisStack.m_41764_(thisStack.m_41613_() + amountToAdd);
            returnValue.m_41764_(returnValue.m_41613_() - amountToAdd);
        }
        inventory = WalletItem.getAutoConvert(wallet) ? WalletItem.ConvertCoins(inventory) : MoneyUtil.SortCoins(inventory);
        WalletItem.putWalletInventory(wallet, inventory);
        return returnValue;
    }

    public static NonNullList<ItemStack> ConvertCoins(NonNullList<ItemStack> inventory) {
        inventory = MoneyUtil.ConvertAllCoinsUp(inventory);
        return MoneyUtil.SortCoins(inventory);
    }

    public static void putWalletInventory(ItemStack wallet, NonNullList<ItemStack> inventory) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return;
        }
        CompoundTag compound = wallet.m_41784_();
        ListTag invList = new ListTag();
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack thisStack = (ItemStack)inventory.get(i);
            if (thisStack.m_41619_()) continue;
            CompoundTag thisItemCompound = thisStack.m_41739_(new CompoundTag());
            thisItemCompound.m_128344_("Slot", (byte)i);
            invList.add((Object)thisItemCompound);
        }
        compound.m_128365_("Items", (Tag)invList);
    }

    public static NonNullList<ItemStack> getWalletInventory(ItemStack wallet) {
        CompoundTag compound = wallet.m_41784_();
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
        }
        NonNullList value = NonNullList.m_122780_((int)WalletItem.InventorySize((WalletItem)wallet.m_41720_()), (Object)ItemStack.f_41583_);
        if (!compound.m_128441_("Items")) {
            return value;
        }
        ListTag invList = compound.m_128437_("Items", 10);
        for (int i = 0; i < invList.size(); ++i) {
            CompoundTag thisCompound = invList.m_128728_(i);
            ItemStack thisStack = ItemStack.m_41712_((CompoundTag)thisCompound);
            int j = thisCompound.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= value.size()) continue;
            value.set(j, (Object)thisStack);
        }
        return value;
    }

    public static boolean getAutoConvert(ItemStack wallet) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return false;
        }
        if (!WalletItem.CanConvert((WalletItem)wallet.m_41720_()) || !WalletItem.CanPickup((WalletItem)wallet.m_41720_())) {
            return false;
        }
        CompoundTag tag = wallet.m_41784_();
        if (!tag.m_128441_("AutoConvert")) {
            tag.m_128379_("AutoConvert", true);
            return true;
        }
        return tag.m_128471_("AutoConvert");
    }

    public static void toggleAutoConvert(ItemStack wallet) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return;
        }
        if (!WalletItem.CanConvert((WalletItem)wallet.m_41720_())) {
            return;
        }
        CompoundTag tag = wallet.m_41784_();
        boolean oldValue = WalletItem.getAutoConvert(wallet);
        tag.m_128379_("AutoConvert", !oldValue);
    }

    public static void CopyWalletContents(ItemStack walletIn, ItemStack walletOut) {
        if (!(walletIn.m_41720_() instanceof WalletItem) || !(walletIn.m_41720_() instanceof WalletItem)) {
            LightmansCurrency.LogError("WalletItem.CopyWalletContents() -> One or both of the wallet stacks are not WalletItems.");
            return;
        }
        WalletItem walletItemIn = (WalletItem)walletIn.m_41720_();
        WalletItem walletItemOut = (WalletItem)walletOut.m_41720_();
        NonNullList<ItemStack> walletInventory1 = WalletItem.getWalletInventory(walletIn);
        NonNullList<ItemStack> walletInventory2 = WalletItem.getWalletInventory(walletOut);
        if (walletInventory1.size() > walletInventory2.size()) {
            LightmansCurrency.LogWarning("WalletItem.CopyWalletContents() -> walletIn has a larger inventory size than walletOut. This may result in a loss of wallet contents.");
        }
        for (int i = 0; i < walletInventory1.size() && i < walletInventory2.size(); ++i) {
            walletInventory2.set(i, (Object)((ItemStack)walletInventory1.get(i)).m_41777_());
        }
        WalletItem.putWalletInventory(walletOut, walletInventory2);
        if (WalletItem.CanConvert(walletItemIn) && WalletItem.CanConvert(walletItemOut) && WalletItem.CanPickup(walletItemIn) && WalletItem.CanPickup(walletItemOut) && WalletItem.getAutoConvert(walletIn) != WalletItem.getAutoConvert(walletOut)) {
            WalletItem.toggleAutoConvert(walletOut);
        }
        if (walletIn.m_41788_()) {
            walletOut.m_41714_(walletIn.m_41786_());
        }
        EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)walletIn), (ItemStack)walletOut);
    }

    public ResourceLocation getModelTexture() {
        return this.MODEL_TEXTURE;
    }

    public static class DataWriter
    implements Consumer<FriendlyByteBuf> {
        private int slotIndex;

        public DataWriter(int slotIndex) {
            this.slotIndex = slotIndex;
        }

        @Override
        public void accept(FriendlyByteBuf buffer) {
            buffer.writeInt(this.slotIndex);
        }
    }
}

