/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.items.crafting;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WalletUpgradeRecipe
extends CustomRecipe {
    private static final List<UpgradeData> UPGRADE_DATA = Lists.newArrayList((Object[])new UpgradeData[]{new UpgradeData(ModItems.WALLET_COPPER, ModItems.WALLET_IRON, ModItems.COIN_IRON), new UpgradeData(ModItems.WALLET_IRON, ModItems.WALLET_GOLD, ModItems.COIN_GOLD, Items.f_42451_), new UpgradeData(ModItems.WALLET_GOLD, ModItems.WALLET_EMERALD, ModItems.COIN_EMERALD, Items.f_42584_), new UpgradeData(ModItems.WALLET_EMERALD, ModItems.WALLET_DIAMOND, ModItems.COIN_DIAMOND), new UpgradeData(ModItems.WALLET_DIAMOND, ModItems.WALLET_NETHERITE, ModItems.COIN_NETHERITE)});

    public WalletUpgradeRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack wallet = null;
        ArrayList upgradeItems = Lists.newArrayList();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack thisItem = inv.m_8020_(i);
            if (thisItem.m_41619_()) continue;
            if (thisItem.m_41720_() instanceof WalletItem) {
                if (wallet == null) {
                    wallet = thisItem;
                    continue;
                }
                return false;
            }
            upgradeItems.add(thisItem);
        }
        UpgradeData data = WalletUpgradeRecipe.getUpgradeData(wallet, upgradeItems);
        return data != null;
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack wallet = null;
        ArrayList upgradeItems = Lists.newArrayList();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack thisItem = inv.m_8020_(i);
            if (thisItem.m_41619_()) continue;
            if (thisItem.m_41720_() instanceof WalletItem) {
                if (wallet == null) {
                    wallet = thisItem;
                    continue;
                }
                return ItemStack.f_41583_;
            }
            upgradeItems.add(thisItem);
        }
        UpgradeData data = WalletUpgradeRecipe.getUpgradeData(wallet, upgradeItems);
        if (data != null) {
            ItemStack walletOut = new ItemStack((ItemLike)data.walletOut);
            WalletItem.CopyWalletContents(wallet, walletOut);
            return walletOut;
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    private static UpgradeData getUpgradeData(ItemStack wallet, List<ItemStack> upgradeItems) {
        for (int i = 0; i < UPGRADE_DATA.size(); ++i) {
            if (!UPGRADE_DATA.get(i).matches(wallet, upgradeItems)) continue;
            return UPGRADE_DATA.get(i);
        }
        return null;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.WALLET_UPGRADE;
    }

    public static void addUpgradeData(WalletItem walletIn, WalletItem walletOut, Item ... upgradeItems) {
        UPGRADE_DATA.add(new UpgradeData(walletIn, walletOut, upgradeItems));
    }

    private static class UpgradeData {
        private final WalletItem walletIn;
        public final WalletItem walletOut;
        private final List<Item> upgradeItems;

        public UpgradeData(WalletItem walletIn, WalletItem walletOut, Item ... upgradeItems) {
            this.walletIn = walletIn;
            this.walletOut = walletOut;
            this.upgradeItems = Lists.newArrayList((Object[])upgradeItems);
        }

        public boolean matches(ItemStack walletIn, List<ItemStack> upgradeItems) {
            if (walletIn == null || upgradeItems == null) {
                return false;
            }
            if (this.walletIn == walletIn.m_41720_() && this.upgradeItems.size() == upgradeItems.size()) {
                for (int i = 0; i < this.upgradeItems.size(); ++i) {
                    Item thisItem = this.upgradeItems.get(i);
                    boolean foundMatch = false;
                    for (int z = 0; z < upgradeItems.size() && !foundMatch; ++z) {
                        if (upgradeItems.get(z).m_41720_() != thisItem) continue;
                        upgradeItems.remove(z);
                        foundMatch = true;
                    }
                    if (foundMatch) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

