/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.menus.slots.DisplaySlot;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.item_trader.MessageItemEditClose;
import io.github.lightman314.lightmanscurrency.network.message.item_trader.MessageItemEditSet;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemEditMenu
extends AbstractContainerMenu {
    public static List<CreativeModeTab> ITEM_GROUP_BLACKLIST = ImmutableList.of((Object)CreativeModeTab.f_40760_, (Object)CreativeModeTab.f_40761_, (Object)CreativeModeTab.f_40754_);
    public static final int columnCount = 9;
    public static final int rowCount = 6;
    private static List<ItemStack> allItems = null;
    public final Player player;
    public final Supplier<IItemTrader> traderSource;
    public final int tradeIndex;
    public final ItemTradeData tradeData;
    List<ItemStack> searchResultItems;
    Container displayInventory;
    private String searchString;
    private int stackCount = 1;
    private int page = 0;
    private int editSlot = 0;
    final List<Slot> tradeSlots;

    public int getStackCount() {
        return this.stackCount;
    }

    public int getPage() {
        return this.page;
    }

    public int getEditSlot() {
        return this.editSlot;
    }

    protected boolean isClient() {
        return this.player.f_19853_.f_46443_;
    }

    public ItemEditMenu(int windowId, Inventory inventory, Supplier<IItemTrader> traderSource, int tradeIndex) {
        this(ModContainers.ITEM_EDIT, windowId, inventory, traderSource, tradeIndex, ((IItemTrader)traderSource.get()).getTrade(tradeIndex));
    }

    protected ItemEditMenu(MenuType<?> type, int windowId, Inventory inventory, Supplier<IItemTrader> traderSource, int tradeIndex, ItemTradeData tradeData) {
        super(type, windowId);
        this.player = inventory.f_35978_;
        this.tradeData = tradeData;
        this.tradeIndex = tradeIndex;
        this.traderSource = traderSource;
        this.tradeSlots = new ArrayList<Slot>();
        this.displayInventory = new SimpleContainer(54);
        if (!this.isClient()) {
            return;
        }
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot(this.displayInventory, x + y * 9, 8 + x * 18, 18 + y * 18));
            }
        }
        ItemEditMenu.initItemList();
        this.modifySearch("");
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        if (!this.isClient()) {
            return;
        }
        if (slotId >= 0 && slotId < this.f_38839_.size()) {
            Slot slot = (Slot)this.f_38839_.get(slotId);
            if (slot == null) {
                return;
            }
            if (slot instanceof DisplaySlot) {
                return;
            }
            ItemStack stack = slot.m_7993_();
            if (!stack.m_41619_()) {
                this.setItem(stack, this.editSlot);
                return;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static void initItemList() {
        if (allItems != null) {
            return;
        }
        allItems = new ArrayList<ItemStack>();
        for (CreativeModeTab group : CreativeModeTab.f_40748_) {
            if (ITEM_GROUP_BLACKLIST.contains(group)) continue;
            NonNullList items = NonNullList.m_122779_();
            group.m_6151_(items);
            for (ItemStack stack : items) {
                if (!ItemEditMenu.itemListAlreadyContains(stack)) {
                    allItems.add(stack);
                }
                if (stack.m_41720_() != Items.f_42690_) continue;
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                enchantments.forEach((enchantment, level) -> {
                    for (int newLevel = level - 1; newLevel > 0; --newLevel) {
                        ItemStack newBook = new ItemStack((ItemLike)Items.f_42690_);
                        EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)enchantment, (Object)newLevel), (ItemStack)newBook);
                        if (ItemEditMenu.itemListAlreadyContains(newBook)) continue;
                        allItems.add(newBook);
                    }
                });
            }
        }
    }

    private static boolean itemListAlreadyContains(ItemStack stack) {
        for (ItemStack s : allItems) {
            if (!InventoryUtil.ItemMatches(s, stack)) continue;
            return true;
        }
        return false;
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void modifySearch(String newSearch) {
        this.searchString = newSearch.toLowerCase();
        if (this.searchString.length() > 0) {
            this.searchResultItems = new ArrayList<ItemStack>();
            for (ItemStack stack : allItems) {
                if (stack.m_41786_().getString().toLowerCase().contains(this.searchString)) {
                    this.searchResultItems.add(stack);
                    continue;
                }
                if (stack.m_41720_().getRegistryName().toString().contains(this.searchString)) {
                    this.searchResultItems.add(stack);
                    continue;
                }
                AtomicReference<Boolean> enchantmentMatch = new AtomicReference<Boolean>(false);
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                enchantments.forEach((enchantment, level) -> {
                    if (enchantment.getRegistryName().toString().contains(this.searchString)) {
                        enchantmentMatch.set(true);
                    } else if (enchantment.m_44700_(level.intValue()).getString().toLowerCase().contains(this.searchString)) {
                        enchantmentMatch.set(true);
                    }
                });
                if (!enchantmentMatch.get().booleanValue()) continue;
                this.searchResultItems.add(stack);
            }
        } else {
            this.searchResultItems = allItems;
        }
        this.refreshPage();
    }

    public void modifyStackSize(int deltaCount) {
        this.stackCount = MathUtil.clamp(this.stackCount + deltaCount, 1, 64);
        for (int i = 0; i < this.displayInventory.m_6643_(); ++i) {
            ItemStack stack = this.displayInventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            stack.m_41764_(MathUtil.clamp(this.stackCount, 1, stack.m_41741_()));
        }
    }

    public int maxPage() {
        return (this.searchResultItems.size() - 1) / this.displayInventory.m_6643_();
    }

    public void modifyPage(int deltaPage) {
        this.page += deltaPage;
        this.refreshPage();
    }

    public void refreshPage() {
        if (this.page < 0) {
            this.page = 0;
        }
        if (this.page > this.maxPage()) {
            this.page = this.maxPage();
        }
        int startIndex = this.page * 9 * 6;
        for (int i = 0; i < this.displayInventory.m_6643_(); ++i) {
            int thisIndex = startIndex + i;
            if (thisIndex < this.searchResultItems.size()) {
                ItemStack stack = this.searchResultItems.get(thisIndex).m_41777_();
                stack.m_41764_(MathUtil.clamp(this.stackCount, 1, stack.m_41741_()));
                this.displayInventory.m_6836_(i, stack);
                continue;
            }
            this.displayInventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public void toggleEditSlot() {
        if (this.tradeData.isBarter()) {
            this.editSlot = this.editSlot == 1 ? 0 : 1;
        }
    }

    public void setItem(ItemStack stack, int slot) {
        if (this.isClient()) {
            if (this.editSlot == 1) {
                this.tradeData.setBarterItem(stack);
            } else {
                this.tradeData.setSellItem(stack);
            }
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageItemEditSet(stack, this.editSlot));
        } else {
            if (slot == 1) {
                ((IItemTrader)this.traderSource.get()).getTrade(this.tradeIndex).setBarterItem(stack);
            } else {
                ((IItemTrader)this.traderSource.get()).getTrade(this.tradeIndex).setSellItem(stack);
            }
            ((IItemTrader)this.traderSource.get()).markTradesDirty();
        }
    }

    public void openTraderStorage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageItemEditClose());
        } else {
            ((IItemTrader)this.traderSource.get()).openStorageMenu(this.player);
        }
    }
}

