/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.PaygateBlockEntity;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.TicketItem;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.containers.TicketInventory;
import io.github.lightman314.lightmanscurrency.menus.interfaces.ITraderMenuPrimitive;
import io.github.lightman314.lightmanscurrency.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.menus.slots.TicketSlot;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PaygateMenu
extends AbstractContainerMenu
implements ITraderMenuPrimitive {
    public final Player player;
    protected static final MenuType<?> type = ModContainers.ITEMTRADER;
    protected final Container coinInput = new SimpleContainer(5);
    protected final Container ticketInput = new TicketInventory(1);
    public final PaygateBlockEntity tileEntity;
    public final int priceInputOffset;

    public PaygateMenu(int windowId, Inventory inventory, PaygateBlockEntity tileEntity) {
        super(ModContainers.PAYGATE, windowId);
        int x;
        this.tileEntity = tileEntity;
        this.player = inventory.f_35978_;
        this.priceInputOffset = this.isOwner() ? 69 : 0;
        for (x = 0; x < this.coinInput.m_6643_(); ++x) {
            this.m_38897_(new CoinSlot(this.coinInput, x, 8 + (x + 4) * 18, 37 + this.priceInputOffset));
        }
        this.m_38897_(new TicketSlot(this.ticketInput, 0, 62, 37 + this.priceInputOffset));
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)inventory, x2 + y * 9 + 9, 8 + x2 * 18, 69 + y * 18 + this.priceInputOffset));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 127 + this.priceInputOffset));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.m_150411_(playerIn, this.coinInput);
        this.m_150411_(playerIn, this.ticketInput);
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < this.coinInput.m_6643_() ? !this.m_38903_(slotStack, this.coinInput.m_6643_(), this.f_38839_.size(), true) : (index >= this.coinInput.m_6643_() && index < this.coinInput.m_6643_() + this.ticketInput.m_6643_() ? !this.m_38903_(slotStack, this.coinInput.m_6643_() + this.ticketInput.m_6643_(), this.f_38839_.size(), true) : index < this.f_38839_.size() && !this.m_38903_(slotStack, 0, this.coinInput.m_6643_() + this.ticketInput.m_6643_(), false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public boolean HasMasterTicket() {
        return TicketItem.isMasterTicket(this.ticketInput.m_8020_(0));
    }

    public boolean HasValidTicket() {
        ItemStack ticket = this.ticketInput.m_8020_(0);
        if (TicketItem.isMasterTicket(ticket)) {
            return false;
        }
        return this.tileEntity.validTicket(ticket);
    }

    public UUID GetTicketID() {
        return TicketItem.GetTicketID(this.ticketInput.m_8020_(0));
    }

    public long GetCoinValue() {
        long value = 0L;
        for (int i = 0; i < this.coinInput.m_6643_(); ++i) {
            value += MoneyUtil.getValue(this.coinInput.m_8020_(i));
        }
        ItemStack wallet = LightmansCurrency.getWalletStack(this.player);
        if (!wallet.m_41619_()) {
            value += MoneyUtil.getValue(WalletItem.getWalletInventory(wallet));
        }
        return value;
    }

    public boolean CanActivate() {
        if (this.tileEntity.isActive()) {
            return false;
        }
        if (this.tileEntity.HasPairedTicket()) {
            if (this.tileEntity.getPrice().getRawValue() <= 0L) {
                return this.HasValidTicket();
            }
            return this.HasValidTicket() || this.GetCoinValue() >= this.tileEntity.getPrice().getRawValue();
        }
        return this.GetCoinValue() >= this.tileEntity.getPrice().getRawValue();
    }

    public void Activate() {
        if (!this.CanActivate()) {
            return;
        }
        if (this.HasValidTicket()) {
            this.ticketInput.m_7407_(0, 1);
            ItemStack ticketStub = new ItemStack((ItemLike)ModItems.TICKET_STUB);
            if (this.ticketInput.m_8020_(0).m_41619_()) {
                this.ticketInput.m_6836_(0, ticketStub);
            } else {
                SimpleContainer temp = new SimpleContainer(1);
                temp.m_6836_(0, ticketStub);
                this.m_150411_(this.player, (Container)temp);
            }
        } else {
            if (!MoneyUtil.ProcessPayment(this.coinInput, this.player, this.tileEntity.getPrice())) {
                return;
            }
            this.tileEntity.addStoredMoney(this.tileEntity.getPrice());
        }
        this.tileEntity.activate();
    }

    @Override
    public void CollectCoinStorage() {
        List<ItemStack> coinList = MoneyUtil.getCoinsOfValue(this.tileEntity.getStoredMoney());
        ItemStack wallet = LightmansCurrency.getWalletStack(this.player);
        if (!wallet.m_41619_()) {
            ArrayList<ItemStack> spareCoins = new ArrayList<ItemStack>();
            for (int i = 0; i < coinList.size(); ++i) {
                ItemStack extraCoins = WalletItem.PickupCoin(wallet, coinList.get(i));
                if (extraCoins.m_41619_()) continue;
                spareCoins.add(extraCoins);
            }
            coinList = spareCoins;
        }
        for (int i = 0; i < coinList.size(); ++i) {
            if (this.manualCoinMerge(coinList.get(i))) continue;
            SimpleContainer inventory = new SimpleContainer(1);
            inventory.m_6836_(0, coinList.get(i));
            this.m_150411_(this.player, (Container)inventory);
        }
        this.tileEntity.clearStoredMoney();
    }

    private boolean manualCoinMerge(ItemStack mergeStack) {
        int availableSlots;
        int amountToPlace;
        ItemStack inventoryStack;
        int i;
        int amountToMerge = mergeStack.m_41613_();
        Item mergeItem = mergeStack.m_41720_();
        ArrayList<Pair> mergeOrders = new ArrayList<Pair>();
        for (i = 0; i < this.coinInput.m_6643_() && amountToMerge > 0; ++i) {
            inventoryStack = this.coinInput.m_8020_(i);
            if (inventoryStack.m_41720_() != mergeItem || inventoryStack.m_41613_() == inventoryStack.m_41741_()) continue;
            amountToPlace = amountToMerge;
            availableSlots = inventoryStack.m_41741_() - inventoryStack.m_41613_();
            if (amountToPlace > availableSlots) {
                amountToPlace = availableSlots;
            }
            mergeOrders.add(new Pair((Object)i, (Object)amountToPlace));
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < this.coinInput.m_6643_() && amountToMerge > 0; ++i) {
            inventoryStack = this.coinInput.m_8020_(i);
            if (!inventoryStack.m_41619_()) continue;
            amountToPlace = amountToMerge;
            availableSlots = 64;
            if (amountToPlace > availableSlots) {
                amountToPlace = availableSlots;
            }
            mergeOrders.add(new Pair((Object)i, (Object)amountToPlace));
            amountToMerge -= amountToPlace;
        }
        if (amountToMerge > 0) {
            return false;
        }
        mergeOrders.forEach(order -> {
            ItemStack itemStack = this.coinInput.m_8020_(((Integer)order.getFirst()).intValue());
            if (itemStack.m_41619_()) {
                this.coinInput.m_6836_(((Integer)order.getFirst()).intValue(), new ItemStack((ItemLike)mergeItem, ((Integer)order.getSecond()).intValue()));
            } else {
                this.coinInput.m_6836_(((Integer)order.getFirst()).intValue(), new ItemStack((ItemLike)mergeItem, (Integer)order.getSecond() + itemStack.m_41613_()));
            }
        });
        return true;
    }

    public boolean isOwner() {
        return this.tileEntity.isOwner((Entity)this.player);
    }
}

