/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.ItemTraderUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.UniversalMenu;
import io.github.lightman314.lightmanscurrency.menus.interfaces.ITraderMenu;
import io.github.lightman314.lightmanscurrency.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class UniversalItemTraderMenu
extends UniversalMenu
implements ITraderMenu {
    protected static final MenuType<?> type = ModContainers.ITEMTRADER;
    protected final Container coinSlots = new SimpleContainer(5);
    protected final Container itemSlots = new SimpleContainer(3);

    public UniversalItemTraderData getData() {
        if (this.getRawData() == null || !(this.getRawData() instanceof UniversalItemTraderData)) {
            return null;
        }
        return (UniversalItemTraderData)this.getRawData();
    }

    public UniversalItemTraderMenu(int windowId, Inventory inventory, UUID traderID) {
        super(ModContainers.UNIVERSAL_ITEMTRADER, windowId, traderID, inventory.f_35978_);
        int x;
        for (x = 0; x < this.coinSlots.m_6643_(); ++x) {
            this.m_38897_(new CoinSlot(this.coinSlots, x, ItemTraderUtil.getInventoryDisplayOffset(this.getData()) + 8 + (x + 4) * 18, this.getCoinSlotHeight()));
        }
        for (x = 0; x < this.itemSlots.m_6643_(); ++x) {
            this.m_38897_(new Slot(this.itemSlots, x, ItemTraderUtil.getInventoryDisplayOffset(this.getData()) + 8 + x * 18, this.getCoinSlotHeight()));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)inventory, x2 + y * 9 + 9, ItemTraderUtil.getInventoryDisplayOffset(this.getData()) + 8 + x2 * 18, this.getPlayerInventoryStartHeight() + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, ItemTraderUtil.getInventoryDisplayOffset(this.getData()) + 8 + x * 18, this.getPlayerInventoryStartHeight() + 58));
        }
    }

    public int getTradeCount() {
        return this.getData().getAllTrades().size();
    }

    protected int getTradeButtonBottom() {
        return ItemTraderUtil.getTradeDisplayHeight(this.getData()) + 11;
    }

    protected int getCoinSlotHeight() {
        return this.getTradeButtonBottom() + 8;
    }

    protected int getPlayerInventoryStartHeight() {
        return this.getCoinSlotHeight() + 32;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    @Override
    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.m_150411_(playerIn, this.coinSlots);
        this.m_150411_(playerIn, this.itemSlots);
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < this.coinSlots.m_6643_() + this.itemSlots.m_6643_() ? !this.m_38903_(slotStack, this.coinSlots.m_6643_() + this.itemSlots.m_6643_(), this.f_38839_.size(), true) : index < this.f_38839_.size() && (MoneyUtil.isCoin(slotStack.m_41720_()) ? !this.m_38903_(slotStack, 0, this.coinSlots.m_6643_(), false) : !this.m_38903_(slotStack, this.coinSlots.m_6643_(), this.coinSlots.m_6643_() + this.itemSlots.m_6643_(), false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public long GetCoinValue() {
        long value = 0L;
        for (int i = 0; i < this.coinSlots.m_6643_(); ++i) {
            value += MoneyUtil.getValue(this.coinSlots.m_8020_(i));
        }
        ItemStack wallet = LightmansCurrency.getWalletStack(this.player);
        if (!wallet.m_41619_()) {
            value += MoneyUtil.getValue(WalletItem.getWalletInventory(wallet));
        }
        return value;
    }

    public Container GetItemInventory() {
        return this.itemSlots;
    }

    public IItemTrader getTrader() {
        return this.getData();
    }

    public ItemTradeData GetTrade(int tradeIndex) {
        return this.getData().getTrade(tradeIndex);
    }

    @Override
    public void ExecuteTrade(int tradeIndex) {
        ItemTradeData trade = this.getData().getTrade(tradeIndex);
        if (trade == null) {
            LightmansCurrency.LogError("Trade at index " + tradeIndex + " is null. Cannot execute trade!");
            return;
        }
        if (!trade.isValid()) {
            LightmansCurrency.LogWarning("Trade at index " + tradeIndex + " is not a valid trade. Cannot execute trade.");
            return;
        }
        if (this.getData().runPreTradeEvent(this.player, tradeIndex).isCanceled()) {
            return;
        }
        MoneyUtil.CoinValue price = this.getData().runTradeCostEvent(this.player, tradeIndex).getCostResult();
        if (trade.isSale()) {
            if (!trade.hasStock(this.getData()) && !this.getData().isCreative()) {
                LightmansCurrency.LogDebug("Not enough items in storage to carry out the trade at index " + tradeIndex + ". Cannot execute trade.");
                return;
            }
            if (!InventoryUtil.CanPutItemStack(this.itemSlots, trade.getSellItem())) {
                LightmansCurrency.LogInfo("Not enough room for the output item. Aborting trade!");
                return;
            }
            if (!MoneyUtil.ProcessPayment(this.coinSlots, this.player, price)) {
                LightmansCurrency.LogDebug("Not enough money is present for the trade at index " + tradeIndex + ". Cannot execute trade.");
                return;
            }
            ItemStack giveStack = trade.getSellItem();
            if (!InventoryUtil.PutItemStack(this.itemSlots, giveStack)) {
                LightmansCurrency.LogError("Not enough room for the output item. Giving refund & aborting Trade!");
                List<ItemStack> refundCoins = MoneyUtil.getCoinsOfValue(price);
                ItemStack wallet = LightmansCurrency.getWalletStack(this.player);
                for (int i = 0; i < refundCoins.size(); ++i) {
                    ItemStack coins = refundCoins.get(i);
                    if (!wallet.m_41619_()) {
                        coins = WalletItem.PickupCoin(wallet, coins);
                    }
                    if (coins.m_41619_() || (coins = InventoryUtil.TryPutItemStack(this.coinSlots, coins)).m_41619_()) continue;
                    SimpleContainer temp = new SimpleContainer(1);
                    temp.m_6836_(0, coins);
                    this.m_150411_(this.player, (Container)temp);
                }
                return;
            }
            this.getData().getLogger().AddLog(this.player, trade, price, this.getData().isCreative());
            this.getData().markLoggerDirty();
            this.getData().runPostTradeEvent(this.player, tradeIndex, price);
            if (!this.getData().isCreative()) {
                trade.RemoveItemsFromStorage(this.getData().getStorage());
                this.getData().addStoredMoney(price);
                this.getData().markStorageDirty();
            }
        } else if (trade.isPurchase()) {
            if (InventoryUtil.GetItemCount(this.itemSlots, trade.getSellItem()) < trade.getSellItem().m_41613_()) {
                LightmansCurrency.LogDebug("Not enough items in the item slots to make the purchase.");
                return;
            }
            if (!InventoryUtil.CanPutItemStack(this.getData().getStorage(), trade.getSellItem()) && !this.getData().isCreative()) {
                LightmansCurrency.LogDebug("Not enough room in storage to store the purchased items.");
            }
            if (!trade.hasStock(this.getData()) && !this.getData().isCreative()) {
                LightmansCurrency.LogDebug("Not enough money in storage to pay for the purchased items.");
                return;
            }
            InventoryUtil.RemoveItemCount(this.itemSlots, trade.getSellItem());
            MoneyUtil.ProcessChange(this.coinSlots, this.player, price);
            this.getData().getLogger().AddLog(this.player, trade, price, this.getData().isCreative());
            this.getData().markLoggerDirty();
            this.getData().runPostTradeEvent(this.player, tradeIndex, price);
            if (!this.getData().isCreative()) {
                InventoryUtil.TryPutItemStack(this.getData().getStorage(), trade.getSellItem());
                this.getData().removeStoredMoney(price);
                this.getData().markStorageDirty();
            }
        } else if (trade.isBarter()) {
            if (InventoryUtil.GetItemCount(this.itemSlots, trade.getBarterItem()) < trade.getBarterItem().m_41613_()) {
                LightmansCurrency.LogDebug("Not enough items in the item slots to make the barter.");
                return;
            }
            if (!trade.hasSpace(this.getData()) && !this.getData().isCreative()) {
                LightmansCurrency.LogDebug("Not enough room in storage to store the purchased items.");
                return;
            }
            if (!trade.hasStock(this.getData()) && !this.getData().isCreative()) {
                LightmansCurrency.LogDebug("Not enough items in storage to carry out the trade at index " + tradeIndex + ". Cannot execute trade.");
                return;
            }
            InventoryUtil.RemoveItemCount(this.itemSlots, trade.getBarterItem());
            if (!InventoryUtil.CanPutItemStack(this.itemSlots, trade.getSellItem())) {
                LightmansCurrency.LogDebug("Not enough room for the output item. Aborting trade!");
                InventoryUtil.PutItemStack(this.itemSlots, trade.getBarterItem());
                return;
            }
            InventoryUtil.PutItemStack(this.itemSlots, trade.getSellItem());
            this.getData().getLogger().AddLog(this.player, trade, MoneyUtil.CoinValue.EMPTY, this.getData().isCreative());
            this.getData().markLoggerDirty();
            this.getData().runPostTradeEvent(this.player, tradeIndex, price);
            if (!this.getData().isCreative()) {
                InventoryUtil.TryPutItemStack(this.getData().getStorage(), trade.getBarterItem());
                trade.RemoveItemsFromStorage(this.getData().getStorage());
                this.getData().markStorageDirty();
            }
        }
    }

    @Override
    public void CollectCoinStorage() {
        List<ItemStack> coinList = MoneyUtil.getCoinsOfValue(this.getData().getStoredMoney());
        ItemStack wallet = LightmansCurrency.getWalletStack(this.player);
        if (!wallet.m_41619_()) {
            ArrayList<ItemStack> spareCoins = new ArrayList<ItemStack>();
            for (int i = 0; i < coinList.size(); ++i) {
                ItemStack extraCoins = WalletItem.PickupCoin(wallet, coinList.get(i));
                if (extraCoins.m_41619_()) continue;
                spareCoins.add(extraCoins);
            }
            coinList = spareCoins;
        }
        for (int i = 0; i < coinList.size(); ++i) {
            if (InventoryUtil.PutItemStack(this.coinSlots, coinList.get(i))) continue;
            SimpleContainer inventory = new SimpleContainer(1);
            inventory.m_6836_(0, coinList.get(i));
            this.m_150411_(this.player, (Container)inventory);
        }
        this.getData().clearStoredMoney();
    }

    public void tick() {
    }

    public boolean isOwner() {
        return this.getData().isOwner(this.player);
    }

    public boolean hasPermissions() {
        return this.getData().hasPermissions(this.player);
    }

    @Override
    protected void onForceReopen() {
        LightmansCurrency.LogDebug("UniversalItemTraderContainer.onForceReopen()");
        this.getData().openTradeMenu(this.player);
    }
}

