/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.ItemTraderStorageUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.UniversalMenu;
import io.github.lightman314.lightmanscurrency.menus.containers.SuppliedInventory;
import io.github.lightman314.lightmanscurrency.menus.interfaces.ICreativeTraderMenu;
import io.github.lightman314.lightmanscurrency.menus.interfaces.IItemEditCapable;
import io.github.lightman314.lightmanscurrency.menus.interfaces.IUniversalTraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.item_trader.MessageOpenItemEdit;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageSyncStorage;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class UniversalItemTraderStorageMenu
extends UniversalMenu
implements IUniversalTraderStorageMenu,
ICreativeTraderMenu,
IItemEditCapable {
    public static final int BUTTONSPACE = 99;
    public static final int SCREEN_EXTENSION = 99;
    final Container coinSlots;
    private Container storage = new SuppliedInventory((Supplier<Container>)((Supplier)() -> this.getData().getStorage()));
    private Container copyStorage = InventoryUtil.copyInventory(this.storage);

    public UniversalItemTraderData getData() {
        if (this.getRawData() == null || !(this.getRawData() instanceof UniversalItemTraderData)) {
            return null;
        }
        return (UniversalItemTraderData)this.getRawData();
    }

    public UniversalItemTraderStorageMenu(int windowId, Inventory inventory, UUID traderID) {
        super(ModContainers.UNIVERSAL_ITEMTRADERSTORAGE, windowId, traderID, inventory.f_35978_);
        int x;
        int tradeCount = this.getData().getTradeCount();
        int rowCount = ItemTraderStorageUtil.getRowCount(tradeCount);
        int columnCount = 9 * ItemTraderStorageUtil.getColumnCount(tradeCount);
        for (int y = 0; y < rowCount; ++y) {
            for (x = 0; x < columnCount && x + y * columnCount < this.storage.m_6643_(); ++x) {
                this.m_38897_(new Slot(this.storage, x + y * columnCount, 8 + x * 18 + 99 + ItemTraderStorageUtil.getStorageSlotOffset(tradeCount, y), 18 + y * 18));
            }
        }
        int inventoryOffset = ItemTraderStorageUtil.getInventoryOffset(tradeCount);
        this.coinSlots = new SimpleContainer(5);
        for (int i = 0; i < 5; ++i) {
            this.m_38897_(new CoinSlot(this.coinSlots, i, inventoryOffset + 176 + 8 + 99, this.getStorageBottom() + 3 + i * 18));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)inventory, x2 + y * 9 + 9, inventoryOffset + 8 + x2 * 18 + 99, this.getStorageBottom() + 15 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, inventoryOffset + 8 + x * 18 + 99, this.getStorageBottom() + 15 + 58));
        }
    }

    public int getStorageBottom() {
        return ItemTraderStorageUtil.getRowCount(this.getData().getTradeCount()) * 18 + 28;
    }

    public void tick() {
        if (this.getData() == null) {
            this.player.m_6915_();
            return;
        }
        this.CheckStorage();
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < this.storage.m_6643_()) {
                if (!this.m_38903_(slotStack, this.storage.m_6643_() + this.coinSlots.m_6643_(), this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index < this.storage.m_6643_() + this.coinSlots.m_6643_()) {
                LightmansCurrency.LogInfo("Merging coin slots back into inventory.");
                if (!this.m_38903_(slotStack, this.storage.m_6643_() + this.coinSlots.m_6643_(), this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (MoneyUtil.isCoin(slotStack) ? !this.m_38903_(slotStack, this.storage.m_6643_(), this.storage.m_6643_() + this.coinSlots.m_6643_(), false) : !this.m_38903_(slotStack, 0, this.storage.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    @Override
    public void m_6877_(Player playerIn) {
        this.m_150411_(playerIn, this.coinSlots);
        super.m_6877_(playerIn);
    }

    @Override
    public void CheckStorage() {
        boolean changed = false;
        boolean isServer = !this.player.f_19853_.f_46443_;
        for (int i = 0; i < this.storage.m_6643_() && !changed; ++i) {
            if (ItemStack.m_41746_((ItemStack)this.storage.m_8020_(i), (ItemStack)this.copyStorage.m_8020_(i))) continue;
            changed = true;
        }
        if (changed && isServer) {
            this.getData().markStorageDirty();
            this.copyStorage = InventoryUtil.copyInventory(this.storage);
        } else if (changed) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSyncStorage());
            this.copyStorage = InventoryUtil.copyInventory(this.storage);
        }
    }

    public boolean isOwner() {
        return this.getData().isOwner(this.player);
    }

    public boolean hasPermissions() {
        return this.getData().hasPermissions(this.player);
    }

    public void openItemEditScreenForSlot(int slotIndex) {
        int tradeIndex = slotIndex - this.storage.m_6643_();
        this.openItemEditScreenForTrade(tradeIndex);
    }

    @Override
    public void openItemEditScreenForTrade(int tradeIndex) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenItemEdit(tradeIndex));
        } else {
            this.getData().openItemEditMenu(this.player, tradeIndex);
        }
    }

    @Override
    public void AddCoins() {
        if (this.getData() == null) {
            this.player.m_6915_();
            return;
        }
        MoneyUtil.CoinValue addValue = MoneyUtil.CoinValue.easyBuild2(this.coinSlots);
        this.getData().addStoredMoney(addValue);
        this.coinSlots.m_6211_();
    }

    public boolean HasCoinsToAdd() {
        return !this.coinSlots.m_7983_();
    }

    @Override
    public void CollectCoinStorage() {
        int i;
        if (this.getData() == null) {
            this.player.m_6915_();
            return;
        }
        List<ItemStack> coinList = MoneyUtil.getCoinsOfValue(this.getData().getStoredMoney());
        ItemStack wallet = LightmansCurrency.getWalletStack(this.player);
        if (!wallet.m_41619_()) {
            ArrayList<ItemStack> spareCoins = new ArrayList<ItemStack>();
            for (i = 0; i < coinList.size(); ++i) {
                ItemStack extraCoins = WalletItem.PickupCoin(wallet, coinList.get(i));
                if (extraCoins.m_41619_()) continue;
                spareCoins.add(extraCoins);
            }
            coinList = spareCoins;
        }
        SimpleContainer inventory = new SimpleContainer(coinList.size());
        for (i = 0; i < coinList.size(); ++i) {
            inventory.m_6836_(i, coinList.get(i));
        }
        this.m_150411_(this.player, (Container)inventory);
        this.getData().clearStoredMoney();
    }

    @Override
    public void ToggleCreative() {
        if (this.getData() == null) {
            this.player.m_6915_();
            return;
        }
        this.getData().toggleCreative();
    }

    @Override
    protected void onForceReopen() {
        LightmansCurrency.LogInfo("UniversalItemTraderStorageContainer.onForceReopen()");
        this.getData().openStorageMenu(this.player);
    }

    @Override
    public void AddTrade() {
        this.getData().addTrade();
    }

    @Override
    public void RemoveTrade() {
        this.getData().removeTrade();
    }
}

