/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus;

import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public abstract class UniversalMenu
extends AbstractContainerMenu {
    private static final List<UniversalMenu> activeContainers = new ArrayList<UniversalMenu>();
    public final UUID traderID;
    public final Player player;

    public UniversalTraderData getRawData() {
        if (this.isServer()) {
            return TradingOffice.getData(this.traderID);
        }
        return ClientTradingOffice.getData(this.traderID);
    }

    public boolean isClient() {
        return this.player.f_19853_.f_46443_;
    }

    public boolean isServer() {
        return !this.player.f_19853_.f_46443_;
    }

    protected UniversalMenu(MenuType<?> type, int windowID, UUID traderID, Player player) {
        super(type, windowID);
        this.player = player;
        this.traderID = traderID;
        activeContainers.add(this);
    }

    public static void onForceReopen(UUID traderID) {
        ArrayList oldActiveContainers = new ArrayList();
        activeContainers.forEach(container -> oldActiveContainers.add(container));
        oldActiveContainers.forEach(container -> {
            if (container.traderID.equals(traderID) && container.isServer()) {
                container.onForceReopen();
            }
        });
    }

    protected abstract void onForceReopen();

    public void m_6877_(Player player) {
        if (activeContainers.contains((Object)this)) {
            activeContainers.remove((Object)this);
        }
        super.m_6877_(player);
    }
}

