/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.coinmint;

import io.github.lightman314.lightmanscurrency.blockentity.CoinMintBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MessageMintCoin {
    private boolean fullStack;
    private BlockPos pos;

    public MessageMintCoin(boolean fullStack, BlockPos pos) {
        this.fullStack = fullStack;
        this.pos = pos;
    }

    public static void encode(MessageMintCoin message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.fullStack);
        buffer.m_130064_(message.pos);
    }

    public static MessageMintCoin decode(FriendlyByteBuf buffer) {
        return new MessageMintCoin(buffer.readBoolean(), buffer.m_130135_());
    }

    public static void handle(MessageMintCoin message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            CoinMintBlockEntity mintEntity;
            BlockEntity blockEntity;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (blockEntity = player.f_19853_.m_7702_(message.pos)) instanceof CoinMintBlockEntity && (mintEntity = (CoinMintBlockEntity)blockEntity).validMintOutput() > 0) {
                mintEntity.mintCoins(message.fullStack ? 64 : 1);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

