/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.item_trader;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.events.ItemTradeEditEvent;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MessageSetTradeItem {
    private BlockPos pos;
    private int tradeIndex;
    private ItemStack newItem;
    int slot;

    public MessageSetTradeItem(BlockPos pos, int tradeIndex, ItemStack newItem, int slot) {
        this.pos = pos;
        this.tradeIndex = tradeIndex;
        this.newItem = newItem;
        this.slot = slot;
    }

    public static void encode(MessageSetTradeItem message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.writeInt(message.tradeIndex);
        buffer.writeItemStack(message.newItem, false);
        buffer.writeInt(message.slot);
    }

    public static MessageSetTradeItem decode(FriendlyByteBuf buffer) {
        return new MessageSetTradeItem(buffer.m_130135_(), buffer.readInt(), buffer.m_130267_(), buffer.readInt());
    }

    public static void handle(MessageSetTradeItem message, java.util.function.Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (blockEntity = player.f_19853_.m_7702_(message.pos)) != null && blockEntity instanceof ItemTraderBlockEntity) {
                ItemTraderBlockEntity traderEntity = (ItemTraderBlockEntity)blockEntity;
                ItemStack oldItem = ItemStack.f_41583_;
                if (message.slot == 1) {
                    oldItem = traderEntity.getTrade(message.tradeIndex).getBarterItem();
                    traderEntity.getTrade(message.tradeIndex).setBarterItem(message.newItem);
                } else {
                    oldItem = traderEntity.getTrade(message.tradeIndex).getSellItem();
                    traderEntity.getTrade(message.tradeIndex).setSellItem(message.newItem);
                }
                ItemTradeEditEvent.ItemTradeItemEditEvent e = new ItemTradeEditEvent.ItemTradeItemEditEvent((Supplier<ITrader>)((Supplier)() -> {
                    BlockEntity te = player.f_19853_.m_7702_(message.pos);
                    if (te instanceof ItemTraderBlockEntity) {
                        return (ItemTraderBlockEntity)te;
                    }
                    return null;
                }), message.tradeIndex, oldItem, message.slot);
                MinecraftForge.EVENT_BUS.post((Event)e);
                traderEntity.markTradesDirty();
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

