/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.item_trader;

import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MessageSetTraderRules {
    private BlockPos pos;
    List<TradeRule> rules;
    int tradeIndex;

    public MessageSetTraderRules(BlockPos pos, List<TradeRule> rules) {
        this.pos = pos;
        this.rules = rules;
        this.tradeIndex = -1;
    }

    public MessageSetTraderRules(BlockPos pos, List<TradeRule> rules, int tradeIndex) {
        this.pos = pos;
        this.rules = rules;
        this.tradeIndex = tradeIndex;
    }

    public static void encode(MessageSetTraderRules message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.m_130079_(TradeRule.writeRules(new CompoundTag(), message.rules));
        buffer.writeInt(message.tradeIndex);
    }

    public static MessageSetTraderRules decode(FriendlyByteBuf buffer) {
        return new MessageSetTraderRules(buffer.m_130135_(), TradeRule.readRules(buffer.m_130260_()), buffer.readInt());
    }

    public static void handle(MessageSetTraderRules message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (blockEntity = player.f_19853_.m_7702_(message.pos)) instanceof ItemTraderBlockEntity) {
                ItemTraderBlockEntity traderEntity = (ItemTraderBlockEntity)blockEntity;
                if (message.tradeIndex >= 0) {
                    ItemTradeData trade = traderEntity.getTrade(message.tradeIndex);
                    if (trade != null) {
                        trade.setRules(message.rules);
                    }
                    traderEntity.markTradesDirty();
                } else {
                    traderEntity.setRules(message.rules);
                    traderEntity.markRulesDirty();
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

